%% style
clear
clc
set(0,'DefaultLineLineWidth',1.5,'DefaultTextFontWeight','bold', ...
    'DefaultTextFontSize',14,'DefaultAxesFontWeight','bold', ...
    'DefaultAxesFontSize',14, 'DefaultLineMarkerSize',10);
set(0,'DefaultAxesFontName', 'Arial')
addpath('../ssr_utility')
%% system

% parameters
rng(5)
omega1 = 3;
omega2 = 5;
omega4 = sqrt(20.5);

% system
xprime = @(x) [x(2), -(omega1)^2*x(1)];
xprime2 = @(x) [x(2), -(omega2)^2*x(1)];
xprime3 = @(x) x(1) - x(3);
xprime4 = @(x) [x(2), -(omega4)^2*x(1)];
xprime5 = @(x) x(5) + 0.3 * x(6) - x(8);
xprime_all = @(x) [xprime(x(1:2)), xprime2(x(3:4)), xprime3(x), xprime4(x(6:7)), xprime5(x)];

% numerical integration
tstep = 0.03;
tspan = (0 : tstep : 200);
y0 = ones(1,8);
opts = odeset('RelTol',1e-6,'AbsTol',1e-6);
[t,y] = ode45(@(t,y) xprime_all(y)',tspan, y0, opts);
sz = 15;
height = 165;
width = 300;
use_colorbar = true;
xlim_ = [25, 35];

% setup example delay points
tau_ = 3.6;
t_example = [27, 27+tau_, 27+2*tau_];
idx_example = 1 + round(t_example / tstep);
z_example = y(idx_example,5);
% add noise
y_noisy = y;
for i = 1 : 8
    sig = (max(y_noisy(:,i))-min(y_noisy(:,i))) * 0.15;
    a_ = sig * sqrt(3);
    y_noisy(:,i) = y_noisy(:,i) + unifrnd(-a_,a_,size(y_noisy(:,i)));
end

% make delay vectors
tau = round(tau_/tstep);
idx = randperm(length(y) - 2*tau);
v1 = y(1:end-2*tau,5);
v2 = y(1+tau:end-tau,5);
v3 = y(1+2*tau:end,5);
v4 = y(1+2*tau:end,3);
v5 = y(1+2*tau:end,8);
v6 = y(1+2*tau:end,6);
v4_noisy = y_noisy(1+2*tau:end,3);
v5_noisy = y_noisy(1+2*tau:end,8);

ylimits = [min(v4_noisy), max(v4_noisy)];
wlimits = [min(v5_noisy), max(v5_noisy)];
%% show dynamics
fig = figure;
plot(t,y_noisy(:,3),'r')
hold on
plot(t,y(:,3),'k')
xlim(xlim_)
ylim(get_ylim(y(:,3)))
yticks([-1,1])
ylabel('Y')
set(gca,'LineWidth',2,'FontSize',16,'FontName','Arial','fontweight','bold',...
    'units','inches','position',[1 1 2 0.6375],'ticklength',[0.04 0.04])
saveas(fig, 'fig5.svg')

fig = figure;
plot(t,y(:,5),'k')
xlim(xlim_)
ylim(get_ylim(y(:,5)))
yticks([0.5,1.5])
hold on
scatter(t_example, z_example, 40, 'g', 'filled')
ylabel('Z')
set(gca,'LineWidth',2,'FontSize',16,'FontName','Arial','fontweight','bold',...
    'units','inches','position',[1 1 2 0.6375],'ticklength',[0.04 0.04])
saveas(fig, 'fig6.svg')

fig = figure;
plot(t,y_noisy(:,8),'r')
hold on
plot(t,y(:,8),'k')
xlim(xlim_)
ylim(get_ylim(y(:,8)))
yticks([0.8,1.3])
ylabel('W')
set(gca,'LineWidth',2,'FontSize',16,'FontName','Arial','fontweight','bold',...
    'units','inches','position',[1 1 2 0.6375],'ticklength',[0.04 0.04])
saveas(fig, 'fig7.svg')

fig = figure;
plot(t,y(:,6),'k')
xlim(xlim_)
ylim(get_ylim(y(:,6)))
yticks([-1,1])
ylabel('V')
set(gca,'LineWidth',2,'FontSize',16,'FontName','Arial','fontweight','bold',...
    'units','inches','position',[1 1 2 0.6375],'ticklength',[0.04 0.04])
saveas(fig, 'fig9.svg')
%%
fig = figure;
plot(t,y(:,1),'k')
xlim(xlim_)
ylim(get_ylim(y(:,1)))
yticks([-1,1])
ylabel('X')
set(gca,'LineWidth',2,'FontSize',16,'FontName','Arial','fontweight','bold',...
    'units','inches','position',[1 1 2 0.6375],'ticklength',[0.04 0.04])
saveas(fig, 'fig10.svg')
%% noiseless map from z to y


fig1 = createfigure(v1(idx), v2(idx), v3(idx), sz, v4(idx), ...
    [107.700003547544 12.6000036576633], width, height);
hold on
scatter3(z_example(1), z_example(2), z_example(3), 40, 'g', 'filled')
xlabel('Z(t - 2\tau)')
ylabel('Z(t - \tau)')
zlabel('Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'Y(t)')
    h.Ticks = [-1,0,1];
end
xlim([0.4, 1.65])
ylim([0.4, 1.65])
zlim([0.4, 1.65])
xticks([0.5, 1.5])
yticks([0.5, 1, 1.5])
zticks([0.5, 1, 1.5])
grid on
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
caxis(ylimits)
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig1,'fig1.svg')
saveas(fig1,'fig1.pdf')

%% noiseless map from z to w

fig2 = createfigure(v1(idx), v2(idx), v3(idx), sz, v5(idx), ...
    [107.700003547544 12.6000036576633], width, height);
xlabel('Z(t - 2\tau)')
ylabel('Z(t - \tau)')
zlabel('Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'W(t)')
    %h.Ticks = [0.8,1.3];
end
xlim([0.4, 1.65])
ylim([0.4, 1.65])
zlim([0.4, 1.65])
xticks([0.5, 1.5])
yticks([0.5, 1, 1.5])
zticks([0.5, 1, 1.5])
grid on
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
%caxis(wlimits)
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig2,'fig2.svg')
saveas(fig2,'fig2.pdf')

%% noiseless map from z to v

fig8 = createfigure(v1(idx), v2(idx), v3(idx), sz, v6(idx), ...
    [107.700003547544 12.6000036576633], width, height);
xlabel('Z(t - 2\tau)')
ylabel('Z(t - \tau)')
zlabel('Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'V(t)')
    h.Ticks = [-1.0,1.0];
end
xlim([0.4, 1.65])
ylim([0.4, 1.65])
zlim([0.4, 1.65])
xticks([0.5, 1.5])
yticks([0.5, 1, 1.5])
zticks([0.5, 1, 1.5])
grid on
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig8,'fig8.svg')
saveas(fig8,'fig8.pdf')

%% noisy map from z to y

fig3 = createfigure(v1(idx), v2(idx), v3(idx), sz, v4_noisy(idx), ...
    [107.700003547544 12.6000036576633], width, height);
xlabel('Z(t - 2\tau)')
ylabel('Z(t - \tau)')
zlabel('Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'Y(t)')
    h.Ticks = [-1,0,1];
end
xlim([0.4, 1.65])
ylim([0.4, 1.65])
zlim([0.4, 1.65])
xticks([0.5, 1.5])
yticks([0.5, 1, 1.5])
zticks([0.5, 1, 1.5])
grid on
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
caxis(ylimits)
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig3,'fig3.svg')
saveas(fig3,'fig3.pdf')

%% noisy map from z to w

fig4 = createfigure(v1(idx), v2(idx), v3(idx), sz, v5_noisy(idx), ...
    [107.700003547544 12.6000036576633], width, height);
xlabel('Z(t - 2\tau)')
ylabel('Z(t - \tau)')
zlabel('Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'W(t)')
    h.Ticks = [0.8,1.3];
end
xlim([0.4, 1.65])
ylim([0.4, 1.65])
zlim([0.4, 1.65])
xticks([0.5, 1.5])
yticks([0.5, 1, 1.5])
zticks([0.5, 1, 1.5])
grid on
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
caxis(wlimits)
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig4,'fig4.svg')
saveas(fig4,'fig4.pdf')

%%
close all

%%
function ylim = get_ylim(y)
amp = max(y) - min(y);
ylim = [min(y) - amp * 0.35, max(y) + amp * 0.35];
end