##### LOAD LIBRARIES #####

import sys
sys.path.append('../ssr_benchmark/')
import dtpy_ccm_legacy as ccm
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns

def pipeline(x, min_lib_size, max_lib_size, step, tau, E, lib, pred):
    separate = ccm.run_ccm(data=x, min_lib_size=min_lib_size, max_lib_size=max_lib_size,
                      lib_size_step=step, remove_temp_files=True, prediction_horizon=[0],
                      min_E=E, max_E=E, min_tau=tau, max_tau=tau, lib=lib, pred=pred)
    lib_interspersed = (lib[0], pred[1])
    interspersed = ccm.run_ccm(data=x, min_lib_size=min_lib_size, max_lib_size=max_lib_size,
                      lib_size_step=step, remove_temp_files=True, prediction_horizon=[0],
                      min_E=E, max_E=E, min_tau=tau, max_tau=tau,
                      lib=lib_interspersed, pred=lib_interspersed)
    return separate, interspersed


##### LOAD DATA #####
X = np.loadtxt('data/X.csv', delimiter=',')
Y = np.loadtxt('data/Y.csv', delimiter=',')

# System 1: oscillation
sys=1
min_lib_size = 10
max_lib_size = 310
step = 20
tau = 120
E = 3
lib = (1, 500)
pred = (501,1000)
x = np.concatenate([X[:,(sys-1,)], Y[:,(sys-1,)]], axis=1)
separate, interspersed = pipeline(x, min_lib_size, max_lib_size, step, tau, E, lib, pred)
separate.to_csv(f'data/sys{sys}_separate_XmapY.csv')
interspersed.to_csv(f'data/sys{sys}_interspersed_XmapY.csv')
separate, interspersed = pipeline(x[:,(1,0)], min_lib_size, max_lib_size, step, tau, E, lib, pred)
separate.to_csv(f'data/sys{sys}_separate_YmapX.csv')
interspersed.to_csv(f'data/sys{sys}_interspersed_YmapX.csv')

# System 2: nonrev_pos
sys=2
min_lib_size = 10
max_lib_size = 310
step = 20
tau = 30
E = 3
lib = (1, 200)
pred = (201,400)
x = np.concatenate([X[:,(sys-1,)], Y[:,(sys-1,)]], axis=1)
separate, interspersed = pipeline(x, min_lib_size, max_lib_size, step, tau, E, lib, pred)
separate.to_csv(f'data/sys{sys}_separate_XmapY.csv')
interspersed.to_csv(f'data/sys{sys}_interspersed_XmapY.csv')
separate, interspersed = pipeline(x[:,(1,0)], min_lib_size, max_lib_size, step, tau, E, lib, pred)
separate.to_csv(f'data/sys{sys}_separate_YmapX.csv')
interspersed.to_csv(f'data/sys{sys}_interspersed_YmapX.csv')

# System 3: nonrev_neg
sys=3
min_lib_size = 10
max_lib_size = 310
step = 20
tau = 50
E = 2
lib = (1, 200)
pred = (201,400)
x = np.concatenate([X[:,(sys-1,)], Y[:,(sys-1,)]], axis=1)
separate, interspersed = pipeline(x, min_lib_size, max_lib_size, step, tau, E, lib, pred)
separate.to_csv(f'data/sys{sys}_separate_XmapY.csv')
interspersed.to_csv(f'data/sys{sys}_interspersed_XmapY.csv')
separate, interspersed = pipeline(x[:,(1,0)], min_lib_size, max_lib_size, step, tau, E, lib, pred)
separate.to_csv(f'data/sys{sys}_separate_YmapX.csv')
interspersed.to_csv(f'data/sys{sys}_interspersed_YmapX.csv')
