##### LOAD LIBRARIES #####

import sys
sys.path.append('../ssr_benchmark/')
import dtpy_ccm_legacy as ccm
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns

def pipeline(x, min_lib_size, max_lib_size, step, tau, E, lib, pred, pred_lag, use_surr=True):
    nolag = ccm.run_ccm(data=x, min_lib_size=min_lib_size, max_lib_size=max_lib_size,
                      lib_size_step=step, remove_temp_files=True, prediction_horizon=[0],
                      min_E=E, max_E=E, min_tau=tau, max_tau=tau, lib=lib, pred=pred, replace=False)
    surr_data = None
    non_rand = None
    if use_surr:
        _, surr_data = ccm.run_ccm(data=x, min_lib_size=-1, max_lib_size=-1,
                          lib_size_step=1, remove_temp_files=True, prediction_horizon=[0],
                          min_E=E, max_E=E, min_tau=tau, max_tau=tau, lib=lib, pred=pred,
                          num_samples=1, n_surr_datasets=500, surr_type='ebisuzaki',
                          surr_test=True, rand_libs=False)

        non_rand = ccm.run_ccm(data=x, min_lib_size=-1, max_lib_size=-1,
                          lib_size_step=1, remove_temp_files=True, prediction_horizon=[0],
                          min_E=E, max_E=E, min_tau=tau, max_tau=tau, lib=lib, pred=pred,
                          num_samples=1, surr_test=False, rand_libs=False)

    withlag = ccm.run_ccm(data=x, min_lib_size=max_lib_size, max_lib_size=max_lib_size,
                      remove_temp_files=True, prediction_horizon=pred_lag, min_E=E,
                      max_E=E, min_tau=tau, max_tau=tau, lib=lib, pred=pred, rand_libs=False,
                      num_samples=1)

    return nolag, withlag, surr_data, non_rand


##### LOAD DATA #####
X = np.loadtxt('data/X.csv', delimiter=',')
Y = np.loadtxt('data/Y.csv', delimiter=',')

# System 1: strong forcing
sys=1
min_lib_size = 18
max_lib_size = 198
step = 20
tau = 2
E = 2
lib = (801, 1000)
pred = (1001,2000)
pred_lag = np.arange(-10, 11)

x = np.concatenate([X[:2000,(sys-1,)], Y[:2000,(sys-1,)]], axis=1)
nolag, lagtest, surr_data, non_rand = pipeline(x, min_lib_size, max_lib_size, step, tau, E, lib, pred, pred_lag)
nolag.to_csv(f'data/sys{sys}_nolag.csv')
lagtest.to_csv(f'data/sys{sys}_lagtest.csv')
surr_data.to_csv(f'data/sys{sys}_surrogate.csv')
non_rand.to_csv(f'data/sys{sys}_non_rand.csv')

# System 2: counterexample
sys=2
min_lib_size = 16
max_lib_size = 196
step = 20
tau = 2
E = 3
lib = (801, 1000)
pred = (1001,2000)
pred_lag = np.arange(-10, 11)

x = np.concatenate([X[:2000,(sys-1,)], Y[:2000,(sys-1,)]], axis=1)
nolag, lagtest, surr_data, non_rand = pipeline(x, min_lib_size, max_lib_size, step, tau, E, lib, pred, pred_lag)
nolag.to_csv(f'data/sys{sys}_nolag.csv')
lagtest.to_csv(f'data/sys{sys}_lagtest.csv')
surr_data.to_csv(f'data/sys{sys}_surrogate.csv')
non_rand.to_csv(f'data/sys{sys}_non_rand.csv')

# System 3: oscillation
sys=3
min_lib_size = 16
max_lib_size = 156
step = 20
tau = 72
E = 3
lib = (701, 1000)
pred = (1001,2000)
pred_lag = np.arange(-25, 26, 1)

x = np.concatenate([X[:2000,(sys-1,)], Y[:2000,(sys-1,)]], axis=1)
nolag, lagtest, surr_data, non_rand = pipeline(x, min_lib_size, max_lib_size, step, tau, E, lib, pred, pred_lag)
nolag.to_csv(f'data/sys{sys}_nolag.csv')
lagtest.to_csv(f'data/sys{sys}_lagtest.csv')
surr_data.to_csv(f'data/sys{sys}_surrogate.csv')
non_rand.to_csv(f'data/sys{sys}_non_rand.csv')

# System 4: proxy
sys=4
min_lib_size = 18
max_lib_size = 198
step = 20
tau = 2
E = 2
lib = (801, 1000)
pred = (1001,2000)
pred_lag = np.arange(-10, 11)

x = np.concatenate([X[:2000,(sys-1,)], Y[:2000,(sys-1,)]], axis=1)
nolag, lagtest, surr_data, non_rand = pipeline(x, min_lib_size, max_lib_size, step, tau, E, lib, pred, pred_lag)
nolag.to_csv(f'data/sys{sys}_nolag.csv')
lagtest.to_csv(f'data/sys{sys}_lagtest.csv')
surr_data.to_csv(f'data/sys{sys}_surrogate.csv')
non_rand.to_csv(f'data/sys{sys}_non_rand.csv')

# System 5: strong forcing, other way
sys=5
min_lib_size = 19
max_lib_size = 199
step = 20
tau = 1
E = 2
lib = (801, 1000)
pred = (1001,2000)
pred_lag = np.arange(-10, 11)

x = np.concatenate([X[:2000,(sys-1,)], Y[:2000,(sys-1,)]], axis=1)
nolag, lagtest, surr_data, non_rand = pipeline(x, min_lib_size, max_lib_size, step, tau, E, lib, pred, pred_lag)
nolag.to_csv(f'data/sys{sys}_nolag.csv')
lagtest.to_csv(f'data/sys{sys}_lagtest.csv')
surr_data.to_csv(f'data/sys{sys}_surrogate.csv')
non_rand.to_csv(f'data/sys{sys}_non_rand.csv')

# System 6: common cause
sys=6
min_lib_size = 18
max_lib_size = 198
step = 20
tau = 1
E = 3
lib = (801, 1000)
pred = (1001,2000)
pred_lag = np.arange(-10, 11)

x = np.concatenate([X[:2000,(sys-1,)], Y[:2000,(sys-1,)]], axis=1)
nolag, lagtest, surr_data, non_rand = pipeline(x, min_lib_size, max_lib_size, step, tau, E, lib, pred, pred_lag)
nolag.to_csv(f'data/sys{sys}_nolag.csv')
lagtest.to_csv(f'data/sys{sys}_lagtest.csv')
surr_data.to_csv(f'data/sys{sys}_surrogate.csv')
non_rand.to_csv(f'data/sys{sys}_non_rand.csv')
