%% style
set(0,'DefaultLineLineWidth',1.5,'DefaultTextFontWeight','bold', ...
    'DefaultTextFontSize',14,'DefaultAxesFontWeight','bold', ...
    'DefaultAxesFontSize',14, 'DefaultLineMarkerSize',10);
set(0,'DefaultAxesFontName', 'Arial')
rng(5)
%% simple trends

t = linspace(1,20,400);
x = sin(t) + 0.5*t;
y = 0.1 * (t-10).^2;
tau = 50;
%%
fig1 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
plot(t,x,t,y)
xlabel('time')
legend('x','y', 'location', 'northwest')
saveas(fig1,'raw/fig1.svg')
csvwrite('data/system1.csv', [x',y'])
csvwrite('data/time1.csv', t)
%%
fig2 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
scatter(x(1:end-tau),x(1+tau:end), 40, y(1+tau:end),'filled')
h = colorbar;
title(h,'Y(t)')
%title('Delay space of X')
xlabel('X(t - \tau)')
ylabel('X(t)')
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
saveas(fig2,'raw/fig2.svg')
%%
fig3 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
scatter(y(1:end-tau),y(1+tau:end), 40, x(1+tau:end),'filled')
h = colorbar;
title(h,'X(t)')
%title('Delay space of Y')
xlabel('Y(t - \tau)')
ylabel('Y(t)')
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
saveas(fig3,'raw/fig3.svg')
%% check for simple trends
fig2b = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
scatter(x(1:end-tau),x(1+tau:end), 40, t(1+tau:end),'filled')
h = colorbar;
title(h,'t')
%title('Delay space of X')
xlabel('X(t - \tau)')
ylabel('X(t)')
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
saveas(fig2b,'raw/fig2b.svg')
saveas(fig2b,'raw/fig2b.pdf')

fig3b = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
scatter(y(1:end-tau),y(1+tau:end), 40, t(1+tau:end),'filled')
h = colorbar;
title(h,'t')
%title('Delay space of Y')
xlabel('Y(t - \tau)')
ylabel('Y(t)')
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
saveas(fig3b,'raw/fig3b.svg')
saveas(fig3b,'raw/fig3b.pdf')

fig2c = figure('Renderer', 'painters', 'Position', [10 10 20 180]);
scatter(zeros(length(t),1),t,20,log(x),'MarkerFaceColor','flat','MarkerEdgeColor','none')
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
title('log(X)')
ylabel('t')
saveas(fig2c,'raw/fig2c.svg')
saveas(fig2c,'raw/fig2c.pdf')

fig3c = figure('Renderer', 'painters', 'Position', [10 10 20 180]);
scatter(zeros(length(t),1),t,20,log(y),'MarkerFaceColor','flat','MarkerEdgeColor','none')
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
title('log(Y)')
ylabel('t')
saveas(fig3c,'raw/fig3c.svg')
saveas(fig3c,'raw/fig3c.pdf')
%% oscillations with integer multiples % can redo this with a different approach...
% tau = 30;
% 
% omega1 = 1;
% omega2 = 5;
% 
% xprime = @(x) [x(2), -(omega1)^2*x(1)];
% xprime2 = @(x) [x(2), -(omega2)^2*x(1)];
% xprime_all = @(x) [xprime(x(1:2)), xprime2(x(3:4))];
% 
% % numerical integration
% tspan = (0 : 0.03 : 50);
% y0 = ones(1,4);
% opts = odeset('RelTol',1e-6,'AbsTol',1e-6);
% [t,states] = ode45(@(t,y) xprime_all(y)',tspan, y0, opts);
% x = states(:,1);
% y = states(:,3);
% %%
% tpt_show = 500;
% fig3_5 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
% plot(t(1:tpt_show),x(1:tpt_show), t(1:tpt_show), y(1:tpt_show))
% xlabel('time')
% saveas(fig3_5,'fig3_5.svg')
% %%
% idx = randperm(length(y) - tau);
% v1 = x(1:end-tau);
% v2 = x(1+tau:end);
% v3 = y(1+tau:end);
% 
% fig4 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
% scatter(v1(idx),v2(idx), 40, v3(idx), 'filled')
% h = colorbar;
% title(h,'Y(t)')
% title('Delay space of X')
% xlabel('X(t - \tau)')
% ylabel('X(t)')
% saveas(fig4,'fig4.svg')
% %%
% 
% idx = randperm(length(y) - tau);
% v1 = y(1:end-tau);
% v2 = y(1+tau:end);
% v3 = x(1+tau:end);
% 
% fig5 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
% scatter(v1(idx),v2(idx), 40, v3(idx), 'filled')
% h = colorbar;
% title(h,'X(t)')
% title('Delay space of Y')
% xlabel('Y(t - \tau)')
% ylabel('Y(t)')
% saveas(fig5,'fig5.svg')

%% strong forcing
n_tpt = 2000;
r = 3.61;
nextstate = @(x) [x(1) * r * (1 - x(1)), ...
                  x(2) * r * (1 - x(1))];
t = 1 : n_tpt;
states = zeros(n_tpt, 2);
states(1,:) = [0.4, 0.7];
for i = 2 : n_tpt
    states(i, :) = nextstate(states(i-1,:));
end
states = states(2:end,:);
x = states(:,1);
y = states(:,2);
t = t(2:end);
tau = 1;
%%
fig6 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
plot(t(100:140),x(100:140),t(100:140),y(100:140))
xlabel('time')
legend('X','Y')
saveas(fig6,'raw/fig6.svg')
%%
n_plot = 1000;
idx = randperm(n_plot);
v1 = y(1:end-tau);
v2 = y(1+tau:end);
v3 = x(1+tau:end);

fig7 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);

scatter(v1(idx),v2(idx), 40, v3(idx),'filled')
h = colorbar;
title(h,'X(t)')
%title('Delay space of Y')
xlabel('Y(t - \tau)')
ylabel('Y(t)')
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
saveas(fig7,'raw/fig7.svg')
%%

v1 = x(1:end-tau);
v2 = x(1+tau:end);
v3 = y(1+tau:end);

fig8 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);

scatter(v1(idx),v2(idx), 40, v3(idx),'filled')
h = colorbar;
title(h,'Y(t)')
%title('Delay space of X')
xlabel('X(t - \tau)')
ylabel('X(t)')
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
saveas(fig8,'raw/fig8.svg')
csvwrite('data/system3.csv', [x(1:n_plot+1),y(1:n_plot+1)])
csvwrite('data/time3.csv', t(1:n_plot+1))
%% non-generic causee

sig = 10;
beta = 8/3;
rho = 28;
xprime = @(t,x) [-sig*x(1) + sig*x(2); rho*x(1) - x(2) - x(1)*x(3); -beta*x(3) + x(1)*x(2)];
opts = odeset('RelTol',1e-6,'AbsTol',1e-6);
y0 = [1,1,1];
tspan = (0 : 0.07 : 400);
[t,states] = ode45(xprime,tspan, y0, opts);
states = states(1000:end,:);
x = states(:,1);
y = states(:,2);
z = states(:,3);

%%
fig9 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
plot(t(1:250),x(1:250),t(1:250),z(1:250))
xlabel('time')
legend('x','z')
saveas(fig9,'raw/fig9.svg')

%%
tau = 2;
n_plot = 1500;
idx = randperm(n_plot);
v1 = z(1:end-2*tau);
v2 = z(1+tau:end-tau);
v3 = z(1+2*tau:end);
v4 = x(1+2*tau:end);
fig10 = createfigure(v1(idx), v2(idx), v3(idx), 10, v4(idx), ...
    [36 49.8], 240, 180);
h = colorbar;
%title('Delay space of Z')
xlabel('Z(t - 2 \tau)')
ylabel('Z(t - \tau)')
zlabel('Z(t)')
title(h,'X(t)')
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
saveas(fig10,'raw/fig10.svg')
saveas(fig10,'raw/fig10.pdf')
csvwrite('data/system4.csv', [x(1:n_plot+2*tau), y(1:n_plot+2*tau),...
                              z(1:n_plot+2*tau)])
csvwrite('data/time4.csv', t(1:n_plot+2*tau));
%%

v1 = x(1:end-2*tau);
v2 = x(1+tau:end-tau);
v3 = x(1+2*tau:end);
v4 = z(1+2*tau:end);
fig11 = createfigure(v1(idx), v2(idx), v3(idx), 10, v4(idx), ...
    [36 49.8], 240, 180);
h = colorbar;
%title('Delay space of X')
xlabel('X(t - 2 \tau)')
ylabel('X(t - \tau)')
zlabel('X(t)')
title(h,'Z(t)')
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
saveas(fig11,'raw/fig11.svg')
saveas(fig11,'raw/fig11.pdf')

close all
%%
function figure1 = createfigure(X1, Y1, Z1, S1, C1, camera, width, height)
%CREATEFIGURE(X1, Y1, Z1, S1, C1)
%  X1:  scatter3 x
%  Y1:  scatter3 y
%  Z1:  scatter3 z
%  S1:  scatter3 s
%  C1:  scatter3 c

%  Auto-generated by MATLAB on 18-Oct-2019 12:17:25

% Create figure
figure1 = figure('Renderer', 'painters', 'Position', [10 10 width height]);

% Create axes
axes1 = axes('Parent',figure1);
hold(axes1,'on');

% Create scatter3
scatter3(X1,Y1,Z1,S1,C1,'MarkerFaceColor','flat','MarkerEdgeColor','none');

view(axes1, camera);
end