%% style
clear
clc
set(0,'DefaultLineLineWidth',1.5,'DefaultTextFontWeight','bold', ...
    'DefaultTextFontSize',14,'DefaultAxesFontWeight','bold', ...
    'DefaultAxesFontSize',14, 'DefaultLineMarkerSize',10);
set(0,'DefaultAxesFontName', 'Arial')
addpath('../ssr_utility')
%% system

% parameters
rng(5)
omega1 = 3;
omega2 = 5;
omega4 = sqrt(20.5);

% system
xprime = @(x) [x(2), -(omega1)^2*x(1)];
xprime2 = @(x) [x(2), -(omega2)^2*x(1)];
xprime3 = @(x) x(1) - x(3);
xprime4 = @(x) [x(2), -(omega4)^2*x(1)];
xprime5 = @(x) x(5) + 0.3 * x(6) - x(8);
xprime_all = @(x) [xprime(x(1:2)), xprime2(x(3:4)), xprime3(x), xprime4(x(6:7)), xprime5(x)];

% numerical integration
tspan = (0 : 0.03 : 60);
y0 = ones(1,8);
opts = odeset('RelTol',1e-6,'AbsTol',1e-6);
[t,y] = ode45(@(t,y) xprime_all(y)',tspan, y0, opts);
sz = 15;
height = 165;
width = 300;
use_colorbar = true;
xlim_ = [2, 15];

% make delay vectors
tau = 120;
idx = randperm(length(y) - 2*tau);
v1 = y(1:end-2*tau,5);
v2 = y(1+tau:end-tau,5);
v3 = y(1+2*tau:end,5);
v4 = y(1+2*tau:end,3);
v5 = y(1+2*tau:end,1);

% show 3 points
pts = [5.4, 9, 12.6];
%% show dynamics
fig = figure;
plot(t,y(:,1),'k')
xlim(xlim_)
ylim(get_ylim(y(:,1)))
%yticks([-1,1])
ylabel('X')
set(gca,'LineWidth',2,'FontSize',16,'FontName','Arial','fontweight','bold',...
    'units','inches','position',[1 1 2 0.85],'ticklength',[0.04 0.04])
saveas(fig, 'fig5.svg')

fig = figure;
plot(t,y(:,3),'k')
xlim(xlim_)
ylim(get_ylim(y(:,3)))
%yticks([0.8,1.3])
ylabel('Y')
set(gca,'LineWidth',2,'FontSize',16,'FontName','Arial','fontweight','bold',...
    'units','inches','position',[1 1 2 0.85],'ticklength',[0.04 0.04])
saveas(fig, 'fig7.svg')

fig = figure;
plot(t,y(:,5),'k')
hold on
scatter(t(1+round(pts/0.03)), y(1+round(pts/0.03),5), 40, 'k', 'filled')
xlim(xlim_)
ylim(get_ylim(y(:,5)))
plot([7.2, 2*pi+7.2], [1.7,1.7], 'r', 'linewidth', 5)
%yticks([0.5,1.5])
ylabel('Z')
set(gca,'LineWidth',2,'FontSize',16,'FontName','Arial','fontweight','bold',...
    'units','inches','position',[1 1 2 0.85],'ticklength',[0.04 0.04])
saveas(fig, 'fig6.svg')

%% map from z delay space to y

fig1 = createfigure(v1(idx), v2(idx), v3(idx), sz, v4(idx), ...
    [107.700003547544 12.6000036576633], width, height);
xlabel('Z(t - 2\tau)')
ylabel('Z(t - \tau)')
zlabel('Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'Y(t)')
end
xl = xlim;
yl = ylim;
zl = zlim;
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig1,'fig1.svg')
saveas(fig1,'fig1.pdf')

%% make state space colored by time
% numerical integration
timestep = 0.005;
pts_ = pts - 7.2;
tspan = [0,7.2 : timestep : 2*pi+7.2]; % starting at 0 to sync with other panels
y0 = ones(1,8);
opts = odeset('RelTol',1e-6,'AbsTol',1e-6);
[t,y] = ode45(@(t,y) xprime_all(y)',tspan, y0, opts);
t = t(2:end); y = y(2:end,:);
sz = 15;
use_colorbar = true;
width = 260;
fig4 = createfigure(y(:,1), y(:,3), y(:,5), sz, t, ...
    [-15.899999582437 -12.000001369471], width, height);
idx_pts = 1+round(pts_(2:3)/timestep);
scatter3(y(idx_pts,1), y(idx_pts,3), y(idx_pts,5), sz*2, 'k', 'filled')
xlabel('X(t)')
ylabel('Y(t)')
zlabel('Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'t')
end
%colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
colormap(hsv(200));
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig4,'fig8_hsv.svg')
saveas(fig4,'fig8_hsv.pdf')

% and colored by Z
fig4 = createfigure(y(:,1), y(:,3), y(:,5), sz, y(:,5), ...
    [-15.899999582437 -12.000001369471], width, height);
pts_(1) = pts_(1) + 2*pi;
idx_pts = 1+round(pts_/timestep);
scatter3(y(idx_pts,1), y(idx_pts,3), y(idx_pts,5), sz*2, 'r', 'filled')
xlabel('X(t)')
ylabel('Y(t)')
zlabel('Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'Z(t)')
end
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig4,'fig10.svg')
saveas(fig4,'fig10.pdf')

% and colored by Y
fig4 = createfigure(y(:,1), y(:,3), y(:,5), sz, y(:,3), ...
    [-15.899999582437 -12.000001369471], width, height);
idx_pts = 1+round(pts_(2:3)/timestep);
scatter3(y(idx_pts,1), y(idx_pts,3), y(idx_pts,5), sz*2, 'r', 'filled')
xlabel('X(t)')
ylabel('Y(t)')
zlabel('Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'Y(t)')
end
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig4,'fig11.svg')
saveas(fig4,'fig11.pdf')

% and colored by 0.99 * Z + 0.01 * Y
fig4 = createfigure(y(:,1), y(:,3), y(:,5), sz, y(:,3)*0.99+y(:,5)*0.01, ...
    [-15.899999582437 -12.000001369471], width, height);
idx_pts = 1+round(pts_(2:3)/timestep);
scatter3(y(idx_pts,1), y(idx_pts,3), y(idx_pts,5), sz*2, 'r', 'filled')
xlabel('X(t)')
ylabel('Y(t)')
zlabel('Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'g(t)')
end
title('g(t)=0.95Y(t)+0.05Z(t)')
colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig4,'fig12.svg')
saveas(fig4,'fig12.pdf')
%% make delay space colored by time
% numerical integration
timestep = 0.005;
tau = 3.6/timestep;
tspan = 0 : timestep : 2*pi + 2*tau*timestep;
y0 = ones(1,8);
opts = odeset('RelTol',1e-6,'AbsTol',1e-6);
[t,y] = ode45(@(t,y) xprime_all(y)',tspan, y0, opts);
sz = 15;
use_colorbar = true;
width = 300;
% delay space of Z
fig4 = createfigure(y(1:end-2*tau,5), y(1+tau:end-tau,5), y(1+2*tau:end,5), ...
    sz, t(1+2*tau:end), ...
    [107.700003547544 12.6000036576633], width, height);
idx_pts = 1+round(pts/timestep);
scatter3(y(idx_pts(1),5), y(idx_pts(2),5), y(idx_pts(3),5), sz*2, 'k', 'filled')
xlabel('Z(t - 2\tau)')
ylabel('Z(t - \tau)')
zlabel('Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'t')
end
%colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
colormap(hsv(200));
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig4,'fig9_hsv.svg')
saveas(fig4,'fig9_hsv.pdf')

% delay space of Y
% fig4 = createfigure(y(1:end-2*tau,3), y(1+tau:end-tau,3), y(1+2*tau:end,3), ...
%     sz, t(1+2*tau:end), ...
%     [107.700003547544 12.6000036576633], width, height);
% idx_pts = 1+round(pts/timestep);
% scatter3(y(idx_pts(1),3), y(idx_pts(2),3), y(idx_pts(3),3), sz*2, 'k', 'filled')
% xlabel('Y(t - 2\tau)')
% ylabel('Y(t - \tau)')
% zlabel('Y(t)')
% if use_colorbar
%     h = colorbar;
%     title(h,'t')
% end
% %colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
% colormap(hsv(200));
% set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
% saveas(fig4,'fig13_hsv.svg')
% saveas(fig4,'fig13_hsv.pdf')

%% delay space of 0.95Y+0.05Z
tau_ = 3.6;
tau = tau_/timestep;
tspan = 0 : timestep : 2*pi + 2*tau*timestep;
y0 = ones(1,8);
opts = odeset('RelTol',1e-6,'AbsTol',1e-6);
[t,y] = ode45(@(t,y) xprime_all(y)',tspan, y0, opts);

obs_fxn = 0.95 * y(:,3) + 0.05 * y(:,5);
fig4 = createfigure(obs_fxn(1:end-2*tau), obs_fxn(1+tau:end-tau), obs_fxn(1+2*tau:end), ...
    sz, 2*tau_+mod(t(1+2*tau:end), 2*pi), ...
    [107.700003547544 12.6000036576633], width, height);
idx_pts = 1+round(pts/timestep);
%scatter3(obs_fxn(idx_pts(1)), obs_fxn(idx_pts(2)), obs_fxn(idx_pts(3)), sz*2, 'k', 'filled')
xlabel('g(t - 2\tau)')
ylabel('g(t - \tau)')
zlabel('g(t)')
title('g(t)=0.95Y(t)+0.05Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'t')
end
%colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
colormap(hsv(200));
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig4,'fig14_hsv.svg')
saveas(fig4,'fig14_hsv.pdf')

%% delay space of 0.95Y+0.05Z, but zoomed in
tau_ = 3.6;
tau = tau_/timestep;
tspan = 0 : timestep : 80;
y0 = ones(1,8);
opts = odeset('RelTol',1e-6,'AbsTol',1e-6);
[t,y] = ode45(@(t,y) xprime_all(y)',tspan, y0, opts);

obs_fxn = 0.95 * y(:,3) + 0.05 * y(:,5);
fig4 = createfigure(obs_fxn(1:end-2*tau), obs_fxn(1+tau:end-tau), obs_fxn(1+2*tau:end), ...
    sz, 2*tau_+mod(t(1+2*tau:end), 2*pi), ...
    [107.700003547544 12.6000036576633], width, height);
idx_pts = 1+round(pts/timestep);
%scatter3(obs_fxn(idx_pts(1)), obs_fxn(idx_pts(2)), obs_fxn(idx_pts(3)), sz*2, 'k', 'filled')
xlabel('g(t - 2\tau)')
ylabel('g(t - \tau)')
zlabel('g(t)')
title('g(t)=0.95Y(t)+0.05Z(t)')
if use_colorbar
    h = colorbar;
    title(h,'t')
end
xlim([0.998858186571996 1.03833268950556]);
ylim([0.546027368869735 0.861823392338241]);
zlim([-0.30549706663847 0.0971428632838744]);
view([132.278687124981 -24.3089081575848]);
%colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
colormap(hsv(200));
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig4,'fig15_hsv.svg')
saveas(fig4,'fig15_hsv.pdf')

% similar for Y

fig4 = createfigure(y(1:end-2*tau,3), y(1+tau:end-tau,3), y(1+2*tau:end,3), ...
    sz, 2*tau_+mod(t(1+2*tau:end), 2*pi), ...
    [107.700003547544 12.6000036576633], width, height);
idx_pts = 1+round(pts/timestep);
%scatter3(obs_fxn(idx_pts(1)), obs_fxn(idx_pts(2)), obs_fxn(idx_pts(3)), sz*2, 'k', 'filled')
xlabel('Y(t - 2\tau)')
ylabel('Y(t - \tau)')
zlabel('Y(t)')
title('Y(t)')
if use_colorbar
    h = colorbar;
    title(h,'t')
end
xlim([0.998858186571996 1.03833268950556]);
ylim([0.546027368869735 0.861823392338241]);
zlim([-0.30549706663847 0.0971428632838744]);
view([132.278687124981 -24.3089081575848]);
%colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
colormap(hsv(200));
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig4,'fig16_hsv.svg')
saveas(fig4,'fig16_hsv.pdf')

%% ... and Y zoomed out
tspan = 0 : timestep : 40;
y0 = ones(1,8);
opts = odeset('RelTol',1e-6,'AbsTol',1e-6);
[t,y] = ode45(@(t,y) xprime_all(y)',tspan, y0, opts);
fig4 = createfigure(y(1:end-2*tau,3), y(1+tau:end-tau,3), y(1+2*tau:end,3), ...
    sz, 2*tau_+mod(t(1+2*tau:end), 2*pi), ...
    [107.700003547544 12.6000036576633], width, height);
idx_pts = 1+round(pts/timestep);
%scatter3(obs_fxn(idx_pts(1)), obs_fxn(idx_pts(2)), obs_fxn(idx_pts(3)), sz*2, 'k', 'filled')
xlabel('Y(t - 2\tau)')
ylabel('Y(t - \tau)')
zlabel('Y(t)')
title('Y(t)')
if use_colorbar
    h = colorbar;
    title(h,'t')
end
%colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
colormap(hsv(200));
set(gca,'LineWidth',2,'FontSize',14,'FontName','Arial','fontweight','bold')
saveas(fig4,'fig17_hsv.svg')
saveas(fig4,'fig17_hsv.pdf')


%%
t = linspace(0, 2*pi, 500);
fig5 = figure;
scatter(sin(t), cos(t), 40, 2*tau_+mod(t, 2*pi), 'filled')
hold on
scatter(sin(2*pi/3), cos(2*pi/3),'k^', 'filled')
scatter(sin(2*2*pi/3), cos(2*2*pi/3),'rv', 'filled')
scatter(sin(2*pi), cos(2*pi),'k', 'filled')
xticks([])
yticks([])
colormap(hsv(200));
set(gca,'LineWidth',2,'FontSize',16,'FontName','Arial','fontweight','bold',...
    'units','inches','position',[1 1 1 1],'ticklength',[0.04 0.04])
saveas(fig5, 'fig16_timering.svg')
saveas(fig5, 'fig16_timering.pdf')
%%
close all

%%
function ylim = get_ylim(y)
amp = max(y) - min(y);
ylim = [min(y) - amp * 0.35, max(y) + amp * 0.35];
end
