%% style
clear; clc
set(0,'DefaultLineLineWidth',1.5,'DefaultTextFontWeight','bold', ...
    'DefaultTextFontSize',14,'DefaultAxesFontWeight','bold', ...
    'DefaultAxesFontSize',14, 'DefaultLineMarkerSize',10);
set(0,'DefaultAxesFontName', 'Arial')
rng(5)
%% simple trends
n=200;
t = linspace(1,20,n);
X = zeros(n,3);
Y = zeros(n,3);
X(:,1) = sin(t) + 0.5*t;
Y(:,1) = sin(t*1.3);
X(:,2) = sin(t*1.3);
Y(:,2) = sin(t) + 0.5*t;
Y(1,3) = 0.3;
for i = 2 : n
    Y(i,3) = Y(i-1,3) * (3.77 - 3.77 * Y(i-1,3));
end
X(:,3) = sin(t) + 0.5*t;
tau = [25, 12, 25];
fontsize = 18;

%% set up example vector
ex_idx1 = [50, 50 + tau(2)];
ex_t1 = t([50, 50 + tau(2)]);
dt = t(2)-t(1);
ex_t2 = ex_t1 + 2*pi/1.3;
ex_idx2 = (ex_t2-1)/dt+1;
ex_t3 = ex_t2 + 2*pi/1.3;
ex_idx3 = (ex_t3-1)/dt+1;

%% show dynamics
for sys = 1 : 3
    fig1 = figure;
    scatter(1:n, X(:,sys), 'r.')
    hold on
    plot(1:n, X(:,sys), 'k-', 'LineWidth',1)
    xticks([])
    ylabel('X')
    if sys == 2
        plot(ex_idx1, sin(ex_t1*1.3), 'g', 'linewidth', 2)
        plot(ex_idx2, sin(ex_t2*1.3), 'g', 'linewidth', 2)
        plot(ex_idx3, sin(ex_t3*1.3), 'g', 'linewidth', 2)
        scatter([ex_idx1(2),ex_idx2(2),ex_idx3(2)],...
                [sin(ex_t1(2)*1.3), sin(ex_t2(2)*1.3), sin(ex_t3(2)*1.3)],...
                40,'g^','filled')
    end
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 3.4 0.85])
    saveas(fig1,sprintf('raw/figZ%d.svg',sys) )
    
    fig1 = figure;    
    scatter(1:n, Y(:,sys), 'b.')
    hold on
    plot(1:n, Y(:,sys), 'k-', 'LineWidth',1)
    xlabel('time')
    ylabel('Y')
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 3.4 0.85])
    saveas(fig1,sprintf('raw/figA%d.svg',sys) )
end
%% show X map to Y
for sys = 1 : 3
    fig2 = figure;
    v1 = X(1:end-tau(sys),sys);
    v2 = X(1+tau(sys):end,sys);
    v3 = Y(1+tau(sys):end,sys);
    idx = randperm(length(v1));
    scatter(v1(idx), v2(idx), 20, v3(idx),'filled')
    h = colorbar;
    title(h,'Y(t)')
    xlabel('X(t - \tau)')
    ylabel('X(t)')
    colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 1.7 1.7])
    saveas(fig2,sprintf('raw/figC%d.svg',sys) )
end
%% show X map to time
for sys = 1 : 3
    fig2 = figure;
    v1 = X(1:end-tau(sys),sys);
    v2 = X(1+tau(sys):end,sys);
    v3 = t(1+tau(sys):end);
    idx = randperm(length(v1));
    scatter(v1(idx), v2(idx), 20, v3(idx),'filled')
    h = colorbar;
    title(h,'t')
    xlabel('X(t - \tau)')
    ylabel('X(t)')
    if sys == 2
        hold on
        scatter(sin(ex_t1(1)*1.3), sin(ex_t1(2)*1.3), 40, 'g', 'filled')
    end
    colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 1.7 1.7])
    saveas(fig2,sprintf('raw/figB%d.svg',sys) )
end
close all
% %%
% sys=1;
% idx = randperm(n-tau(sys)-2)+1;
% fig4 = figure('Renderer', 'painters', 'Position', [10 10 200 180]);
% plotit(X(:,sys),Y(:,sys),tau(sys),idx)
% set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
% %%
% function plotit(x,y,tau,idx)
% n_colors = 100;
% y_ = (y-min(y));
% y_ = round(y_ / max(y_) * (n_colors-1) + 1);
% h = colormap(gray(n_colors));
% for i = idx
%     plot(x(i-1:i+1), x(i-1+tau:i+1+tau), 'LineWidth', 5, 'color', h(y_(i+tau),:))
%     hold on
% end
% end