%% style
clear; clc
set(0,'DefaultLineLineWidth',1.5,'DefaultTextFontWeight','bold', ...
    'DefaultTextFontSize',14,'DefaultAxesFontWeight','bold', ...
    'DefaultAxesFontSize',14, 'DefaultLineMarkerSize',10);
set(0,'DefaultAxesFontName', 'Arial')
rng(5)
mkdir('data')
mkdir('raw')
%%
n_tpt = 1000;
X = zeros(n_tpt, 3);
Y = zeros(n_tpt, 3);
T = zeros(n_tpt, 3);
[x,y,t] = oscillation(n_tpt);
X(:,1) = x; Y(:,1) = y; T(:,1) = t;
[x,y,t] = nonrev_pos(n_tpt);
X(:,2) = x; Y(:,2) = y; T(:,2) = t;
[x,y,t] = nonrev_neg(n_tpt);
X(:,3) = x; Y(:,3) = y; T(:,3) = t;

% save data
n_save = 1000;
csvwrite('data/X.csv', X(1:n_save,:));
csvwrite('data/Y.csv', Y(1:n_save,:));
%% show dynamics
idx_show = 1 : 401;
fontsize = 18;

for sys = 1 : 3
    fig1 = figure;
    scatter(T(idx_show,sys), X(idx_show,sys), 'r.')
    hold on
    plot(T(idx_show,sys), X(idx_show,sys), 'k-', 'LineWidth',1)
    xlim([min(T(idx_show,sys)), max(T(idx_show,sys))])
    xticks([])
    yticks([])
    ylabel('X')
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 3.4 0.85])
    saveas(fig1,sprintf('raw/figA%d.svg',sys) )
    
    fig1 = figure;    
    scatter(T(idx_show,sys), Y(idx_show,sys), 'b.')
    hold on
    plot(T(idx_show,sys), Y(idx_show,sys), 'k-', 'LineWidth',1)
    xlim([min(T(idx_show,sys)), max(T(idx_show,sys))])
    %xticks([])
    yticks([])
    xlabel('time')
    ylabel('Y')
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 3.4 0.85])
    saveas(fig1,sprintf('raw/figB%d.svg',sys) )
end

%% delay params
idx_show = zeros(3,2);
idx_show(:,1) = 1;
idx_show(:,2) = 401;
idx_show(1,2) = n_tpt;
tau = [120,30,50];
sz = [20, 20, 20];
%% show X map to Y
for sys = [3]
    X_ = X(idx_show(sys,1):idx_show(sys,2),:);
    Y_ = Y(idx_show(sys,1):idx_show(sys,2),:);
    fig2 = figure;
    v1 = X_(1:end-tau(sys),sys);
    v2 = X_(1+tau(sys):end,sys);
    v3 = Y_(1+tau(sys):end,sys);
    idx = randperm(length(v1));
    scatter(v1(idx), v2(idx), sz(sys), v3(idx),'filled')
    h = colorbar;
    title(h,'Y(t)')
    xlabel('X(t - \tau)')
    ylabel('X(t)')
    xticks([])
    yticks([])
    colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 2 2])
    saveas(fig2,sprintf('raw/figC%d.svg',sys) )
end
%
for sys = [1,2]
    X_ = X(idx_show(sys,1):idx_show(sys,2),:);
    Y_ = Y(idx_show(sys,1):idx_show(sys,2),:);
    fig2 = figure;
    v1 = X_(1:end-2*tau(sys),sys);
    v2 = X_(1+tau(sys):end-tau(sys),sys);
    v3 = X_(1+2*tau(sys):end,sys);
    v4 = Y_(1+2*tau(sys):end,sys);
    idx = randperm(length(v1));
    scatter3(v1(idx), v2(idx), v3(idx), sz(sys), v4(idx),'filled')
    h = colorbar;
    title(h,'Y(t)')
    xlabel('X(t - 2 \tau)')
    ylabel('X(t - \tau)')
    zlabel('X(t)')
    xticks([])
    yticks([])
    zticks([])
    if sys == 1
    view([107.7 12.6])
    end
    if sys == 2
    view([36 49.8])
    end
    colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 2 2])
    set(gcf, 'Renderer', 'painters');
    saveas(fig2,sprintf('raw/figC%d.svg',sys) )
    %saveas(fig2,sprintf('raw/figC%d.png',sys) )
    saveas(fig2,sprintf('raw/figC%d.pdf',sys) )
end

%% show Y map to X
for sys = [3]
    X_ = X(idx_show(sys,1):idx_show(sys,2),:);
    Y_ = Y(idx_show(sys,1):idx_show(sys,2),:);
    fig2 = figure;
    v1 = Y_(1:end-tau(sys),sys);
    v2 = Y_(1+tau(sys):end,sys);
    v3 = X_(1+tau(sys):end,sys);
    idx = randperm(length(v1));
    scatter(v1(idx), v2(idx), sz(sys), v3(idx),'filled')
    h = colorbar;
    title(h,'X(t)')
    xlabel('Y(t - \tau)')
    ylabel('Y(t)')
    xticks([])
    yticks([])
    colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 2 2])
    saveas(fig2,sprintf('raw/figD%d.svg',sys) )
    saveas(fig2,sprintf('raw/figD%d.png',sys) )
end

for sys = [1,2]
    X_ = X(idx_show(sys,1):idx_show(sys,2),:);
    Y_ = Y(idx_show(sys,1):idx_show(sys,2),:);
    fig2 = figure;
    v1 = Y_(1:end-2*tau(sys),sys);
    v2 = Y_(1+tau(sys):end-tau(sys),sys);
    v3 = Y_(1+2*tau(sys):end,sys);
    v4 = X_(1+2*tau(sys):end,sys);
    idx = randperm(length(v1));
    scatter3(v1(idx), v2(idx), v3(idx), sz(sys), v4(idx),'filled')
    h = colorbar;
    title(h,'X(t)')
    xlabel('Y(t - 2 \tau)')
    ylabel('Y(t - \tau)')
    zlabel('Y(t)')
    xticks([])
    yticks([])
    zticks([])
    if sys == 1
    view([107.7 12.6])
    end
    if sys == 2
    view([130 50])
    end
    colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 2 2])
    set(gcf, 'Renderer', 'painters');
    saveas(fig2,sprintf('raw/figD%d.svg',sys) )
    %saveas(fig2,sprintf('raw/figC%d.png',sys) )
    saveas(fig2,sprintf('raw/figD%d.pdf',sys) )
end

%% show X map to t
for sys = [3]
    X_ = X(idx_show(sys,1):idx_show(sys,2),:);
    Y_ = Y(idx_show(sys,1):idx_show(sys,2),:);
    fig2 = figure;
    v1 = X_(1:end-tau(sys),sys);
    v2 = X_(1+tau(sys):end,sys);
    v3 = t(1+tau(sys):end);
    idx = randperm(length(v1));
    scatter(v1(idx), v2(idx), sz(sys), v3(idx),'filled')
    h = colorbar;
    title(h,'t')
    xlabel('X(t - \tau)')
    ylabel('X(t)')
    xticks([])
    yticks([])
    colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 2 2])
    saveas(fig2,sprintf('raw/figE%d.svg',sys) )
end
%
for sys = [1,2]
    X_ = X(idx_show(sys,1):idx_show(sys,2),:);
    Y_ = Y(idx_show(sys,1):idx_show(sys,2),:);
    fig2 = figure;
    v1 = X_(1:end-2*tau(sys),sys);
    v2 = X_(1+tau(sys):end-tau(sys),sys);
    v3 = X_(1+2*tau(sys):end,sys);
    v4 = t(1+2*tau(sys):end);
    idx = randperm(length(v1));
    scatter3(v1(idx), v2(idx), v3(idx), sz(sys), v4(idx),'filled')
    h = colorbar;
    title(h,'t')
    xlabel('X(t - 2 \tau)')
    ylabel('X(t - \tau)')
    zlabel('X(t)')
    xticks([])
    yticks([])
    zticks([])
    if sys == 1
    view([107.7 12.6])
    end
    if sys == 2
    view([36 49.8])
    end
    colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 2 2])
    set(gcf, 'Renderer', 'painters');
    saveas(fig2,sprintf('raw/figE%d.svg',sys) )
    %saveas(fig2,sprintf('raw/figC%d.png',sys) )
    saveas(fig2,sprintf('raw/figE%d.pdf',sys) )
end

%% show Y map to t
for sys = [3]
    X_ = X(idx_show(sys,1):idx_show(sys,2),:);
    Y_ = Y(idx_show(sys,1):idx_show(sys,2),:);
    fig2 = figure;
    v1 = Y_(1:end-tau(sys),sys);
    v2 = Y_(1+tau(sys):end,sys);
    v3 = t(1+tau(sys):end);
    idx = randperm(length(v1));
    scatter(v1(idx), v2(idx), sz(sys), v3(idx),'filled')
    h = colorbar;
    title(h,'t')
    xlabel('Y(t - \tau)')
    ylabel('Y(t)')
    xticks([])
    yticks([])
    colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 2 2])
    saveas(fig2,sprintf('raw/figF%d.svg',sys) )
end

for sys = [1,2]
    X_ = X(idx_show(sys,1):idx_show(sys,2),:);
    Y_ = Y(idx_show(sys,1):idx_show(sys,2),:);
    fig2 = figure;
    v1 = Y_(1:end-2*tau(sys),sys);
    v2 = Y_(1+tau(sys):end-tau(sys),sys);
    v3 = Y_(1+2*tau(sys):end,sys);
    v4 = t(1+2*tau(sys):end);
    idx = randperm(length(v1));
    scatter3(v1(idx), v2(idx), v3(idx), sz(sys), v4(idx),'filled')
    h = colorbar;
    title(h,'t')
    xlabel('Y(t - 2 \tau)')
    ylabel('Y(t - \tau)')
    zlabel('Y(t)')
    xticks([])
    yticks([])
    zticks([])
    if sys == 1
    view([107.7 12.6])
    end
    if sys == 2
    view([130 50])
    end
    colormap gray; set(gca,'Color',[0.7 0.7 1]); set(gcf, 'InvertHardCopy', 'off');
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 2 2])
    set(gcf, 'Renderer', 'painters');
    saveas(fig2,sprintf('raw/figF%d.svg',sys) )
    %saveas(fig2,sprintf('raw/figC%d.png',sys) )
    saveas(fig2,sprintf('raw/figF%d.pdf',sys) )
end
%%
close all
%% make data: we're going to map FROM X TO Y

function [x, y, t] = oscillation(n_tpt)
omega1 = 3;
omega2 = 5;
omega4 = sqrt(20.5);

% system
xprime = @(x) [x(2), -(omega1)^2*x(1)];
xprime2 = @(x) [x(2), -(omega2)^2*x(1)];
xprime3 = @(x) x(1) - x(3);
xprime4 = @(x) [x(2), -(omega4)^2*x(1)];
xprime5 = @(x) x(5) + 0.3 * x(6) - x(8);
xprime_all = @(x) [xprime(x(1:2)), xprime2(x(3:4)), xprime3(x), xprime4(x(6:7)), xprime5(x)];

% numerical integration
tspan = (0 : 0.03 : 0.03 * (n_tpt-1) );
y0 = ones(1,8);
opts = odeset('RelTol',1e-6,'AbsTol',1e-6);
[t,X] = ode45(@(t,y) xprime_all(y)',tspan, y0, opts);
y = X(:,3);
x = X(:,5);
end

function [x,y,t] = nonrev_pos(n_tpt)
rx = 0.09;
ry = -0.12;
axy = 0.1;
ayx = -0.002;
omega = 1/1.6;
xprime = @(t, x) [x(1) * (rx + ayx * x(2));
               x(2) * (ry + axy * x(1) + x(3));
               x(4);
               -(omega)^2*x(3)];

X0 = [1.3,1.5,0,omega];
t = 0 : 0.1 : 0.1 * (n_tpt-1);
[t,X] = ode45(xprime, t, X0);
x = X(:,1);
y = X(:,2);
end

function [x,y,t] = nonrev_neg(n_tpt)
t = 0 : 0.05 : 0.05 * (n_tpt-1);
x = sin(t*1.3) + exp(t/10); % slightly different, to get rid of bugs
y = 0.1 * (t-10).^2;
end