# code to view the results of the parameter randomization experiments

import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
from scipy import stats

#load in data
df_fail = pd.read_csv('randomized_failure_mode/data1.csv')

df_work = pd.read_csv('randomized_working/data1.csv')

# get outliers for boxplot
def get_outliers(x, whisker_length=1.5):
    x = np.copy(np.sort(x))
    l = np.size(x)
    low_val = x[int(0.25 * l)]
    high_val = x[int(0.75 * l)]
    iqr = high_val - low_val
    low_whis = low_val - whisker_length * iqr
    high_whis = high_val + whisker_length * iqr
    outliers = np.concatenate([x[x<low_whis], x[x>high_whis]])
    return outliers

# make plots
myfont = {"fontname" : "Arial", "fontweight" : "bold"}

plt.subplot(1,2,1)
box = sns.boxplot(df_work.tp_star, orient='v', showfliers=False, whis=1.5,
                  color='firebrick')
sns.swarmplot(get_outliers(df_work.tp_star.values, 1.5), orient='v', color='firebrick')
plt.ylabel('Optimal prediction horizon', fontsize=15, **myfont)
plt.title('Friendly\nparameter regime', fontsize=15, **myfont)
plt.ylim([-9,9])
plt.yticks(fontsize=15, **myfont)
plt.subplot(1,2,2)
box = sns.boxplot(df_fail.tp_star, orient='v', showfliers=False, whis=1.5,
                  color='royalblue')
sns.swarmplot(get_outliers(df_fail.tp_star.values, 1.5), orient='v',
              color='royalblue')
plt.ylabel('Optimal prediction horizon', fontsize=15, **myfont)
plt.title('Pathological\nparameter regime', fontsize=15, **myfont)
plt.ylim([-9,9])
plt.yticks(fontsize=15, **myfont)
plt.savefig('randomized.svg')
plt.close()

# make swarmplots to check
plt.subplot(1,2,1)
sns.swarmplot(df_work.tp_star.values, orient='v', color='firebrick')
plt.ylabel('Optimal prediction horizon', fontsize=15, **myfont)
plt.title('Friendly\nparameter regime', fontsize=15, **myfont)
plt.ylim([-9,9])
plt.yticks(fontsize=15, **myfont)
plt.subplot(1,2,2)
sns.swarmplot(df_fail.tp_star.values, orient='v', color='royalblue')
plt.ylabel('Optimal prediction horizon', fontsize=15, **myfont)
plt.title('Pathological\nparameter regime', fontsize=15, **myfont)
plt.ylim([-9,9])
plt.yticks(fontsize=15, **myfont)
plt.savefig('randomized_swarm.svg')
plt.close()

# print out list of outliers
print('work outliers:')
print(get_outliers(df_work.tp_star.values, 1.5))
print('fail outliers:')
print(get_outliers(df_fail.tp_star.values, 1.5))
