%% style
clear; clc
set(0,'DefaultLineLineWidth',1.5,'DefaultTextFontWeight','bold', ...
    'DefaultTextFontSize',14,'DefaultAxesFontWeight','bold', ...
    'DefaultAxesFontSize',14, 'DefaultLineMarkerSize',10);
set(0,'DefaultAxesFontName', 'Arial')
rng(5)
fontsize = 18;
%% show standard CCM result (no lag)
for sys = 1 : 6
    T = readtable(sprintf('data/sys%d_nolag.csv', sys) );
    S = readtable(sprintf('data/sys%d_surrogate.csv', sys) );
    surr_rho = sort(S.rho);
    surr_libsize = S.lib_size(1);
    cutoff = surr_rho(round(length(surr_rho) * 0.95));
    lib_sizes = unique(T.lib_size);
    n_sizes = length(lib_sizes);
    RHO = zeros(n_sizes,3);
    f = @(x) mean(x);
    for i = 1 : n_sizes
        rho = T.rho(T.lib_size == lib_sizes(i));
        RHO(i,1) = f(rho);
        if i < n_sizes
            RHO(i,2:3) = bootci(1000, {f,rho}, 'alpha', 0.05, 'type', 'bca');
        else
            RHO(i,2:3) = f(rho);
        end
    end
    fig1 = figure;
    plot(lib_sizes, RHO(:,1), 'r')
    hold on
    for i = 1 : n_sizes
        plot([lib_sizes(i), lib_sizes(i)], [RHO(i,2), RHO(i,3)], 'k')
    end
    scatter(lib_sizes, RHO(:,1), 40, 'k', 'filled')
    scatter(surr_libsize, cutoff, 40, 'b', 'filled')
    xlabel('training data size')
    ylabel('cross map skill')
    xlim([0, 200])
    xticks([0, 100, 200])
    ylim([0.8, 1])
    if sys == 3
        ylim([0.3, 1])
    end
    
    if sys == 6
        ylim([0,1])
    end
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 2 2])
    saveas(fig1,sprintf('raw/resA%d.svg',sys) )
end
%% show delay test (no lag)
for sys = 1 : 5
    T = readtable(sprintf('data/sys%d_lagtest.csv', sys) );
    pred_lag = unique(T.tp);
    n_tp = length(pred_lag);
    RHO = zeros(n_tp,1);
    f = @(x) mean(x);
    for i = 1 : n_tp
        rho = T.rho(T.tp == pred_lag(i));
        RHO(i,1) = f(rho);
        %RHO(i,2:3) = bootci(1000, {f,rho}, 'alpha', 0.05, 'type', 'bca');
    end
    fig1 = figure;
    % plot 1-rho
    plot(pred_lag, 1-RHO(:,1), 'r')
    hold on
    %for i = 1 : n_tp
    %    plot([pred_lag(i), pred_lag(i)], 1-[RHO(i,2), RHO(i,3)], 'k')
    %end
    scatter(pred_lag, 1-RHO(:,1), 40, 'k', 'filled')
    xlabel('prediction lag')
    ylabel('cross map skill')
    if sys == 3
        %ylim([0.001, 0.1])
        xticks([-25, 0, 25])
    end
    % reverse y-axis, as per
    % https://stackoverflow.com/questions/5395554/
    set(gca,'ydir','reverse','yscale','log')
    % relabel y-axis
    ytx = yticks;
    yticklabels(1-ytx)
    % plot divider at 0
    ylm = ylim;
    plot ([0,0], ylm, 'b--')
    ylim(ylm)
    % other style things
    set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
        'units','inches','position',[2 2 2 2])
    saveas(fig1,sprintf('raw/resB%d.svg',sys) )
end

%% deal with sys 6
sys = 6;
T = readtable(sprintf('data/sys%d_lagtest.csv', sys) );
pred_lag = unique(T.tp);
n_tp = length(pred_lag);
RHO = zeros(n_tp,1);
f = @(x) mean(x);
for i = 1 : n_tp
    rho = T.rho(T.tp == pred_lag(i));
    RHO(i,1) = f(rho);
    %RHO(i,2:3) = bootci(1000, {f,rho}, 'alpha', 0.05, 'type', 'bca');
end
fig1 = figure;
% plot 1-rho
plot(pred_lag, RHO(:,1), 'r')
hold on
%for i = 1 : n_tp
%    plot([pred_lag(i), pred_lag(i)], 1-[RHO(i,2), RHO(i,3)], 'k')
%end
scatter(pred_lag, RHO(:,1), 40, 'k', 'filled')
xlabel('prediction lag')
ylabel('cross map skill')
if sys == 3
    %ylim([0.001, 0.1])
    xticks([-25, 0, 25])
end
% plot divider at 0
ylm = ylim;
plot ([0,0], ylm, 'b--')
ylim(ylm)
% other style things
set(gca,'LineWidth',2,'FontSize',fontsize,'FontName','Arial','fontweight','bold',...
    'units','inches','position',[2 2 2 2])
saveas(fig1,sprintf('raw/resB%d.svg',sys) )