%% Load data

% Load file
data = readtable('figure_cdc25_klp9OE_growth_events.txt');

% Rename variables
data.speed = data.speed_um_per_min;
data.cell = categorical(data.cell_id);
data.experiment = categorical(data.experiment);
data.position = data.category_rescue_membrane;

% Reorder the categories to have the right reference category
data.condition = categorical(data.condition,{'ctrl','p1klp9','cdc25-22'});
data.position = categorical(data.position,{'before','outside','inside'});

%% Statistical analysis

% Fit to mixed-effects model
lm=fitlme(data,'speed ~ condition * position + (condition|experiment) + (position|cell:experiment)','FitMethod','REML');

% Print the anova table
anova_table=anova(lm,'dfmethod','satterthwaite')

% Print the fixed effects coefficients
[~,~,fixed_coefficients_stats] = fixedEffects(lm,'dfmethod','satterthwaite')


%% Confidence intervals
% See the documentation of predict: https://fr.mathworks.com/help/stats/generalizedlinearmixedmodel.predict.html

% Produce all possible combinations of fixed and random effect parameters:
data4confidence_intervals = unique(data(:,{'condition','position','experiment','cell'}));

% Calculate the confidence intervals with contribution from only fixed
% effects (passing the parameter Conditional=false)
% CI is the 95% confidence interval of the coefficient
% DF is the degrees of freedom
[data4confidence_intervals.coefficient,data4confidence_intervals.coefficientCI,data4confidence_intervals.DF] = predict(lm,data4confidence_intervals,'DFMethod','satterthwaite','Conditional',false);

% Here we simply add a column with the width of the confidence interval
data4confidence_intervals.coefficientCI_width = data4confidence_intervals.coefficient - data4confidence_intervals.coefficientCI(:,1);

% Remove experiment and cell variables (even if only calculating fixed
% effects, you still need to pass it as an argument to predict)
data4confidence_intervals(:,{'experiment','cell'})=[];

% Print the confidence intervals
data4confidence_intervals = unique(data4confidence_intervals)

%% Percentage of the variance explained by position
% We fit a simple linear model with only speed and position
lm_2=fitlme(data,'speed ~ position');

% We print the Rsquared (percentage of the variance explained by the model)
lm_2.Rsquared

%% Contrast
% This is used to show in the main text that the ark1-as3 abnormal outside 
% vs. inside are not significantly different. In this case we do it for
% klp9OE and see that they are significantly different

cont1= logical([1,1,0,1,0,1,0,0,0]);
cont2= logical([1,1,0,0,1,0,0,1,0]);
[pVal,F,DF1,DF2] = coefTest(lm, cont1 - cont2,0,'dfmethod','satterthwaite');

coeff1 = lm.CoefficientNames(cont1);
coeff2 = lm.CoefficientNames(cont2);

fprintf('condition 1:\n')
for i = 1:numel(coeff1)
    fprintf(' > %s\n',coeff1{i})
end
fprintf('condition 2:\n')
for i = 1:numel(coeff2)
    fprintf(' > %s\n',coeff2{i})
end

pVal
