%This file runs the mechanical circuit model for the force jump assay (Both
%55 and 70 nt bridges), and plots the output transfer functions
%______________________________________________________________KJM 07/24/21

clear; close all; clc;

BP1=55;;
BPL=70;
BP2=24;

lp1=1e-9; %in meters
lp2=1e-9;
lc1=0.59e-9*BP1; %in meters
lcL=0.59e-9*BPL;
lc2=0.59e-9*BP2; 

kb=1.38064852*10^(-23); % Boltzmann constant in kg m^2 s^-2 K-1
T=25+273; %temperature in kelvin

x=.001e-9:.001e-9:30e-9;

F1=(0.25.*(1-x./lc1).^-2-0.25+x./lc1).*kb.*T./lp1; %Bridge 55 nt
FL=(0.25.*(1-x./lcL).^-2-0.25+x./lcL).*kb.*T./lp1; %Bridge 70 nt
F1b=(0.25.*(1-(x+8e-9)./lc1).^-2-0.25+(x+8e-9)./lc1).*kb.*T./lp1; %55 nt Bridge with offset correction
FLb=(0.25.*(1-(x+8e-9)./lcL).^-2-0.25+(x+8e-9)./lcL).*kb.*T./lp1; %70 nt bridge with offset correction

F2=(0.25.*(1-x./lc2).^-2-0.25+x./lc2).*kb.*T./lp2; %Loading strand
F2(x>0.79*lc2)=NaN;
F3=F1b+F2;
F3L=FLb+F2;
F3(x>0.79*lc2)=NaN;
F3L(x>0.79*lc2)=NaN;


f1=figure(1);
plot((x-8e-9).*10^9,F1.*10^12,'b','linewidth',2); hold on;
plot(x.*10^9,FLb.*10^12,'c','linewidth',2);
plot(x.*10^9,F2.*10^12,'r','linewidth',2);
plot(x.*10^9,F3.*10^12,'k','linewidth',2);
axis([0 20 0 20]);
ylabel('Force, pN');
xlabel('Distance, nm');

f2=figure(2);
plot(F3.*10^12,F2.*10^12,'k','linewidth',2,'color',[.8 .2 .2]); hold on;
plot(F3L.*10^12,F2.*10^12,'k','linewidth',2,'color',[.2 .2 .8]);
axis([0 15 0 10]);
xlabel('FTot, pN');
ylabel('FLoad, pN');
l1=legend('55 nt','70 nt'); set(l1,'location','northwest');


f2=figure(3);
for i=1:length(x);
    clear k1 k2;
    try
        k1=find(abs(F3(i)-F1b)==min(abs(F3(i)-F1b)));
        k2=find(abs(F3L(i)-FLb)==min(abs(F3L(i)-FLb)));
        dx1(i)=x(k1)-x(i);
        dx2(i)=x(k2)-x(i);
    catch
        dx1(i)=0;
        dx2(i)=0;
    end
end
plot(F3.*10^12,dx1.*10^9,'k','linewidth',2,'color',[.8 .2 .2]); hold on;
plot(F3L.*10^12,dx2.*10^9,'k','linewidth',2,'color',[.2 .2 .8]); 
axis([0 15 0 12]);
xlabel('FTot, pN');
ylabel('Dx, nm');
l1=legend('55 nt','70 nt'); set(l1,'location','northwest');
