# Annotation data files

These files contain the derived information about all AIS-targeting synapses and the pyramidal cells analyzed in the paper "The structural and functional logic of axo-axonic inhibition" by Schneider-Mizell et al. Dataset-wide annotation data, as well as information about getting meshes, imagery, and segmentation, can be found at https://www.microns-explorer.org/phase1.


## Synapse-level data

The file `ais_synapse_data.csv` has a row for each synapse targeting an AIS of an analyzed neuron in the dataset. The columns are:

* id: 
	Row index, specific to this table.

* pre_pt_position:
	Location of the presynaptic side of the synapse in voxel coordinates.

* pre_pt_root_id:
	Object id of the presynaptic object for the synapse. **Note that the id is a 64-bit integer, which is not read correctly in some common programs such as Excel.**

* ctr_pt_position:
	Location of the center of the synapse in voxel coordinates.

* post_pt_position:
	Location of the postsynaptic side of the synapse in voxel coordinates.

* post_pt_root_id:
	Object id of the postsynaptic object for the synapse. **Note that the id is a 64-bit integer, which is not read correctly in some common programs such as Excel.**

* size:
	Size of the synapse measured in total number of voxels in an automatic segmentation.

* post_pt_mesh_ind:
	Vertex index of the closest point on the postsynaptic mesh.
	
* d_top:
	Distance along the AIS mesh from the synapse to the topmost point of the target AIS (in nanometers).

* d_first:
	Distance along the AIS mesh from the synapse to the topmost synapse of the target AIS (in nanometers).

* d_previous:
	Distance along the AIS mesh from the synapse to the closest synapse above on the target AIS (in nanometers).

* d_previous_same_cell:
	Distance along the AIS mesh from the synapse to the closest synapse from the same presynaptic object (if any) above on the target AIS (in nanometers).

* d_closest:
	Distance along the AIS mesh from the synapse to the closest synapse (if any) on the target AIS (in nanometers).

* d_closest_diff_cell:
	Distance along the AIS mesh from the synapse to the closest synapse from a different presynaptic object (if any) above on the target AIS (in nanometers).

* d_top_skel:
	Distance along the AIS skeleton from the synapse to the top point (in nanometers).

* ais_len:
	Total length of the AIS

* orientation:
	Orientation in radians (relative to the positive-x axis direction) of the synapse around the AIS.

* syn_per_edge:
	Total number of synapses from the same presynaptic object onto the same postsynaptic object as the synapse.

* is_chandelier:
	Whether or not the synapse belongs to an object classified as a chandelier cell.
	
## Neuron-level data

The file `ais_cell_properties.csv` has a row for each target pyramidal cell with a complete soma in the volume, used for target analysis. Note that this data only includes the distance span (38 µm) common to all AIS analyzed. The columns are:

* post_pt_root_id:
	Object id of the postsynaptic object for the synapse. **Note that the id is a 64-bit integer, which is not read correctly in some common programs such as Excel.**

* num_cells_chc:
	Total number of presynaptic chandelier cell axons presynaptic to the AIS.

* syn_net_chc:
	Total number of presynaptic inputs to the AIS from chandelier cells.

* syn_mean_chc:      
	Mean number of synapses per chandelier cell axon onto the AIS.

* syn_median_chc:
	Median number of synapses per chandelier cell axon onto the AIS.

* syn_var_chc:    
	Variance of the distribution of synapses per chandelier cell axon ontot he AIS.

* syn_max_chc:
	Maximum number of synapses per chandelier cell axon onto the AIS.

* size_net_chc:
	Total size of all chandelier synapses onto the AIS (measured in voxels).

* size_mean_chc:     
	Mean size of all chandelier synapses onto the AIS (measured in voxels).

* size_median_chc:
	Median size of all chandelier synapses onto the AIS (measured in voxels).

* size_var_chc:  
	Variance of the distribution of chandelier synapse sizes onto the AIS (measured in voxels).

* size_max_chc:
	Maximum size of chandelier synapses onto the AIS (mesaured in voxels).

* num_cells_non:
	Total number of presynaptic non-chandelier cell axons presynaptic to the AIS.

* syn_net_non:
	Total number of presynaptic inputs to the AIS from non-chandelier cells.

* syn_mean_non:      
	Mean number of synapses per non-chandelier cell axon onto the AIS.

* syn_median_non:
	Median number of synapses per non-chandelier cell axon onto the AIS.

* syn_var_non:    
	Variance of the distribution of synapses per non-chandelier cell axon ontot he AIS.

* syn_max_non:
	Maximum number of synapses per non-chandelier cell axon onto the AIS.

* size_net_non:
	Total size of all non-chandelier synapses onto the AIS (measured in voxels).

* size_mean_non:    
	Mean size of all non-chandelier synapses onto the AIS (measured in voxels).

* size_median_non:
	Median size of all non-chandelier synapses onto the AIS (measured in voxels).

* size_var_non:  
	Variance of the distribution of non-chandelier synapse sizes onto the AIS (measured in voxels).

* size_max_non:
	Maximum size of non-chandelier synapses onto the AIS (mesaured in voxels).

* ais_len:     
	Length of the AIS in the volume (measured in nm).

* soma_x:       
	X-coordinate in voxels of the soma centroid.

* soma_y:           
	Y-coordinate in voxels of the soma centroid.

* soma_z:           
	Z-coordinate in voxels of the soma centroid.

* soma_x_um:
	X-coordinate in microns of the soma centroid.

* soma_y_um:
	Y-coordinate in microns of the soma centroid.

* soma_z_um:        
	Z-coordinate in microns of the soma centroid.

* label:
	Assessed soma segmentation quality, rated from 1 (worst) to 3 (best), with 2 indicating small errors. Soma segmentations with a value of 1 were excluded from the analysis data here.

* mean_soma_syn_size:
	Mean synapse size of synapses onto the soma

* soma_area:
	Surface area of the soma (in µm^2).

* soma_synapses:
	Number of synaptic inputs onto the soma.

* soma_syn_density:
	Number of synaptic inputs onto the soma (in µm^-2).

* ais_diameter: 
	Average diameter of the AIS (in nm).

* soma_y_adj:       
	Depth of the soma centroid in µm after translation to make the top of L2/3 at 0 and rotation to make the average AIS direction exactly along the y-axis.

* ica_0:           
	Loading on the first ICA dimension.

* ica_1:                
	Loading on the second ICA dimension.

* ica_2:                
	Loading on the third ICA dimension.

* num_potential_5000/7500/10000/15000:
	Number of potential chandelier cell axons within 5000/7500/10000/15000 nm of the AIS.

* within_data_5000/7500/10000/15000:
	Boolean value which is False if the region within 5000/7500/10000/15000 nm of the AIS significantly leaves the segmented data.

