close all;
main;
function main

%b %[nM] %Protein concentration
%db/dx %[nM um-1]
%d2b/dx2 %[nM um-2]

onlyPlot = 0;%if onlyPlot = 1, pdepe is not executed. Instead, already-calculated result is loaded.
fileNamePrefix = 'sFRP1v01_Wntv111yo12';
k1  = 0.0266*10^(-4);%[nM^-2 sec^-1] %Wnt6-Fzd7 k_on %set in this study
k10 = 0.096*10^(-3);%[sec^-1]        %Wnt3a-Fzd8 k_off in Eric Bourhis et al 2010
k2  = 0.0433*10^(-3);%[nM^-1 sec^-1] %Wnt3a-sFRP1 k_on in Danuta Wawrzak et al 2007
k20 = 0.486*10^(-3);%[sec^-1]        %Wnt3a-sFRP1 k_off in Danuta Wawrzak et al 2007
k3  = 0.186*10^(-3);%[nM^-1 sec^-1]  %Gremlin-HSPG k_on in Paola Chiodelli et al 2011
k30 = 3.66*10^(-3);%[sec^-1]         %Gremlin-HSPG k_off in Paola Chiodelli et al 2011
k4  = 2.52*10^(-4);%[sec^-1]         %Wnt-Fzd complex internalization rate % set in this study
r0  = (3/4)*10^2;%[nM]               %Fzd concentration at t=0 at normal condition%set in this study %Fzd concentration at t=0 is varied using variable "ric" and indexRinitialcondition below
Kd  = 10^(-2);%[nM]                  %Dissociation constant in Hill equation of repression of sFRP expression by Wnt signal activity %set in this study
a   = 10^8;%[nM]                     %H_total %set in this study %set to be higher amount compared to other molecules
D   = 20;%[um^2 sec^-1]              %Diffusion coefficient of Wnt8 in Yusuke Mii et al 2021
p3 = 10;                             %Relative production rate of the receptor at "normal setting"(when indexRproduction == 2) relative to the internalization rate of Wnt-receptor complex, set in this study

p1= 10^(-4);%[nM sec-1]             %"normal" Wnt secretion rate %set in this study %Wnt secretion rate is changed with a parameter "pw" to simulate variation of Wnt production

%mesh for space (x-axis)
%set to avoid artificial zigzag curve of morphogen gradient
x_mesh0 =linspace(0,0.999,2);
x_mesh1 =linspace(1,9.999,40);
x_mesh2 =linspace(9.9999,10.0001,2);
x_mesh3 =linspace(10.00011,39.99,120);
x_mesh4 =linspace(39.991,40.1,4);
x_mesh5 =linspace(40.11,100,10);

x_mesh = horzcat(x_mesh0,x_mesh1,x_mesh2,x_mesh3,x_mesh4,x_mesh5);

xmin = min(x_mesh);%0[um]
xmax = max(x_mesh);%100[um]
xMeshNumber = length(x_mesh);

xs = 10; %[um] %Wnt source position
xs2 = 75;%[um] %sFRP source position
xs30 = xs+30;%[um];%receptor initial expression_end point

t_mesh =linspace(0,10^5,10^2);

tmin = min(t_mesh);%0[sec]
tmax = max(t_mesh);%10^5[sec]
tMeshNumber = length(t_mesh);

%Non-dimensionalize
t00 = tmax-tmin;%t*
x00 = sqrt(4*D*(tmax-tmin)); %x*
b00 = p1*(tmax-tmin);%b*

k001 = k1 *b00^2*t00; %k1~ (k one tilde)
k002 = k2 *b00*t00;
k003 = k3 *b00*t00;

k0010 = k10 * t00;
k0020 = k20 * t00;
k0030 = k30 * t00;

k004 = k4 * t00; % k4 has dimension of [T^-1]

r000 = r0 /b00;
Kd000 = Kd/b00;
a00 = a /b00;
D00 = D * t00/(x00^2);
p001 = p1 * t00/b00;

x00min = xmin /x00;
x00max = xmax /x00;
x00s = xs /x00;
x00s2 = xs2 /x00;
x00s30 = xs30/x00;

indexSFRPproductionMax = 3;%index to control sFRP1 production rate. If 1, no production. The fig of indexSFRPproduction == 3 is used as "with sFRP" jn the manuscript
indexRinitialconditionMax = 5;%index to control Fzd(=Receptor) concentration at t=0. If 1, no receptor. The fig of indexRinitialCondition == 3 is uded as "normal" in the manuscript
indexRproductionMax = 3;%index to control Fzd(=Receptor) production.
indexWntproductionMax = 3;%index to control Wnt production.
indexDproductionMax = 2; %index to control dn-Fzd(=dominant-negative receptor) production.
molecularSpeciesNumber = 14; %molecular species number
indexDfunctionMax = 3; %index indicates whether dn-Fzd function. If 1, normal dn-Fzd. If 2, dn-Fzd does not bind to Wnt. If 3, dn-Fzd binds to Wnt, but not form heterodimers with intact receptor.
WntSignal = zeros(xMeshNumber, indexRproductionMax, indexSFRPproductionMax, indexRinitialconditionMax, indexWntproductionMax,indexDproductionMax,indexDfunctionMax);

%parameters for pdepe()
m = 0;
x = x_mesh./x00;
t = t_mesh./t00;

%Wnt and sFRP sources are visualized
figure(1)
plot(x, Wntsource(x),'DisplayName', 'Wnt production')
hold on;
plot(x, sFRPsource(x),'DisplayName', 'sFRP production')
hold off;
legend('show')
drawnow
filename = char(join({fileNamePrefix, '.sources', '.fig'},''));
saveas(figure(1),filename)
close All;
for indexDproduction = 1:indexDproductionMax
    for indexDfunction = 1:indexDfunctionMax
        if (indexDproduction==1) && (indexDfunction==2) || (indexDproduction==1) && (indexDfunction==3) % this results in the same solution as "indexDproduction ==1 & indexDfunction ==1", thus this is skipped.
            continue
        end
        if (indexDfunction==1)
            k5 = k1;%[nM^-2 sec^-1] %k_on of homodimerization of dnreceptor %set in this study
            k6 = k1;%[nM^-2 sec^-1] %k_on of heterodimerization of dnreceptor %set in this study
            k7 = 0; %[nM^-2 sec^-1] %k_on of homo/heterodimerization of dnreceptor without trapping Wnt %set in this study            
        elseif (indexDfunction==2)
            k5  = 0;%[nM^-2 sec^-1]
            k6  = 0;%[nM^-2 sec^-1]
            k7  = k1;%[nM^-2 sec^-1] 
        elseif (indexDfunction==3)
            k5  = k1;
            k6  = 0;
            k7  = 0;            
        end
        k005 = k5 *b00^2*t00;
        k006 = k6 *b00^2*t00;
        k007 = k7 *b00^2*t00;
        
        for indexWntproduction = 1:indexWntproductionMax
            pw = 0.5*indexWntproduction;
            %     if indexWntproduction == 1
            %         pw = 0.5;
            %     elseif indexWntproduction == 2
            %         pw = 1.0;
            %     elseif indexWntproduction == 3
            %         pw = 1.5;
            for indexRproduction = 1:indexRproductionMax
                if indexRproduction == 1
                    p003 = 0;
                else
                    p003 = p3*5^(indexRproduction-2);
                end
                %if indexRproduction == 2
                %    p003 = p3;
                %if indexRproduction == 3
                %    p003 = p3*5;
                
                if indexDproduction ==1
                    p004=0;
                elseif indexDproduction ==2
                    p004=10^2*p003;
                end
                
                for indexSFRPproduction = 1:indexSFRPproductionMax
                    if indexSFRPproduction == 1
                        p2 = 0;
                    else
                        p2= p1*(10^indexSFRPproduction-2);%[nM sec-1] %sFRP secretion rate
                    end
                    p002 = p2 * t00/b00;%Non-dimensionalize
                    
                    for indexRinitialcondition = 1:indexRinitialconditionMax
                        if indexRinitialcondition == 1
                            ric = 0; %receptor initial condition
                        else
                            ric = 2^(indexRinitialcondition-3); %if indexRinitialcondition == 3, ric = 1. This is "normal" in the manuscript.
                        end
                        if onlyPlot ~= 1 %solve PDE
                            sol = pdepe(m,@pdex1pde,@pdex1ic,@pdex1bc,x,t); %sol(t,x,moleculeID)
                            save(solFileName(),'sol', '-v7.3')
                            WntSignal(:,indexRproduction,indexSFRPproduction,indexRinitialcondition,indexWntproduction,indexDproduction,indexDfunction) = sol(tMeshNumber,:,12);
                        end
                    end
                end
            end
        end
    end
end

if onlyPlot == 1
    load(strcat(fileNamePrefix,  '.mat'), 'WntSignal');
else
    %save result
    save(strcat(fileNamePrefix,  '.mat'), '-v7.3');
    close all;
end
WntSignalMax = max(WntSignal, [], "all");

xq=linspace(0,max(x),xMeshNumber);
maxSolInterpolated = zeros(molecularSpeciesNumber);
for indexDproduction = 1:indexDproductionMax
    for indexDfunction = 1: indexDfunctionMax
        if (indexDproduction==1) && (indexDfunction==2)||(indexDproduction==1) && (indexDfunction==3)% this results in the same solution as "indexDproduction ==1 & indexBindDn ==1", thus this is skipped.
            continue
        end
        for indexWntproduction = 1:indexWntproductionMax
            for indexRproduction = 1:indexRproductionMax
                for indexSFRPproduction = 1:indexSFRPproductionMax
                    for indexRinitialcondition = 1:indexRinitialconditionMax
                        solInterpolated = zeros(tMeshNumber, xMeshNumber, molecularSpeciesNumber);
                        load(solFileName(), 'sol');
                        for indexMolNum=1:molecularSpeciesNumber
                            for indexT=1:tMeshNumber
                                solInterpolated(indexT,:,indexMolNum)=interp1(x,sol(indexT,:,indexMolNum),xq, 'linear');
                            end
                            maxSolInterpolated(indexMolNum)=max(max(solInterpolated(:,:,indexMolNum), [], 'all'), maxSolInterpolated(indexMolNum)); %max(interpolated concentration) for eaxh molecular species %used as ymax in plots
                        end
                        save(solInterpolatedFileName(), 'solInterpolated', '-v7.3');
                    end
                end
            end
        end
    end
end

for indexDproduction = 1:indexDproductionMax
    for indexDfunction = 1:indexDfunctionMax
        if (indexDproduction==1) && (indexDfunction==2)||(indexDproduction==1) && (indexDfunction==3) % this results in the same solution as "indexDproduction ==1 & indexBindDn ==1", thus this is skipped.
            continue
        end
        

        
        for indexSFRPproduction = 1:indexSFRPproductionMax
            figure(1)
            for indexWntproduction = 1:indexWntproductionMax
                for indexRinitialcondition = 1:indexRinitialconditionMax
                    for indexRproduction=1:indexRproductionMax
                        fs=20;
                        lw=2;
                        figure(1)
                        eachFig(fs,lw)
                        filename = char(join({fileNamePrefix, '_', num2str(indexRinitialcondition),num2str(indexRproduction), num2str(indexWntproduction), num2str(indexSFRPproduction),num2str(indexDproduction),num2str(indexDfunction) '.fig'},''));
                        saveas(figure(1),filename)
                        close;
                        
                        figure(2)
                        fs=8;
                        lw=1;
                        graphnum=(indexRproduction-1)*(indexRinitialconditionMax+1)+indexRinitialcondition;
                        subplot(indexRproductionMax+1,indexRinitialconditionMax+1,graphnum)
                        eachFig(fs,lw)
                        
                        if (indexWntproduction == 3) && (indexSFRPproduction == 1)
                            figure(5)
                            fs=8;
                            lw=1;
                            graphnum=(indexRproduction-1)*(indexRinitialconditionMax)+indexRinitialcondition;
                            subplot(indexRproductionMax,indexRinitialconditionMax,graphnum)
                            eachFig(fs,lw)
                            hold on;
                        end
                       
                    end
                end
                
                
                
                %merge fig
                %%fix index Pr: region B
                for indexRproduction=1:indexRproductionMax
                    for indexRinitialcondition = 1:indexRinitialconditionMax
                        figure(1)
                        fs=20;
                        lw=2;
                        eachFig(fs,lw)
                        hold on;
                        
                        figure(2)
                        fs=8;
                        lw=1;
                        graphnum=(indexRinitialconditionMax+1)*indexRproduction;
                        subplot(indexRproductionMax+1,indexRinitialconditionMax+1,graphnum)
                        eachFig(fs,lw)
                        hold on;
                        
                    end
                    hold off;
                    drawnow
                    filename = char(join({fileNamePrefix, '_', 'm', num2str(indexRproduction), num2str(indexWntproduction), num2str(indexSFRPproduction), num2str(indexDproduction),num2str(indexDfunction) '.fig'},''));
                    saveas(figure(1),filename)
                    close(1);
                end
                
                
                
                %%fix indexRic
                for indexRinitialcondition = 1:indexRinitialconditionMax
                    for indexRproduction=1:indexRproductionMax
                        figure(1)
                        fs=20;
                        lw=2;
                        eachFig(fs,lw)
                        hold on;
                        
                        figure(2)
                        fs=8;
                        lw=1;
                        graphnum=indexRinitialcondition+(indexRinitialconditionMax+1)*(indexRproductionMax);
                        subplot(indexRproductionMax+1,indexRinitialconditionMax+1,graphnum)
                        eachFig(fs,lw)
                        hold on;                      
                    end
                    hold off;
                    drawnow
                    filename = char(join({fileNamePrefix, '_', num2str(indexRinitialcondition), 'm', num2str(indexWntproduction), num2str(indexSFRPproduction),num2str(indexDproduction),num2str(indexDfunction) '.fig'},''));
                    saveas(figure(1),filename)
                    close(1);
                end
                hold off;
                filename2= char(join({fileNamePrefix, '_', 'subplot','m','m', num2str(indexWntproduction),  num2str(indexSFRPproduction),num2str(indexDproduction),num2str(indexDfunction)  '.fig'},''));
                saveas(figure(2),filename2)
                close(2);
            end
            
            % Wnt variation
            % 3 levels of Wnt production
            for indexRinitialcondition = 1:indexRinitialconditionMax
                for indexRproduction=1:indexRproductionMax
                    for indexWntproduction = 1:indexWntproductionMax
                        figure(3)
                        fs=20;
                        lw=2;
                        eachFig(fs,lw)
                        hold on;
                        
                        figure(4)
                        fs=8;
                        lw=1;
                        graphnum=(indexRproduction-1)*(indexRinitialconditionMax)+indexRinitialcondition;
                        subplot(indexRproductionMax,indexRinitialconditionMax,graphnum)
                        eachFig(fs,lw)
                        hold on;
                        
                    end
                    hold off;
                    filename = char(join({fileNamePrefix,  '_', num2str(indexRinitialcondition),num2str(indexRproduction), 'm', num2str(indexSFRPproduction),num2str(indexDproduction),num2str(indexDfunction) '.fig'},''));
                    saveas(figure(3),filename)
                    close(3);
                end
                
            end
            hold off;
            filename4= char(join({fileNamePrefix, '_', 'subplot','x','y', 'm', num2str(indexSFRPproduction),num2str(indexDproduction),num2str(indexDfunction) '.fig'},''));
            saveas(figure(4),filename4)
            close(4);
            
            
            % Wnt variation
            % 2 levels of Wnt production
            for indexRinitialcondition = 1:indexRinitialconditionMax
                for indexRproduction=1:indexRproductionMax
                    for indexWntproduction = 2:indexWntproductionMax
                        figure(13)
                        fs=20;
                        lw=2;
                        eachFig(fs,lw)
                        hold on;
                        
                        
                        figure(14)
                        fs=8;
                        lw=1;
                        graphnum=(indexRproduction-1)*(indexRinitialconditionMax)+indexRinitialcondition;
                        subplot(indexRproductionMax,indexRinitialconditionMax,graphnum)
                        eachFig(fs,lw)
                        hold on;
                        
                    end
                    figure(13)
                    newcolors = [0.8500    0.3250    0.0980
                        0.9290    0.6940    0.1250];
                    colororder(newcolors)
                    
                    hold off;
                    filename = char(join({fileNamePrefix,  '_', num2str(indexRinitialcondition),num2str(indexRproduction), 'm', num2str(indexSFRPproduction), '2' ,num2str(indexDproduction),num2str(indexDfunction) '.fig'},''));
                    saveas(figure(13),filename)
                    close(13);
                end
                
            end
            figure(14)
            newcolors = [0.8500    0.3250    0.0980
                0.9290    0.6940    0.1250];
            colororder(newcolors)
            hold off;
            filename14= char(join({fileNamePrefix, '_', 'subplot','x','y', 'm', num2str(indexSFRPproduction), '2', num2str(indexDproduction),num2str(indexDfunction) '.fig'},''));
            saveas(figure(14),filename14)
            close(14);
        end     
    end
end
            figure(5)
            hold off;
            filename5= char(join({fileNamePrefix, '_', 'subplot','m','m', '3', '1','m','m','.fig'},''));
            saveas(figure(5),filename5)
            close(5);   
%--------------------------------------------------------------------

%y threshold plot
yMax=WntSignalMax;
yMeshNumber=10000;
dy=yMax/yMeshNumber;
xT=NaN(yMeshNumber, indexRproductionMax, indexRinitialconditionMax, indexWntproductionMax, indexSFRPproductionMax, indexDproductionMax,indexDfunctionMax);%xt : yMeshNumber, indexPr, indexRic, indexPw, indexCer
ix=1:xMeshNumber;

for indexDproduction=1:indexDproductionMax
    for indexDfunction=1:indexDfunctionMax
        if (indexDproduction==1) && (indexDfunction==2)||(indexDproduction==1) && (indexDfunction==3) % this results in the same solution as "indexDproduction ==1 & indexBindDn ==1", thus this is skipped.
            continue
        end
        for indexSFRPproduction=1:indexSFRPproductionMax
            for indexRproduction=1:indexRproductionMax
                for indexRinitialcondition=1:indexRinitialconditionMax
                    for indexWntproduction=1:indexWntproductionMax
                        for iY = 1:yMeshNumber
                            yT = dy * iY;
                            ix1=max(ix(WntSignal(:, indexRproduction, indexSFRPproduction, indexRinitialcondition, indexWntproduction, indexDproduction, indexDfunction)>=yT));
                            ix2=ix1+1;
                            ix_right_end_of_receptor_expressed_region = find(x_mesh > 40,1,'first') -2;
                            ylow=WntSignal(ix_right_end_of_receptor_expressed_region, indexRproduction, indexSFRPproduction, indexRinitialcondition, 2, indexDproduction, indexDfunction);%Wnt signal level at the right end of the Fzd7 (R)-expressed region
                            if yT<ylow
                                continue
                            end
                            if ix1==xMeshNumber
                                continue
                            end
                            if isempty(ix1)
                                break
                            end
                            x1=x_mesh(ix1);
                            x2=x_mesh(ix2);
                            y1=WntSignal(ix1, indexRproduction, indexSFRPproduction, indexRinitialcondition, indexWntproduction, indexDproduction, indexDfunction);
                            y2=WntSignal(ix2, indexRproduction, indexSFRPproduction, indexRinitialcondition, indexWntproduction, indexDproduction, indexDfunction);
                            xT(iY, indexRproduction,indexRinitialcondition, indexWntproduction, indexSFRPproduction, indexDproduction, indexDfunction)=(y1-yT)*(x2-x1)/(y1-y2)+x1;
                        end
                    end
                end
            end
        end
    end
end
dxT=reshape((xT(:, :,:, 3,:,:,:)-xT(:, :,:, 2,:,:,:)), [yMeshNumber, indexRproductionMax, indexRinitialconditionMax, indexSFRPproductionMax, indexDproductionMax,indexDfunctionMax]);
dxTmax = max(dxT, [], "all");
for indexDproduction=1:indexDproductionMax
    for indexDfunction=1:indexDfunctionMax
        if (indexDproduction==1) && (indexDfunction==2)||(indexDproduction==1) && (indexDfunction==3) % this results in the same solution as "indexDproduction ==1 & indexBindDn ==1", thus this is skipped.
            continue
        end
        for indexSFRPproduction = 1:indexSFRPproductionMax
            for indexRinitialcondition = 1:indexRinitialconditionMax
                for indexRproduction=1:indexRproductionMax
                    for indexWntproduction = 1:indexWntproductionMax
                        figure(5)
                        fs=8;
                        lw=1;
                        graphnum=(indexRproduction-1)*(indexRinitialconditionMax)+indexRinitialcondition;
                        subplot(indexRproductionMax,indexRinitialconditionMax,graphnum)
                        thresholdFig(fs,lw)
                        hold on;
                    end
                    fig6((indexRproduction-1)*(indexRinitialconditionMax+1)+indexRinitialcondition);
                    fig6((indexRinitialconditionMax+1)*indexRproduction)
                    fig6(indexRinitialcondition+(indexRinitialconditionMax+1)*(indexRproductionMax));
                end
            end
            hold off;
            filename5= char(join({fileNamePrefix, '_', 'subplot_threshold','x','y', 'm', num2str(indexSFRPproduction),num2str(indexDproduction),num2str(indexDfunction) '.fig'},''));
            saveas(figure(5),filename5)
            close(5);
            hold off;
            filename6= char(join({fileNamePrefix, '_', 'subplot_threshold_dif','x','y', 'm', num2str(indexSFRPproduction),num2str(indexDproduction),num2str(indexDfunction) '.fig'},''));
            saveas(figure(6),filename6)
            close(6);
            close all;
        end
        
        % heatmap--------------------------------------------------------------------------
        close all;
        heatmap_(12, [2,2,2,2], 'Wntsignal')
        heatmap_(1, [5,5,55,55], 'Wntligand')
        heatmap_(7, [25,5,5,5], 'Receptor')
        heatmap_(2, [25,5,5,5], 'sFRP')
    end
end
% --------------------------------------------------------------------------
    function fig6(graphnum)
        figure(6)
        subplot(indexRproductionMax+1,indexRinitialconditionMax+1,graphnum)
        fs=8;
        lw=1;
        dxTFig(fs,lw)
        hold on;
    end
% --------------------------------------------------------------------------
    function heatmap_(id,r1_4,name)
        N=100;
        for indexSFRPproduction=1:indexSFRPproductionMax
            for indexWntproduction=1:indexWntproductionMax
                for indexRinitialcondition = 1:indexRinitialconditionMax
                    for indexRproduction=1:indexRproductionMax
                        figure(N);
                        fs=8;
                        lw=1;
                        mcm=myColorMap(r1_4);
                        graphnum=(indexRproduction-1)*(indexRinitialconditionMax)+indexRinitialcondition;
                        subplot(indexRproductionMax,indexRinitialconditionMax,graphnum)
                        solInterpolatedFig(fs,lw,id,mcm)
                        hold on;
                    end
                end
                filename= char(join({fileNamePrefix, '_', 'subplot_',name,'_heatmap', num2str(indexWntproduction), num2str(indexSFRPproduction),num2str(indexDproduction),num2str(indexDfunction) '.fig'},''));
                saveas(figure(N),filename)
                close(N);
            end
        end
    end

% --------------------------------------------------------------------------
    function eachFig(FS,LW)
        semilogy(x*x00, WntSignal(:, indexRproduction, indexSFRPproduction, indexRinitialcondition, indexWntproduction, indexDproduction, indexDfunction)*b00+1, 'LineWidth',LW)
        ylim([1 WntSignalMax*b00+1])
        xlabel('distance [\mum]');
        ylabel('Wnt signal [nM] + 1');
        ax = gca;
        ax.FontSize = FS;
        drawnow
    end
% colormap--------------------------------------------------------------------------
    function RGBall=myColorMap(r1_4)
        r1 = r1_4(1);
        r2 = r1_4(2);
        r3 = r1_4(3);
        r4 = r1_4(4);
        %region1
        R1=zeros(1,r1+1).';
        G1=zeros(1,r1+1).';
        B1=(0:1/r1:1).';
        RGB1=[R1,G1,B1];
        %region2
        R2=zeros(1,r2).';
        G2=(1/r2:1/r2:1).';
        B2=ones(1,r2).';
        RGB2=[R2,G2,B2];
        %region3
        R3=(1/r3:1/r3:1).';
        G3=ones(1,r3).';
        B3=(1-1/r3:-1/r3:0).';
        RGB3=[R3,G3,B3];
        %region4
        R4=ones(1,r4)';
        G4=(1-1/r4:-1/r4:0).';
        B4=zeros(1,r4).';
        RGB4=[R4,G4,B4];
        %all
        RGBall=[RGB1;RGB2;RGB3;RGB4];
    end
% --------------------------------------------------------------------------

    function solInterpolatedFig(FS,~,MOL,mcm)
        log(maxSolInterpolated(MOL)*b00+1)
        colormap(mcm)
        if MOL==1
            clims=[0 10^(-2)];
        else
            clims = [0 log(maxSolInterpolated(MOL)*b00+1)];
        end
        load(solInterpolatedFileName(), 'solInterpolated')
        imagesc(x*x00, t*t00,  log(solInterpolated(:,:,MOL)*b00+1), clims)
        colorbar
        if MOL==12 || MOL == 7
            xlim([0 50]);
        end
        xlabel('distance [\mum]');
        ylabel('time [sec]');
        ax = gca;
        ax.FontSize = FS;
        drawnow
    end
% --------------------------------------------------------------------------

    function thresholdFig(FS,LW)
        semilogx(dy*(1:yMeshNumber)*b00, xT(:, indexRproduction,indexRinitialcondition, indexWntproduction, indexSFRPproduction, indexDproduction, indexDfunction), 'LineWidth',LW)
        xlim([0.05 WntSignalMax*b00])
        ylim([xmin xmax])
        xlabel('Wnt signal threshold [nM]');
        ylabel('distance [\mum]');
        ax = gca;
        ax.FontSize = FS;
        drawnow
    end
% --------------------------------------------------------------------------
    function dxTFig(FS,LW)
        semilogx(dy*(1:yMeshNumber)*b00, dxT(:, indexRproduction,indexRinitialcondition, indexSFRPproduction, indexDproduction, indexDfunction), 'LineWidth',LW)
        xlim([0.05 WntSignalMax*b00])
        ylim([-5 dxTmax])
        xlabel('threshold [nM]');
        xticks(10.^(-2:2))
        ylabel({'difference in','position [\mum]'});
        ax = gca;
        ax.FontSize = FS;
        grid on
        grid minor
        drawnow
    end

%-----------------------------------
    function suffix = fileNameSuffixForSol()
        suffix = strcat(strjoin({num2str(indexRproduction),num2str(indexSFRPproduction),num2str(indexRinitialcondition),num2str(indexWntproduction),num2str(indexDproduction),num2str(indexDfunction)}, '_'), '.mat');
    end
    function fileName = solFileName()
        fileName = strcat(fileNamePrefix, '_sol_', fileNameSuffixForSol());
    end
    function fileName = solInterpolatedFileName()
        fileName = strcat(fileNamePrefix, '_solInterp_', fileNameSuffixForSol());
    end
% --------------------------------------------------------------------------
    function [c,f00,s00] = pdex1pde(x,~,b,DbDx)
        c = [1;1;1;1;1;1;1;1;1;1;1;1;1;1];
        %f = [D;D;D;0;0;0;0;0].*DbDx;
        f00 = [D00;D00;D00;0;0;0;0;0;0;0;0;0;0;0].*DbDx;
        s00 = [-k002*b(1)*b(2)+k0020*b(3)-k002*b(1)*b(5)+k0020*b(6)-k001*b(1)*b(7)^2+k0010*b(8)-k005*b(1)*b(9)^2+k0010*b(10)-k006*b(1)*b(7)*b(9)+k0010*b(11)+pw*p001*Wntsource(x);...%1_W
            -k002*b(1)*b(2)+k0020*b(3)-k003*b(2)*b(4)+k0030*b(5)+p002*sFRPsource(x)*(1/((b(12)/Kd000)^2+1));...%2_S
            +k002*b(1)*b(2)-k0020*b(3)-k003*b(3)*b(4)+k0030*b(6);...%3_WS
            -k003*b(2)*b(4)+k0030*b(5)-k003*b(3)*b(4)+k0030*b(6);...%4_H
            -k002*b(1)*b(5)+k0020*b(6)+k003*b(2)*b(4)-k0030*b(5);...%5_SH
            +k002*b(1)*b(5)-k0020*b(6)+k003*b(3)*b(4)-k0030*b(6);...%6_WSH
             +2*(-k001*b(1)*b(7)^2+k0010*b(8))-k006*b(1)*b(7)*b(9)+k0010*b(11)-k007*b(1)*b(7)*b(9)+k0010*b(13)+p003*k004*b(8);...%7_receptor
            +k001*b(1)*b(7)^2-k0010*b(8)-k004*b(8);...%8_WR2
            +2*(-k005*b(1)*b(9)^2+k0010*b(10))-k006*b(1)*b(7)*b(9)+k0010*b(11)-k007*b(1)*b(7)*b(9)+k0010*b(13)+2*(-k007*b(1)*b(9)^2+k0010*b(14))+p004*k004*b(8);...%9_D
            +k005*b(1)*b(9)^2-k0010*b(10);...%10_WD2
            +k006*b(1)*b(7)*b(9)-k0010*b(11);...%11_WRD
            k004*b(8);...%12_Wntsignal
            k007*b(1)*b(7)*b(9)-k0010*b(13);...%13_RD
            k007*b(1)*b(9)^2-k0010*b(14);...%14_DD
            ];
    end
% --------------------------------------------------------------------------
    function b000 = pdex1ic(x)%initial condition of receptor and HS
        if (x00s < x) && (x < x00s30)
            r0002 = ric*r000*(sin(pi*(x-10)/15-pi/2)+1);%receptor initial condition
            a00a = a00*(sin(pi*(x-10)/15-pi/2)+1);%N-acetyl HS initial condition
            
        else
            r0002 = 0;
            a00a = 0;
        end
        b000 =[0;0;0;a00a;0;0;r0002;0;0;0;0;0;0;0];
        
    end
% --------------------------------------------------------------------------
    function [pl,ql,pr,qr] = pdex1bc(~,~,~,~,~)%boundary condition
        pl =[0;0;0;0;0;0;0;0;0;0;0;0;0;0]; %p at xmin
        ql =[1;1;1;1;1;1;1;1;1;1;1;1;1;1]; %q at xmin
        pr =[0;0;0;0;0;0;0;0;0;0;0;0;0;0]; %p at xmax
        qr =[1;1;1;1;1;1;1;1;1;1;1;1;1;1]; %q at xmax
    end
    function y=Wntsource(x)
        y = 1-heaviside(x-x00min-x00s);
    end
    function y=sFRPsource(x)
        y = heaviside(x-(x00max-x00s2));%To set the source peak at the position as that of Wnt, use 1-heaviside(x-x00s2); %The source area is different from that of Wnt because x00s is not equal to x00s2
    end


end