
install.packages("dplyr")
library(dplyr)
othcell_trj_all_2<-read.table(file = "clipboard", 
                                         sep = "\t", header=TRUE)
install.packages("gee")
library(gee)
library(lme4)
library(afex)
#Temporal change of cell types 
df<-c()
for (i in 16:19) {
  mixed=lmer(othcell_trj_all_2[,i] ~ year + (1| patient_id), data=othcell_trj_all_2)
  cell_type<-names(othcell_trj_all_2)[i]
  coefficient <- coef(summary(mixed))[2,1]
  P <- coef(summary(mixed))[2,5]
  table <- as.data.frame(cbind(cell_type,coefficient, P))
  df <- bind_rows(df, table)
}
#calculate FDR
df$P<-as.numeric(df$P)
FDR=round(p.adjust(df$P, "BH"), 3)
df<-cbind(df,FDR)
# adjust for sex, age at diagnosis
df<-c()
for (i in 16:19) {
  mixed=lmer(othcell_trj_all_2[,i] ~ year +sex+diag_age+ (1| patient_id), data=othcell_trj_all_2)
  cell_type<-names(othcell_trj_all_2)[i]
  coefficient <- coef(summary(mixed))[2,1]
  P <- coef(summary(mixed))[2,5]
  table <- as.data.frame(cbind(cell_type,coefficient, P))
  df <- bind_rows(df, table)
}
#calculate FDR
df$P<-as.numeric(df$P)
FDR=round(p.adjust(df$P, "BH"), 8)
df<-cbind(df,FDR)

#associations between biomakers and ALS-FRS
#adjusted by diagnostic age and sex
df<-c()
for (i in 27:30) {
  m=(othcell_trj_all_2[,i]/sd(othcell_trj_all_2[,i],na.rm = T))
  ge <- gee(alsfrs_near_test_score ~m+diag_age+sex , data = othcell_trj_all_2, id=patient_id,corstr="independence")
  cell_type<-names(othcell_trj_all_2)[i]
  coefficient <- coef(summary(ge))[2,1]
  P <- format(round((2 * pnorm(abs(coef(summary(ge))[2,5]), lower.tail = FALSE)), 3),nsmall=2)
  table <- as.data.frame(cbind(cell_type,coefficient, P))
  df <- bind_rows(df, table)
}
#calculate FDR
df$P<-as.numeric(df$P)
FDR=round(p.adjust(df$P, "BH"), 8)
df<-cbind(df,FDR)


# Show the relationship between biomarkers and progression rate
#adjusted by diagnostic age and sex
df<-c()
for (i in 27:30) {
  m=(othcell_trj_all_2[,i]/sd(othcell_trj_all_2[,i],na.rm = T))
  ge <- gee(pr_near_test ~m+diag_age+sex , data = othcell_trj_all_2, id=patient_id,corstr="independence")
  cell_type<-names(othcell_trj_all_2)[i]
  coefficient <- coef(summary(ge))[2,1]
  P <- 2 * pnorm(abs(coef(summary(ge))[2,5]), lower.tail = FALSE)
  table <- as.data.frame(cbind(cell_type,coefficient, P))
  df <- bind_rows(df, table)
}
df$P<-as.numeric(df$P)
FDR=round(p.adjust(df$P, "BH"), 8)
df<-cbind(df,FDR)
