function [QMatrix] = MakeQMatrix(par, Calcium)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%This script computes the intensity matrix in the PIP2-synaptotagmin
%%%model based on the parameter vector and the calcium concentration.

%Inputs
% par - model parameters (obtained with model_parameters)
% calcium - calcium concentration to evaluate

%Outputs
%Qmatrix - intensity matrix

k_onCa = par(1);
KD = par(2);
k_onPIP2 = par(3);
PIP2 = par(4);
c = par(5);
l = par(6);
f = par(7);
nSyts = par(8);
k_dPIP2 = par(9);
CaCoop = par(13);
maxCross = par(14);

kalpha = k_onCa * Calcium^CaCoop;
kbeta = KD*k_onCa;
kgamma = PIP2 * k_onPIP2;
kdelta = k_dPIP2*k_onPIP2;

maxCross1 = maxCross;  %can be viewed as the total number of slots
if maxCross > nSyts
    maxCross = nSyts;
end

% nstates = indCal(nSyts, maxCross, maxCross, nSyts-maxCross, 0);

[indices] = indCal_all(nSyts, maxCross);

nstates = indices(maxCross+1, nSyts-maxCross+1, 1);

QMatrix = zeros(nstates+1);

% nStatesCurPipCa = zeros(1,nSyts+1);

% for k = 0:nSyts %Counting number of different states with k Pip2--Ca associations
%     nStatesCurPipCa(k+1) = nchoosek(3+(nSyts-k)-1,(nSyts-k));
% end
% 
% indCal = @(comb,Ca,PIP)(sum(nStatesCurPipCa(1:comb))+sum(nSyts-comb-(0:(Ca-1))+1)+(PIP+1));%THIS FUNCTION FINDS THE INDEX OF A STATE GIVEN PIP--Ca, Ca, and PIP
% ind_test = 0
for k = 0:maxCross %Number of PipCa-together
    for m = 0:(nSyts-k) %Number of Ca
        for n = 0:(maxCross-k-max(m-(nSyts-maxCross),0)) %Number of PIP2
%             ind_test = ind_test+1;
            curIndex = indices(k+1,m+1,n+1);
%             test(ind_test) = curIndex;
            
            if k > 0 %Unbinding of Ca or PIP from Ca-PIP
                QMatrix(curIndex, indices(k, m+1,n+2)) = k*c*kbeta; %Unbinding of Ca from PIPCa
                QMatrix(curIndex, indices(k, m+2,n+1)) = k*c*kdelta; %Unbinding of PIP from PIPCa
            end
            
            if m > 0 %Unbinding of single Ca
                QMatrix(curIndex, indices(k+1, m, n+1)) = m*kbeta; 
            end

            if n > 0 %Unbinding of single PIP
                QMatrix(curIndex, indices(k+1, m+1, n)) = n*kdelta; 
            end
            
            if (k+n) < maxCross && m > 0 %Binding of PIP to Ca to form PIP-Ca
                QMatrix(curIndex, indices(k+2, m, n+1)) = (maxCross1-(k+n))*m*kgamma;
            end
            
            if  n > 0 %Binding of Ca to PIP to form PIP-Ca
                QMatrix(curIndex, indices(k+2, m+1, n)) = n*kalpha;
            end
            
            if (k+m+n) < nSyts %Binding of single Ca and single PIP
                QMatrix(curIndex, indices(k+1, m+2, n+1)) = (nSyts-k-m-n) * kalpha;
                if (k+n) < maxCross
                    QMatrix(curIndex, indices(k+1, m+1, n+2)) = (maxCross1-(k+n))*(nSyts-k-m-n) * kgamma;
                end
            end
            
            QMatrix(curIndex, end) = l*f^k;
            QMatrix(curIndex, curIndex) = - sum(QMatrix(curIndex,:));
        end
    end
end

% QMatrix = QMatrix';
