function [fused_over_time, below1_t] = P_function_limit(QMatrix, SS_eq, t_vec)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%This script calculates the release probability at the time points in the
%%%time vector, t_vec, given steady state and intensity matrix.


%INPUTS:
% QMatrix is the intensity matrix
% t contains time points and may be a vector.
% SS_eq is the steady state, column vector normalized to 1

%OUTPUT
%fused_over_time - probaility of fusion at the specified time points
% (inputted as t_vec)
%below1_t - time point at which the release probability hits 1 (if reached - else NAN)


fused_over_time = zeros(length(t_vec),1);

below1 = 1;
below1_t = NaN;
for k = 1:length(t_vec)
    
    if below1
        tp = t_vec(k);

        if tp <=0
            fused_over_time(k) = 0;
        else
            states = statefunc(SS_eq, QMatrix, tp);
            fused_over_time(k) = states(end);
        end
        
        if fused_over_time(k) >= 1
            below1 = 0;
            below1_t = tp;
        end
    else
        fused_over_time(k) = 1;
    end
    
end

