function [index] = indCal(nSyts, maxCross, comb, Ca, PIP)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%This Script calculates the state number in the PIP2-synaptotagmin model 
%%%based on the number of Ca, PIP, or both bound.

%Input
% nSyts - number of syts
%Maxcross - number of slots
%comb - number of syts having bound ca and PIP
%Ca - number of syts having bound calcium
%PIP - number of syts having bound PIP2

%%PARTIAL
% nSyts = 3;
% maxCross = 2;
% inds = 0;
count = 0;
index = 0;
k = 0;
n = 0;
p = 0;

for k = 0:comb %PIPCa
    for n = 0:(nSyts-k) %Ca
        for p = 0:(maxCross-k-max(n-(nSyts-maxCross),0)) %PIP

                count = count + 1;
%                 inds(count) = count;
            if ((comb == k) && (Ca==n) && (PIP==p))
                index = count;
                break
            end            
        end
        if index
            break
        end
    end
    if index
        break
    end
end




