function [indices] = indCal_all(nSyts, maxCross)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%This Script calculates the state number in the PIP2-synaptotagmin model 
%%%corresponding to the number of syts per vesicle having bound nothing,
%%%pip2, calcium or both

%Input
% nSyts - number of syts
%Maxcross - number of slots

%Output indices - index numbers states - corresponding number of syts
%having bound nothing, PIP, Ca and both. first
%value: #syts with PIPca, second value:#syts with PIP, Third: #syts with Ca 


%%PARTIAL
% nSyts = 3;
% maxCross = 2;
% inds = 0;
count = 0;

indices = zeros(nSyts+1, nSyts+1, nSyts+1);


for k = 0:maxCross %PIPCa
    for n = 0:(nSyts-k) %Ca
        for p = 0:(maxCross-k-max(n-(nSyts-maxCross),0)) %PIP

                count = count + 1;
                indices(k+1,n+1,p+1) = count;
        end
    end
end





