function [syt_set, slot_set] = variability_choice(n_draw, nves, varSyt_IO, varSlot_IO, nsyts_mean, nslots_mean)
    

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%This script generates sets of syt copy numbers and number of slots.

%INPUTS:
%n_draw - number of simulations
%nves - number og SVs per simulation
%varSyt_IO - whether or not to vary number of syts per SV (0 or 1)
%varSlot_IO - whether or not to vary number of slots per SV (0 or 1)
%nsyts_mean - mean number of syts
%nslots_mean - mean number of slots

%OUTPUTS:
%syt_set - matrix of syt copy numbers of the size 
% [number of simulations]x[number og SVs per simulation]
%slot_set  - matrix of number of slots of the size 
% [number of simulations]x[number og SVs per simulation]



maxCross = nslots_mean;%par(14);
nsyts = nsyts_mean;%par(8);


if ~varSlot_IO
    slot_set = repmat(maxCross, n_draw, nves);
elseif varSlot_IO == 1
    slot_set = binornd(6,0.5,n_draw, nves);
elseif varSlot_IO == 2    
    slot_set = round(normrnd(3,0.75,n_draw, nves));
    slot_set(slot_set<0) = 0;
elseif varSlot_IO == 3   
    slot_set = randi([0 6],n_draw, nves);
    slot_set(slot_set<0) = 0;
elseif varSlot_IO == 4
    slot_set = poissrnd(3,n_draw,nves);
elseif varSlot_IO == 5   
    slot_set = randi([3 6],n_draw, nves);
else
    warning('Wrong choice of slot variability')
end


if ~varSyt_IO
    syt_set = repmat(nsyts, n_draw, nves);
elseif varSyt_IO == 1
    syt_set = binornd(30,0.5,n_draw,nves);  
elseif varSyt_IO == 2
    syt_set = poissrnd(15,n_draw,nves);
    invalid_inds = find(syt_set(:)>30);
    syt_set(invalid_inds) = 30;
elseif varSyt_IO == 3
    syt_set = binornd(40,15/40,n_draw,nves);
elseif varSyt_IO == 4
    syt_set = randi([1 30],n_draw,nves);    
else
    warning('Wrong choice of syt variability')
end

% if sum(slot_set(:)>syt_set(:))
%     invalid_inds = find(slot_set(:)>syt_set(:));
%     slot_set(invalid_inds) = syt_set(invalid_inds);
% end    

