function [] = calculate_generic_functions_addTime()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script adds a longer time span to functions already evaluated and
%%%%stored in cell variables with "generic" functions.

% fitslot = 4;

fitslot = 3;

lambda = 2;
fitchoice = 6;
Lplus = 423;
excludeOutl = 0;
t_add_val = 10;

allost_IO = 1;



if allost_IO
    if fitchoice == 17
        filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_lambda' num2str(lambda) '.mat'];
    elseif fitchoice == 6
        filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '.mat'];
    end
else
    filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_A1.mat'];
end



% Calciums = Calciums;

load(filename)
Calciums = Calciums;

% Calciums = [0.01 0.1 0.5 1 1.5 2 5 10 20 30 40 50 60 70 80];
% Calciums = [0.01 0.1 0.2 0.3 0.4 0.5 1 1.5 2 3 4 5 6 7 8 9 10 20 30 40 50 60 70 80];
% 
% nsyts = 1:30;
% nslots = 1:6;



Ca_0 = 0.05;


% load('exact_model_combifit15_nsyt15_leaveout1_lambda5_nves4000_CaCoop2_maxCross3_nvessd2000.mat', 'par')

% 
% if fitslot == 1
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross1_parinitno28.mat','par')
% elseif fitslot == 2
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross2_parinitno37.mat','par')
% elseif fitslot == 3
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross3_parinitno35.mat','par')
% elseif fitslot == 4
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross4_parinitno35.mat','par')
% end

par_loop = par;


for k = 3
    for l = 1
        
        nsyt = nsyts(l);
        
%         if k>l
%             nslot = l;
%         end
        
        nslot = nslots(k);
        

%         if ~isempty(test)
%             disp(['nsyt = ' num2str(nsyt) ', nslot = ' num2str(nslot)])
%             disp('Already done or invalid')
%         else
%             if k == 2
                Ca_inds = 28;
%             elseif k == 3
%                 Ca_inds = 11:12;
%             end
            for m = Ca_inds

%                 if k <= l
                    par_here = par_loop;

                    Calcium = Calciums(m);
                    disp(['Calcium = ' num2str(Calcium) ', nsyt = ' num2str(nsyt) ', nslot = ' num2str(nslot)])

                    par_here(8) = nsyt;
                    par_here(14) = nslot;

                    t_vec_fus_old = tvec_fus_cells{m,l,k};

                    t_max_old = t_vec_fus_old(end);
                    t_add = (t_max_old+0.00001):0.00001:(t_max_old+t_add_val);
        
                    fused_over_time = P_cells{m,l,k};
%                     dfused_over_time = dP_cells{m,l,k};

                    [QMatrix] = MakeQMatrix(par_here, Calcium);
                    [SS_eq] = steady_state_newmethod(par_here, 1, Ca_0);
                    SS_eq(end+1) = 0;
                    [fused_over_time_add, below1_t] = P_function_limit(QMatrix, SS_eq, t_add);
%                     [dfused_over_time_add, ~] = dP_function_limit(QMatrix, SS_eq, t_add, below1_t);

%                     dP_cells{m,l,k} = [dfused_over_time; dfused_over_time_add];
                    P_cells{m,l,k} = [fused_over_time; fused_over_time_add];
%                     SS_eq_cells{m,l,k} = SS_eq;
%                     QMatrix_cells{m,l,k} = QMatrix;
                    tvec_fus_cells{m,l,k} = [t_vec_fus_old t_add];
    %                 save('./Outputs/Figure_results//generic_functions_bestfit.mat', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_cells', 'Calciums', 'nsyts', 'nslots', '-v7.3')
%                 end
            end
            
%         end
%         save(filename, 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells',  'Calciums', 'nsyts', 'nslots', '-v7.3')
    end
    save(filename, 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells',  'Calciums', 'nsyts', 'nslots', '-v7.3')

end

% save(filename, 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells',  'Calciums', 'nsyts', 'nslots', '-v7.3')


 %%%%%%
if 0==1
clear

allost_IO = 1;
fitslot = 3;
lambda = 2;
fitchoice = 6;
Lplus = 423;
excludeOutl = 0;
t_add_val = 10;

if allost_IO
    if fitchoice == 17
        filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_lambda' num2str(lambda) '.mat'];
    elseif fitchoice == 6
        filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '.mat'];
    end
else
    filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_A1.mat'];
end


load(filename)

% Calciums = [0.01 0.1 0.5 1 1.5 2 5 10 20 30 40 50 60 70 80];
% Calciums = [0.01 0.1 0.2 0.3 0.4 0.5 1 1.5 2 3 4 5 6 7 8 9 10 20 30 40 50 60 70 80];
% 
% nsyts = 1:30;
% nslots = 1:6;



Ca_0 = 0.05;


% load('exact_model_combifit15_nsyt15_leaveout1_lambda5_nves4000_CaCoop2_maxCross3_nvessd2000.mat', 'par')
% 

% if fitslot == 1
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross1_parinitno28.mat','par')
% elseif fitslot == 2
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross2_parinitno37.mat','par')
% elseif fitslot == 3
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross3_parinitno35.mat','par')
% elseif fitslot == 4
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross4_parinitno35.mat','par')
% end

par_loop = par;

for k = 3
    for l = 1:20
        nsyt = nsyts(l);
        nslot = nslots(k);


%         if ~isempty(test)
%             disp(['nsyt = ' num2str(nsyt) ', nslot = ' num2str(nslot)])
%             disp('Already done or invalid')
%         else
            for m = 24

%                 if k <= l
                    par_here = par_loop;

                    Calcium = Calciums(m);
                    disp(['Calcium = ' num2str(Calcium) ', nsyt = ' num2str(nsyt) ', nslot = ' num2str(nslot)])

                    par_here(8) = nsyt;
                    par_here(14) = nslot;

                    t_vec_fus_old = tvec_fus_cells{m,l,k};

                    t_max_old = t_vec_fus_old(end);
                    t_add = (t_max_old+0.00001):0.00001:(t_max_old+t_add_val);
        
                    fused_over_time = P_cells{m,l,k};
%                     dfused_over_time = dP_cells{m,l,k};

                    [QMatrix] = MakeQMatrix(par_here, Calcium);
                    [SS_eq] = steady_state_newmethod(par_here, 1, Ca_0);
                    SS_eq(end+1) = 0;
                    [fused_over_time_add, below1_t] = P_function_limit(QMatrix, SS_eq, t_add);
%                     [dfused_over_time_add, ~] = dP_function_limit(QMatrix, SS_eq, t_add, below1_t);

%                     dP_cells{m,l,k} = [dfused_over_time; dfused_over_time_add];
                    P_cells{m,l,k} = [fused_over_time; fused_over_time_add];
%                     SS_eq_cells{m,l,k} = SS_eq;
%                     QMatrix_cells{m,l,k} = QMatrix;
                    tvec_fus_cells{m,l,k} = [t_vec_fus_old t_add];
    %                 save('./Outputs/Figure_results//generic_functions_bestfit.mat', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_cells', 'Calciums', 'nsyts', 'nslots', '-v7.3')
%                 end
            end
%         end
    end
        save(filename, 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells',  'Calciums', 'nsyts', 'nslots', '-v7.3')

%     save(['./Outputs/Figure_results/generic_functions_bestfit_slot' num2str(fitslot) '_bkp.mat'], 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_cells', 'Calciums', 'nsyts', 'nslots', '-v7.3')
 end  
 end