function plot_fig2sup2_barplots_LINEARCA

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the histograms of crosslinks before fusion with
%%%%linear calcium signal
%%%%(Figure 2 - figure supplement 2 panel B right)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the histograms of crosslinks before fusion with
%%%%linear calcium signal
%%%%(Figure 2 - figure supplement 2 panel B right)

nsyts = 15;

for fitslot = 6
    
    
    nslots = fitslot; 
    
    zeroCross_inds = indCal(nsyts, nslots, 0, 0, 0):indCal(nsyts, nslots, 0, nsyts, 0);
    oneCross_inds = indCal(nsyts, nslots, 1, 0, 0):indCal(nsyts, nslots, 1, nsyts-1, 0);
    twoCross_inds = indCal(nsyts, nslots, 2, 0, 0):indCal(nsyts, nslots, 2, nsyts-2, 0);
    threeCross_inds = indCal(nsyts, nslots, 3, 0, 0):indCal(nsyts, nslots, 3, nsyts-3, 0);
    fourCross_inds = indCal(nsyts, nslots, 4, 0, 0):indCal(nsyts, nslots, 4, nsyts-4, 0);
    fiveCross_inds = indCal(nsyts, nslots, 5, 0, 0):indCal(nsyts, nslots, 5, nsyts-5, 0); 
    sixCross_inds = indCal(nsyts, nslots, 6, 0, 0):indCal(nsyts, nslots, 6, nsyts-6, 0); 

    load(['./Outputs/Figure_results/Figure3/cross_before_fusions_individualruns_fitslot' num2str(fitslot) '_Allost1_MORECALCIUM_linearCA_singlevessim.mat'])

    histvals = NaN(length(ramp_times),5);
    no_cross_bef_fuse = NaN(size(state_before_fuse));
    for kRamp = 1:length(ramp_times)
        for l = 1:1e3
            no_cross_bef_fuse(kRamp,l) = sum(state_before_fuse(kRamp, l)==zeroCross_inds)*0 + sum(state_before_fuse(kRamp, l)==oneCross_inds)*1 + sum(state_before_fuse(kRamp, l)==twoCross_inds)*2 + sum(state_before_fuse(kRamp, l)==threeCross_inds)*3 ...
                 + sum(state_before_fuse(kRamp, l)==fourCross_inds)*4 + sum(state_before_fuse(kRamp, l)==fiveCross_inds)*5 + sum(state_before_fuse(kRamp, l)==sixCross_inds)*6; 
        end
        for k = 1:5
            if k<=4
                histvals(kRamp, k) = sum(no_cross_bef_fuse(kRamp,:)==k)/1e3;
            elseif k==5
                histvals(kRamp,k) = (sum(no_cross_bef_fuse(kRamp,:)==k)+sum(no_cross_bef_fuse(kRamp,:)==k+1) )/1e3;
            end
        end
    end
    
    
    figure
    hist_cats = {'0-1 crosslink', '2 crosslinks', '3 crosslinks', '4 crosslinks', '5-6 crosslinks'};
    bar(histvals')
    set(gca, 'XTickLabel', hist_cats)

    legend('100 ms', '75 ms', '50 ms', '25 ms', '10 ms', '5 ms', '1 ms', '0.001 ms')

    lgd = legend
    lgd.FontSize = 8
    lgd.Location = 'NorthWest'
    title(['Fitslot = ' num2str(fitslot)])
    ylim([0 1])
    ylabel('Percent of fusions')
    set(gca, 'TickDir', 'out')
    
    
    cross_before_mean = mean(no_cross_bef_fuse,2);
    cross_before_sd = std(no_cross_bef_fuse, [], 2);
    

    
    
    figure
    plot(ramp_times, cross_before_mean, 'o')
    hold on
    for k = 1:length(ramp_times)
        plot([ramp_times(k) ramp_times(k)], [-cross_before_sd(k) cross_before_sd(k)]+cross_before_mean(k), 'k-')
    end
    
    
end