function plot_fig2sup2_barplots_moreCa

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the histograms of crosslinks before fusion with
%%%%step calcium signal
%%%%(Figure 2 - figure supplement 2 panel B left)


nsyts = 15;

for fitslot = 6
    
    
    nslots = fitslot; 
    
    zeroCross_inds = indCal(nsyts, nslots, 0, 0, 0):indCal(nsyts, nslots, 0, nsyts, 0);
    oneCross_inds = indCal(nsyts, nslots, 1, 0, 0):indCal(nsyts, nslots, 1, nsyts-1, 0);
    twoCross_inds = indCal(nsyts, nslots, 2, 0, 0):indCal(nsyts, nslots, 2, nsyts-2, 0);
    threeCross_inds = indCal(nsyts, nslots, 3, 0, 0):indCal(nsyts, nslots, 3, nsyts-3, 0);
    fourCross_inds = indCal(nsyts, nslots, 4, 0, 0):indCal(nsyts, nslots, 4, nsyts-4, 0);
    fiveCross_inds = indCal(nsyts, nslots, 5, 0, 0):indCal(nsyts, nslots, 5, nsyts-5, 0); 
    sixCross_inds = indCal(nsyts, nslots, 6, 0, 0):indCal(nsyts, nslots, 6, nsyts-6, 0); 

    load(['./Outputs/Figure_results/Figure3/cross_before_fusions_individualruns_fitslot' num2str(fitslot) '_Allost1_MORECALCIUM.mat'])

    histvals = NaN(length(Calciums),5);
    no_cross_bef_fuse = NaN(size(state_before_fuse));
    for kCa = 1:length(Calciums)
        for l = 1:1e4
            no_cross_bef_fuse(kCa,l) = sum(state_before_fuse(kCa, l)==zeroCross_inds)*0 + sum(state_before_fuse(kCa, l)==oneCross_inds)*1 + sum(state_before_fuse(kCa, l)==twoCross_inds)*2 + sum(state_before_fuse(kCa, l)==threeCross_inds)*3 ...
                 + sum(state_before_fuse(kCa, l)==fourCross_inds)*4 + sum(state_before_fuse(kCa, l)==fiveCross_inds)*5 + sum(state_before_fuse(kCa, l)==sixCross_inds)*6; 
        end
        for k = 1:5
            if k<=4
                histvals(kCa, k) = sum(no_cross_bef_fuse(kCa,:)==k)/1e4;
            elseif k==5
                histvals(kCa,k) = (sum(no_cross_bef_fuse(kCa,:)==k)+sum(no_cross_bef_fuse(kCa,:)==k+1) )/1e4;
            end
        end
    end
    
    
    figure
    hist_cats = {'0-1 crosslink', '2 crosslinks', '3 crosslinks', '4 crosslinks', '5-6 crosslinks'};
    bar(histvals')
    set(gca, 'XTickLabel', hist_cats)
    if length(Calciums) == 3
        legend('[Ca^{2+}] = 2 \mu M', '[Ca^{2+}] = 10 \mu M', '[Ca^{2+}] = 50 \mu M')
    elseif length(Calciums)==6
        legend('[Ca^{2+}] = 0.5 \mu M', '[Ca^{2+}] = 1 \mu M', '[Ca^{2+}] = 50 \mu M', '[Ca^{2+}] = 100 \mu M', '[Ca^{2+}] = 200 \mu M', '[Ca^{2+}] = 400 \mu M')
    end
    lgd = legend
    lgd.FontSize = 8
    lgd.Location = 'NorthWest'
    title(['Fitslot = ' num2str(fitslot)])
    ylim([0 1])
    ylabel('Percent of fusions')
    set(gca, 'TickDir', 'out')
    
    
    
    cross_before_mean = mean(no_cross_bef_fuse,2);
    cross_before_sd = std(no_cross_bef_fuse, [], 2);
    

    
    
    figure
    plot(Calciums, cross_before_mean, 'o')
    hold on
    for k = 1:length(Calciums)
        plot([Calciums(k) Calciums(k)], [-cross_before_sd(k) cross_before_sd(k)]+cross_before_mean(k), 'k-')
    end
    
    
end