function spaceExploration()

%%% This script evaluates the model for different fixed variable values
%%% Author: Manon M. M. Berns

% General settings of the model
maxCross = 3;
nsyts =15;
CaCoop =2;
nves = 4000;
nves_sd = 2000;
exclude_two = 0;
fit_choice = 6; 
write_log =0;
leaveout_low = 0;

% Determine range of parameter values
x= log10(24.6997) + 60/29; y = x-4;
konCa = logspace(y, x, 30);
x= log10(124.7384) + 60/29; y = x-4;
konPIP  = logspace(y,x, 30);
x= log10(1.1092) + 60/29; y = x-4;
PIP = logspace(y,x , 30);
F = 128.2104; % F fixed at best fit- favalue

par_init = 0.4;
options = optimset('Display', 'off', 'MaxIter', 1e4, 'MaxFunEvals', 1e4);
KD =0;
Results = nan(length(konCa)*length(konPIP)*length(PIP)*length(F), 8); 

i=0;
for a = 1:length(konCa)
    for b = 1:length(konPIP)
        for c =1:length(PIP)
            disp(['Evaluating: ', num2str(a),'/', num2str(length(konCa)), ', ', num2str(b),'/' , num2str(length(konPIP)), ' ', num2str(c) '/' num2str(length(PIP)), '    Timepoint: ' datestr(now,'HH:MM:SS')] )
            for d = 1:length(F)
                i = i+1;
                par_fitted = [konCa(a), konPIP(b), PIP(c), F(d)];
                
                % Optimize for the added latency value
                optim_func = @(Added_delay)delay_likeli_new(Added_delay, par_fitted, nsyts, fit_choice, exclude_two, nves, CaCoop, maxCross, nves_sd,F, KD);
                           
                [par_added_delay, loglikeli_delay] = fminsearch(optim_func, par_init, options);
                
                par = model_parameters([par_fitted, par_added_delay], fit_choice, nsyts, nves, CaCoop, maxCross, nves_sd, F, KD);
                
                [least_squares_rates, loglikeli_rates] = cost_rates_PIPon(par, exclude_two, leaveout_low, write_log);
               
                Results(i,:) = [par_fitted, par_added_delay, loglikeli_delay, least_squares_rates, loglikeli_rates];
            
            end
        end
    end
    minlikeli = min(Results(:,6), [], 'omitnan');
    mincosts = min(Results(:,7), [], 'omitnan');
   
    disp(['***** 1 ROUND FINISHED ******' '/n' 'min likeli= ' num2str(minlikeli) ' min costs: ' num2str(mincosts)])
    save(['Costs_explore_paramspace20210518.mat'], 'Results');
end
end
                
               