%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% This script plots the results for variability in RRP and Syts and their
%%% effect on APevoked responses
%%% used for plotting Figure 5D and E

load('20210628_AP_evokedEPSCs_variability.mat')

% Plotting results large RRP

%% Figure large RRP, variable syt

avg = mean(EPSC_single_cell_largeRRP_varsyt');
q_25 =  quantile(EPSC_single_cell_largeRRP_varsyt', 0.025);
q_975 = quantile(EPSC_single_cell_largeRRP_varsyt', 0.975);
xconf = [[1:length(avg)]./50, [length(avg):-1:1]./50];
yconf = [q_975, q_25(end:-1:1)];
figure()
p=fill(xconf,yconf, 'r','FaceColor', 'r', 'EdgeColor', 'none' ,'HandleVisibility','off' );
alpha(p, .3);
hold on
plot([1:length(avg)]./50, avg, 'r' ,'LineWidth', 2)

avg = mean(EPSC_single_cell_largeRRP');
q_25 = quantile(EPSC_single_cell_largeRRP', 0.025);
q_975 = quantile(EPSC_single_cell_largeRRP', 0.975);
xconf = [[1:300]./50, [300:-1:1]./50];
yconf = [q_25(1:300), q_975(300:-1:1)];
%figure()
p=fill(xconf,yconf, 'r','FaceColor', 'k', 'EdgeColor', 'none' ,'HandleVisibility','off' );
alpha(p, .3);
hold on
plot([1:length(avg)]./50, avg, 'k','LineWidth', 2 )
xlim([0 6])
ylim([-25 0])

legend('nsyt=var' , 'nsyt=15', 'box', 'off')
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2, 'HandleVisibility','off')
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2, 'HandleVisibility','off')
set(gca,'XColor', 'none','YColor','none')

%% Figure large RRP, variable RRP

avg = mean(EPSC_single_cell_largeRRP_varRRP');
q_25 =  quantile(EPSC_single_cell_largeRRP_varRRP', 0.025);
q_975 = quantile(EPSC_single_cell_largeRRP_varRRP', 0.975);
xconf = [[1:length(avg)]./50, [length(avg):-1:1]./50];
yconf = [q_975, q_25(end:-1:1)];
figure()
p=fill(xconf,yconf, 'r','FaceColor', 'b', 'EdgeColor', 'none' ,'HandleVisibility','off' );
alpha(p, .3);
hold on
plot([1:length(avg)]./50, avg, 'b', 'linewidth', 2 )

avg = mean(EPSC_single_cell_largeRRP');
q_25 = quantile(EPSC_single_cell_largeRRP', 0.025);
q_975 = quantile(EPSC_single_cell_largeRRP', 0.975);
xconf = [[1:300]./50, [300:-1:1]./50];
yconf = [q_25(1:300), q_975(300:-1:1)];
%figure()
p=fill(xconf,yconf, 'r','FaceColor', 'k', 'EdgeColor', 'none' ,'HandleVisibility','off' );
alpha(p, .3);
hold on
plot([1:length(avg)]./50, avg, 'k', 'linewidth', 2 )
xlim([0 6])

xlim([0 6])
ylim([-25 0])
legend('RRP=var' , 'RRP=4000', 'box', 'off')
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2, 'HandleVisibility','off' )
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2, 'HandleVisibility','off'  )
set(gca,'XColor', 'none','YColor','none')



%% Plot distributions

%RRP distribution
nves_mean = 4000;
nves_sd = 2000;
k_gamma = (nves_mean^2)/(nves_sd^2);
thet_gamma = (nves_sd^2)/nves_mean;
x= [0:10:15000];
y = gampdf(x,k_gamma,thet_gamma);
figure();
bar(x, y, 'b')
xlabel('Number of SVs')
ylabel('Occurance (%)')
set(gca,'TickDir','out');
set(gca, 'FontSize', 14)

%Distribution of syts
lambda = 15;
x=[1:40];
y = poisspdf(x,lambda);
figure();
bar(x, y, 'r')
xlabel('Number of syts')
ylabel('Occurance (%)')
set(gca,'TickDir','out');
set(gca, 'FontSize', 14)


%% plot variance analysis
Y(1) = sum(std(EPSC_single_cell_largeRRP(1:300,:)'));
Y(2) = sum(std(EPSC_single_cell_largeRRP_varsyt(1:300,:)'));
Y(3)= sum(std(EPSC_single_cell_largeRRP_varRRP(1:300,:)')); 

figure()
X = categorical({'model itself', 'syts', 'RRP'});
X= reordercats(X, {'model itself', 'syts', 'RRP'});
b=bar(X, Y);
b.FaceColor='flat';
b.CData(1,:) =[0.5, 0.5, 0.5];
b.CData(2,:) =[1, 0, 0];
b.CData(3,:) = [0,0,1];
b.CData(4,:) = [0.8, 0,0.8];
set(gca,'TickDir','out');
set(gca, 'FontSize', 12);
xlabel('Source of variance'); ylabel('Sum of sd in normalized traces');
box off


