function Plot_Fig5_figsup1B_PIP2_crosslinks_refit

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the average number of crosslinks and fusion rates
%%%%with 15 and 3 syts and with 3 syts after PIP2 upregulation 
%%%%(Figure 5 - figure supplement 1B)

t_step = 1e-6;
t_max = 0.008;
t_vec = 0:t_step:t_max;

[threeCross_states, fusion_rates] = deal(zeros(3,length(t_vec)));


legend_text = {'15 syts', '3 syts', '3 syts, PIP2 up'};

for l = 1:3

    Calcium = 50;

    if l <= 2
        resultsfilename = ['./Outputs/Figure_results/Figure6/Results_fitslot3_excludeoutl0_Lplus423_lambda2_varRRP1_varSyt0_varSlot0_smallRRP0_fig6_nsyts15.mat'];
    elseif l==3
        resultsfilename = ['./Outputs/Figure_results/Figure6/Results_fitslot3_excludeoutl0_Lplus423_lambda2_varRRP1_varSyt0_varSlot0_smallRRP0_fig6_nsyts33sytsPIPup.mat'];
    end
    
    load(resultsfilename, 'par')
    
    if l == 2
        par(8) = 3;
    end

    nves = par(11);
    nsyts = par(8);
    nslots = par(14);

    [SS_eq] = steady_state_newmethod(par, 1, 0.05);
    SS_eq(end+1) = 0;

    cum_SS = cumsum(SS_eq);

    QMatrix = MakeQMatrix(par, Calcium);


%     zero_cross_inds = (indCal(nsyts, nslots, 0, 0, 0)):(indCal(nsyts, nslots, 0, nsyts-0, 0));
%     one_cross_inds = (indCal(nsyts, nslots, 1, 0, 0)):(indCal(nsyts, nslots, 1, nsyts-1, 0));
%     two_cross_inds = (indCal(nsyts, nslots, 2, 0, 0)):(indCal(nsyts, nslots, 2, nsyts-2, 0));
    three_cross_inds = (indCal(nsyts, nslots, 3, 0, 0)):(indCal(nsyts, nslots, 3, nsyts-3, 0));


    dfused_over_time = dP_function(QMatrix, SS_eq, t_vec)*nves;

    [zeroCross_state, oneCross_state, twoCross_state, threeCross_state, totalCross_state] = deal(zeros(1,length(t_vec)));

    for k = 1:length(t_vec)
        t = t_vec(k);
        states = statefunc(SS_eq, QMatrix, t);
%         zeroCross_state(k) = sum(states(zero_cross_inds));
%         oneCross_state(k) = sum(states(one_cross_inds));
%         twoCross_state(k) = sum(states(two_cross_inds));
        threeCross_state(k) = sum(states(three_cross_inds));
%         totalCross_state(k) = sum(states(one_cross_inds)) + 2*sum(states(two_cross_inds)) + 3*sum(states(three_cross_inds));

    end

    threeCross_states(l,:) = threeCross_state;
    fusion_rates(l,:) = dfused_over_time;

end



figure
plot(t_vec*1e3, threeCross_states(1,:)*nves, 'b-', 'LineWidth', 2, 'DisplayName', ['3 crosslinks, ' legend_text{1}])
hold on

plot(t_vec*1e3, threeCross_states(2,:)*nves, 'r-', 'LineWidth', 1, 'DisplayName', ['3 crosslinks, ' legend_text{2}])
plot(t_vec*1e3, threeCross_states(3,:)*nves, 'g-', 'LineWidth', 2, 'DisplayName', ['3 crosslinks, ' legend_text{3}])
% plot(t_vec*1e3, totalCross_state*nves, 'LineWidth', 2, 'DisplayName', 'Total crosslinks')
ylabel('Number of SVs with 3 crosslinks')
set(gca, 'FontSize', 16, 'YTick', [0 500 1000 1500 2000])
ylim([0 2000])
xlim([0 8])
xlabel('Time [ms]')
yticks([0 500 1000 1500 2000])


figure
plot(t_vec*1e3, fusion_rates(1,:)*1e-3, 'b--', 'LineWidth', 2, 'DisplayName', ['Fusion rate, ' legend_text{1}])
hold on
plot(t_vec*1e3, fusion_rates(2,:)*1e-3, 'r--', 'LineWidth', 1, 'DisplayName', ['Fusion rate, ' legend_text{2}])
plot(t_vec*1e3, fusion_rates(3,:)*1e-3, 'g--', 'LineWidth', 2, 'DisplayName', ['Fusion rate, ' legend_text{3}])
ylabel('Release rate [SVs/ms]')
xlabel('Time [ms]')
title(['Number of crosslinks and fusion rate. [Ca^{2+}] = ' num2str(Calcium) '\mu M'])
% ylim([0 2500])
xlim([0 8])
ylim([0 2000])
yticks([0 500 1000 1500 2000])
legend show
lgd = legend;
lgd.FontSize = 16;
set(gca, 'FontSize', 16)

