%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Run Variability analysis - variable number of syts + variable pool size
%This function determines AP-evoked EPSCs with EPSCs with a variable number
%of syts and a variable RRP size
%Used for generating data plotted in Figure 5D and E
n_rep = 1000;
DN_IO= 0;


   %% settings 1 large, variable syt
   n_rep =1000;
 varSytIO = 1;
nVes = 100;
varRRP = 0;
par_int(8) =15; par_int(11) =15;
for n=1:40
[NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, varRRP, 0, varSytIO, DN_IO, n_rep);
 %NT_single_cell_largeRRP_varsyt{n} = NT_single; 
 %EPSC_single_cell_largeRRP_varsyt{n} = EPSC_single; 
 Fusion_times_cell_largeRRP_varsyt{n} = fusion_times; 
 %EPSC_res_largeRRP_varsyt{n} =  EPSC;
 disp(['Finished large RRP variable syt, n= ' num2str(n) ' time: ' datestr(now,'HH:MM:SS.FFF')])
 save('20210623_AP_evokedEPSCs_variability')
 end

%% settings 2 %large RRP fixed syt, fixed RRP
 varSytIO = 0;
nVes = 100;
varRRP = 0;
par_int(8) =15; par_int(11) =15;
for n=1:40
[NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, varRRP, 0, varSytIO, DN_IO, n_rep);
 %NT_single_cell_largeRRP{n} = NT_single; 
 %EPSC_single_cell_largeRRP{n} = EPSC_single; 
 Fusion_times_cell_largeRRP{n} = fusion_times; 
 %EPSC_res_largeRRP{n} =  EPSC;
 disp(['Finished large RRP variable syt, n= ' num2str(n) ' time: ' datestr(now,'HH:MM:SS.FFF')])
 save('20210623_AP_evokedEPSCs_variability')
end

%% settings 3 %large, variable RRP
 varSytIO = 0;
nVes = 100;
varRRP = 0;
par_int(8) =15; par_int(11) =15;
for n=1:45
[NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, varRRP, 0, varSytIO, DN_IO, n_rep);
 %NT_single_cell_largeRRP{n} = NT_single; 
 %EPSC_single_cell_largeRRP{n} = EPSC_single; 
 Fusion_times_cell_largeRRP_varRRP{n} = fusion_times; 
 %EPSC_res_largeRRP{n} =  EPSC;
 disp(['Finished large RRP variable syt, n= ' num2str(n) ' time: ' datestr(now,'HH:MM:SS.FFF')])
 save('20210628_AP_evokedEPSCs_variability')
end

%% Combine results simulations large RRP

Fusion_times_largeRRP =[];
Fusion_times_largeRRP_varsyt=[];

for n=1:40
    Fusion_times_largeRRP= [Fusion_times_largeRRP; Fusion_times_cell_largeRRP{n}];
    Fusion_times_largeRRP_varsyt= [Fusion_times_largeRRP_varsyt; Fusion_times_cell_largeRRP_varsyt{n}];
end

Fusion_times_largeRRP_varRRP_ordered= CollectData_varRRP(Fusion_times_cell_largeRRP_varRRP,n_rep);

sampling_rate = 50e3;end_time=ca_signal(end,1);time_sample=0:1/sampling_rate:end_time;

EPSC_single_cell_largeRRP_varsyt = convolvefusion(Fusion_times_largeRRP_varsyt, time_sample,n_rep);
EPSC_single_cell_largeRRP = convolvefusion(Fusion_times_largeRRP, time_sample,n_rep);
EPSC_single_cell_largeRRP_varRRP = convolvefusion(Fusion_times_largeRRP_varRRP_ordered, time_sample, n_rep);


%% Functions
function EPSC = convolvefusion(fusion_times, time_sample,n_rep)
fusion_times = sort(fusion_times);
for i=1:length(time_sample)
NT(i,:)=sum(fusion_times<time_sample(i)); %cumulative fusion
end
NT_average=diff(mean(NT,2));
NT_single = diff(NT,1);
s = load('mEPSC_new.mat');
mEPSC = s.mEPSC;
parfor nn=1:n_rep
EPSC(:, nn) = conv(NT_single(:,nn), mEPSC);
end

end

function y = CollectData_varRRP(x, n_rep)
nves_mean = 4000;
nves_sd = 2000;
k_gamma = (nves_mean^2)/(nves_sd^2);
thet_gamma = (nves_sd^2)/nves_mean;
RRP = round(gamrnd(k_gamma, thet_gamma, 1, n_rep));

y = NaN(15000,n_rep);
count =1;
x1 =[];
for n = 1:size(x,2)
x1 = [x1, x{n}];
end
x= x1;


for i = 1:length(RRP)
   nves = RRP(i);
   nves_ceil = ceil(nves/size(x,1));
   nves_floor = floor(nves/size(x,1));
   nves_mod = mod(nves,size(x,1));
    if count+nves_ceil>size(x,2)
        disp('ERROR not enough data')
    end
   r = randi([1 size(x,1)],1,nves_mod);
   if nves_floor>1
       m = x(:,count:(nves_floor+count-1));
   y(1:nves_floor*size(x,1),i) = m(:);
   end
   y(nves_floor*size(x,1)+1:nves,i) = x(r,(count+nves_floor+1));
   count = count +nves_ceil;
end
end