%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% This script extract/computes the costs associated with different number
%%% of syts before and after refitting PIP
%%% Used for plotting Figure5 Figure supplement 1

% Extract the costs, and fitted PIP2 value from the respective data file
for nsyt= [1:15]

load(['combi_fitresult_nsyts' num2str(nsyt) '_fitchoice12_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross3_parinitno1KDcato2ions2.mat'])

cost_total_PIP(nsyt) = cost_combi_value;
PIP(nsyt) = par_fitted;
end
%% Compute the costs associated with different levels of nsyt
load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross3_parinitno16KDcato2ions2')
for nsyts = [1:15]
par = model_parameters(par_fitted, fit_choice, nsyts, nves_mean, CaCoop, maxCross, nves_sd, F, KD); %Get parameters for the mo
 
    loglikeli_delay = delay_likeli(par, exclude_two, write_log);

    [least_squares_rates, loglikeli_rates] = cost_rates_PIPon(par, exclude_two, leaveout_low, write_log);
    
    cost_total(nsyts) = loglikeli_delay +2* least_squares_rates; 
end
%% plotting

colorvec = [0.5 0 0; 0.8 0 0; 1 0 0; 1 0.3 0.3; 1 0.5 0.5; 0.8 0.5 0.5;...
    0.5 0.5 0.5; 0.3 0.3 0.3; 0.1 0.1 0.1;0.1 0.5 0.1;0.1 0.6 0.1;0.1 0.8 0.1; ...
    0 0.8 0;0.3 0.8 0;0.5 0.8 0];
figure();
plot([1:15], cost_total_PIP, '-b', 'LineWidth',2)
hold on
scatter([1:15], cost_total_PIP, 75, 'b', 'filled')
plot([1:15], cost_total, '-k', 'LineWidth',2)
hold on
scatter([1:15], cost_total, 75, colorvec, 'filled')
xlabel('# of synaptotagmins'); ylabel('Cost')
set(gca, 'FontSize', 14)
box off
set(gca,'TickDir','out');

%%

figure();
plot([1:15], PIP_ratio, '-ob', 'MarkerFacecolor','b', 'LineWidth', 2)
xlabel('# of synaptotagmins'); ylabel('Fold [PI(4,5)P2]')
set(gca, 'FontSize', 14)
box off
set(gca,'TickDir','out');

%%