function call_fig5_sims()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%This script calls simulations of release latencies and peak release rates
%for figure 5 (different levels of syt expression)


n_rep = 1000;
varRRP = 1;
varSyt = 0;
varSlot = 0;
smallRRP_IO = 0;
lambda = 2;
Lplus = 423;
excludeOutl = 0;
fitslot = 3;
% nsyts = 15;
% fitchoice = 17;

allost_IO = 1;
simEPSCs = 0;

for nsyts = 1:15
        [delays, delay_medians, delay_2_5q, delay_97_5q, Calciums_delay, par] = simulate_delays(n_rep, varRRP, varSyt, varSlot, smallRRP_IO, fitslot, excludeOutl, Lplus, lambda, allost_IO, 0, 0, nsyts, fitslot, simEPSCs);
        [peak_rates, rates_est_mean, rates_est_q2_5, rates_est_q97_5, Calciums_rates, par] = simulate_peak_release_rate(n_rep, varRRP, varSyt, varSlot, smallRRP_IO, fitslot, excludeOutl, Lplus, lambda, allost_IO, 0, 0, nsyts, fitslot);

        foldername = './Outputs/Figure_results/Figure6/';
        filename = ['Results_fitslot' num2str(fitslot) '_excludeoutl' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_varRRP' num2str(varRRP) '_varSyt' num2str(varSyt) '_varSlot' num2str(varSlot) '_smallRRP' num2str(smallRRP_IO) '_fig6_nsyts' num2str(nsyts) '.mat'];

        save([foldername filename])
end