%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% This script simulates Paired Pulse responses with and without for variable PIP2
%Used for generating data plotted in figure 7

load('ParametersettingsAPevoekdvariablePIP2.mat')

%% RUN WT variable PIP2

par_WT_varPIP = par_int;
varPIPIO = [0.0003, 0.022, 34,3];
[NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal_varPIP(Ca_signal_pp_complete2, par_WT_varPIP, 4000, [4000, 2000], 0, 0, 0, 50, varPIPIO);
save('20220321_WT_pairedpulsestimulus_variablePIP.mat')
disp(['WT', datestr(now,'HH:MM:SS.FFF')])
figure()
plot([1:length(EPSC)]/50, EPSC);
xlabel('time (ms)'); ylabel('nA')
xlim([0,20])
title('WT - Variable PIP')

%% RUN WT fixed PIP2
[NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal_varPIP(Ca_signal_pp_complete2, par_WT_varPIP, 4000, RRP, 0, 0, 0, 50, 0);
save('20220214_WT_pairedpulsestimulus.mat')
disp(['WT', datestr(now,'HH:MM:SS.FFF')])
figure()
plot([1:length(EPSC)]/50, EPSC);
xlabel('time (ms)'); ylabel('nA')
xlim([0,20])
title('WT')

