function [SS_eq] = steady_state_newmethod(par, nVes, Ca)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%This Script calculates the steady state in the PIP2-synaptotagmin model 
%%%based from a set of parameters and a calcium concentration.

%Input
%par - all model parameters
%nVes - number of vesicles
%Ca - calcium concentration at which steady state needs to be determined


maxCross = par(14);
nSyts = par(8);

if maxCross > nSyts
    maxCross = nSyts;
end

% nStates = indCal(nSyts, maxCross, maxCross, nSyts-maxCross, 0);

[indices] = indCal_all(nSyts, maxCross);

nStates = indices(maxCross+1, nSyts-maxCross+1, 1);

SS = zeros(nStates, 1);

[QMatrix] = MakeQMatrix(par, Ca);

SS(1) = 1;

cur_ind = 0;
for k = 0:maxCross %Number of PipCa-together
    for m = 0:(nSyts-k) %Number of Ca
        for n = 0:(maxCross-k-max(m-(nSyts-maxCross),0)) %Number of PIP2
            cur_ind = cur_ind+1;
            if cur_ind ~= 1
                if n>0
                    rel_ind = cur_ind-1;
                elseif (n == 0) && (m > 0)
                    rel_ind = indices(k+1, m, n+1);
                elseif (n == 0) && (m == 0) && (k > 0)
                    rel_ind = indices(k, m+2, n+1);
                end
                    
                SS(cur_ind) =  SS(rel_ind) * (QMatrix(rel_ind, cur_ind)/QMatrix(cur_ind, rel_ind));
            end
        end
    end
end

SS_eq = (SS*(nVes/sum(SS)))';
