function call_lik_fit()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% This function is used to initiaze the fitting procedure. Values below can
% be adjusted to match required settings. Currently it is set to the
% settings used to fit the model with different fixed F-values


lambda =  2;
 rate_likeli = 0;
maxCross = [3];
nves_mean = [4000];
F=1e5;
nsyts =15;
for no =[1]

    x = log10(128.21)+45*4/49;
    y = x-4;
    F1 = logspace(y, x, 50);
    for F = F1
        KD =0;
        leaveout_low = 0;
        fit_choice =16;                             
        exclude_two = 0;
        CaCoop = 2;
        nves_sd = 2000;
        %Call fitting script
        fit_delay_likeli_combi(nsyts, fit_choice, exclude_two, leaveout_low, lambda, nves_mean, CaCoop, maxCross, nves_sd, rate_likeli, no, KD, F)
        disp(['Nsyts', num2str(nsyts), ' parno_', num2str(no), ' time: ' datestr(now,'HH:MM:SS.FFF')])
    end
end

