function fit_delay_likeli_combi(nsyts, fit_choice, exclude_two, leaveout_low, lambda, nves_mean, CaCoop, maxCross, nves_sd, rates_likeli, no, KD, F)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% This script fits the model with the specified input settings to
% experimental release latencies and peak releasing rates.

%INPUTS
%nsyts - number of syts evaluated in the model
%fit_choice - choice of fit option, par_fit needs to correspond to this
%choice (see modelparameters to get the different fit_choice options)
%exlude_two - whether or not to exclude the second data point in the
%release latency measurements. 
%leave-out low - whether or not to include all peak release rate points or
%leave the onces out that do not have a corresponding release latency
%measurement. 
%lambda - factor on costs of peak release rates when combinding with the log
%likelohood of delays 
%nves_mean - average number of vesicles
%CaCoop - Value of 1 indicates binding of a single ca to syt, 2 indicates
%cooperative binding of two calcium ions
%maxCross - number of slots
%nves_sd - standard deviation of RRP size distribution
%rates_likeli - 1 to compute costs based on likelihood of rates
% no - index value to keep track of how often this specific fit was
% performed
% F - F-value (increase in fusion probability upon crosslink formation)
% only need to give this specific value when wanting to fit with different
% Fixed F-values (Fit_choice - 16) otherwise this can be a random number
% KD- to evaluate the effect of different affinities. 2-value array with
% first value corresponding to whether KDca (1), KDpip (2) or c (allostericity -3)
% is affected and the second value the degree of effect.

%OUTPUT
%saved matlab file with the resulting fitted parameters and costs


%get initial set of parameters
if fit_choice == 1
    par_init = [192, 106, 27.5, 12.7463*7/nsyts]; %Initital parameters to fit: k_on,Ca; [PIP2]; f;
elseif fit_choice == 6
 par_init = [17 895 0.21 142 0.33]; %maxcross 3
elseif fit_choice == 7
    par_init = [192, 106, 27.5, 0.015, 12.7463*7/nsyts, 4e-1]; %Initital parameters to fit: k_on,Ca; [PIP2]; c; f; added delay
elseif fit_choice == 8
    par_init = [192, 106, 27.5, 12.7463*7/nsyts, 4e-1, nves_mean]; %Initital parameters to fit: k_on,Ca; [PIP2]; c; f; added delay
elseif fit_choice == 100
    par_init = [140, 2500, 25];
elseif fit_choice ==12
    par_init = 1;
elseif fit_choice ==13
    par_init = 20;
elseif fit_choice ==14
    par_init = [0.5,20];
    
elseif fit_choice == 15
   par_init = [192, 106, 1, 12.7463^(7/maxCross), 4e-1, 3e-4];
elseif fit_choice == 16
   % par_init = [193, 106, 1, 4e-1]; % fitting with f fixed    
  % par_init = [24 124 1.1 0.33];
 % par_init = [3.5e5	7.5e4	0.0012	0.4];
    par_init = [(9999)*rand(1) + 1,(9999)*rand(1) + 1, rand(1)*10, 0.4];
elseif fit_choice ==17
    %par_init = [18 791 0.22 153 0.33 3]; %maxcross 3
    par_init = [(1000)*rand(1) + 1,(1000)*rand(1) + 1, rand(1), (1000)*rand(1) + 1 , 0.4, rand(1)*10];
    %F=1;
end
    


%%%Generate filename for optimisation result file. 
%%%Written continuously for each step in the looped optimisation.
fullfile = ['./Outputs/Fitting/Likelihood_optim_result_nsyt' num2str(nsyts) '_fitchoice' num2str(fit_choice)];
% if fit_constraint
%     fullfile = [fullfile '_constraint' num2str(fit_constraint)];
% end
if exclude_two
    fullfile = [fullfile '_exclude' num2str(exclude_two)];
end
fullfile = [fullfile '_combi_leavelow' num2str(leaveout_low) '_lambda' num2str(lambda) '_nvesmean' num2str(nves_mean) '_nvesSD' num2str(nves_sd) '_likelirates' num2str(rates_likeli)];
fullfile = [fullfile '_maxcross', num2str(maxCross) 'F.txt'];
%%%%%%%%%%%%%%%%%%


% for k = 1:num_iter) %Looping the optimisation: Fitting par_init and k_on,PIP2

    optim_func = @(par_fit)cost_function_combi(par_fit, nsyts, fit_choice, exclude_two, leaveout_low, lambda, nves_mean, CaCoop, maxCross, nves_sd, rates_likeli, F, KD);
    options = optimset('Display', 'off', 'MaxIter', 5e3, 'MaxFunEvals', 5e3);
    %optionsGA = optimoptions('ga', 'Display', 'iter', 'Generations', 1000);

    tic
    [par_fitted, cost_combi_value] = fminsearch(optim_func, par_init, options);
    elaps = toc
    %tic
    %[par_fitted, cost_combi_value] = ga(optim_func, 5, [], [], [], [], [1e-10 1e-10 1e-10 1e-10 0.3] , [10000 10000 10000 10000 0.5], [], optionsGA);
    %[par_fitted, cost_combi_value] = fminsearch(optim_func, par_fitted, options);
    %elaps = toc
        
        
    write_log = 0;
   
    par = model_parameters(par_fitted, fit_choice, nsyts, nves_mean, CaCoop, maxCross, nves_sd, F, KD); %Get parameters for the model
    
    loglikeli_delay = delay_likeli(par, exclude_two, write_log);

    [least_squares_rates, loglikeli_rates] = cost_rates_PIPon(par, exclude_two, leaveout_low, write_log);

    if length(KD) ==1
        if fit_choice ==16
            save(['./Outputs/Fitting/combi_fitresult' '_nsyts' num2str(nsyts) '_fitchoice' num2str(fit_choice) '_exclude' num2str(exclude_two) '_leavelow' num2str(leaveout_low)  '_lambda' num2str(lambda) '_nvesmean' num2str(nves_mean) '_nvesSD' num2str(nves_sd)  '_likelirates' num2str(rates_likeli) '_maxcross' num2str(maxCross), '_parinitno', num2str(no), '_F' num2str(F) '.mat'])
        else
    save(['./Outputs/Fitting/combi_fitresult' '_nsyts' num2str(nsyts) '_fitchoice' num2str(fit_choice) '_exclude' num2str(exclude_two) '_leavelow' num2str(leaveout_low)  '_lambda' num2str(lambda) '_nvesmean' num2str(nves_mean) '_nvesSD' num2str(nves_sd)  '_likelirates' num2str(rates_likeli) '_maxcross' num2str(maxCross), '_parinitno', num2str(no), 'KDcato2ions2.mat'])
        end
    elseif KD(1) ==1
      save(['./Outputs/Fitting/combi_fitresult' '_nsyts' num2str(nsyts) '_fitchoice' num2str(fit_choice) '_exclude' num2str(exclude_two) '_leavelow' num2str(leaveout_low)  '_lambda' num2str(lambda) '_nvesmean' num2str(nves_mean) '_nvesSD' num2str(nves_sd)  '_likelirates' num2str(rates_likeli) '_maxcross' num2str(maxCross), '_parinitno', num2str(no), '_KDCA' num2str(KD(2)) 'l_423.mat'])
    elseif KD(1) ==2
      save(['./Outputs/Fitting/combi_fitresult' '_nsyts' num2str(nsyts) '_fitchoice' num2str(fit_choice) '_exclude' num2str(exclude_two) '_leavelow' num2str(leaveout_low)  '_lambda' num2str(lambda) '_nvesmean' num2str(nves_mean) '_nvesSD' num2str(nves_sd)  '_likelirates' num2str(rates_likeli) '_maxcross' num2str(maxCross), '_parinitno', num2str(no), '_KDPIP' num2str(KD(2)) 'l_423.mat'])
    elseif KD(1) ==3
      save(['./Outputs/Fitting/combi_fitresult' '_nsyts' num2str(nsyts) '_fitchoice' num2str(fit_choice) '_exclude' num2str(exclude_two) '_leavelow' num2str(leaveout_low)  '_lambda' num2str(lambda) '_nvesmean' num2str(nves_mean) '_nvesSD' num2str(nves_sd)  '_likelirates' num2str(rates_likeli) '_maxcross' num2str(maxCross), '_parinitno', num2str(no), '_c' num2str(KD(2)) 'l_423.mat'])
    end
    
   
    filecont1 = sprintf('Fitting PIP2-Syt model with likelihood and delays\n');

    filecont2 = sprintf(     ['***Optimized parameters***' '\n' ...
                              'Fit type: ' num2str(fit_choice) '\n' ...
                              'Fitted parameters: ' num2str(par_fitted) '\n' ...
                              'lambda: ' num2str(lambda) '\n' ...
                              'Run time: ' num2str(elaps) '\n' ... 
                              '***RESULTS***' '\n' ... 
                              'MINUS log-likeli (delays): ' num2str(loglikeli_delay) '\n' ... 
                              'Least squares: ' num2str(least_squares_rates) '\n' ... 
                             'MINUS log-likeli (rates): ' num2str(loglikeli_rates) '\n' ... 
                              'cost_combi:' num2str(cost_combi_value) '\n' ...
                              '\n' '------------------- \n'...
                              'Timepoint: ' datestr(now,'HH:MM:SS') '\n' ...
                              '\n' '------------------- \n' '\n' ...
                              ]);

    %%%Write log-file
    newParameterfile = fopen(fullfile,'a');
    fprintf(newParameterfile,'%s\n',filecont1);
    fprintf(newParameterfile,'%s\n',filecont2);
    fclose(newParameterfile);

    fclose('all');
    %%%%%%%%%%%%%%%
%     %for i = 1:2
%     %tic;
%     %[par_fitted, cost_combi_value] = fminsearch(optim_func, par_fitted, options);
%     elaps = toc
%         
%         
%     write_log = 0;
%     
%     par = model_parameters(par_fitted, fit_choice, nsyts, nves_mean, CaCoop, maxCross, nves_sd); %Get parameters for the model
%     
%     loglikeli_delay = delay_likeli(par, exclude_two, write_log);
% 
%     [least_squares_rates, loglikeli_rates] = cost_rates_PIPon(par, exclude_two, leaveout_low, write_log);
% 
%     save(['./Outputs/Fitting/combi_fitresult' '_nsyts' num2str(nsyts) '_fitchoice' num2str(fit_choice) '_exclude' num2str(exclude_two) '_leavelow' num2str(leaveout_low)  '_lambda' num2str(lambda) '_nvesmean' num2str(nves_mean) '_nvesSD' num2str(nves_sd)  '_likelirates' num2str(rates_likeli) 'maxcross' num2str(maxCross) '.mat'])
%     
%     filecont1 = sprintf('Fitting PIP2-Syt model with likelihood and delays\n');
% 
%     filecont2 = sprintf(     ['***Optimized parameters***' '\n' ...
%                               'Fit type: ' num2str(fit_choice) '\n' ...
%                               'Fitted parameters: ' num2str(par_fitted) '\n' ...
%                               'lambda: ' num2str(lambda) '\n' ...
%                               'Run time: ' num2str(elaps) '\n' ... 
%                               '***RESULTS***' '\n' ... 
%                               'MINUS log-likeli (delays): ' num2str(loglikeli_delay) '\n' ... 
%                               'Least squares: ' num2str(least_squares_rates) '\n' ... 
%                              'MINUS log-likeli (rates): ' num2str(loglikeli_rates) '\n' ... 
%                               'cost_combi:' num2str(cost_combi_value) '\n' ...
%                               '\n' '------------------- \n'...
%                               'Timepoint: ' datestr(now,'HH:MM:SS') '\n' ...
%                               '\n' '------------------- \n' '\n' ...
%                               ]);
% 
%     %%%Write log-file
%     newParameterfile = fopen(fullfile,'a');
%     fprintf(newParameterfile,'%s\n',filecont1);
%     fprintf(newParameterfile,'%s\n',filecont2);
%     fclose(newParameterfile);
% 
%     fclose('all');
%     %%%%%%%%%%%%%%%
%     end

end