function [] = calculate_generic_functions_addTime_varyparameter()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script adds a longer time span to functions already evaluated and
%%%%stored in cell variables with "generic" functions used in Figure 2 - figure 
%%%%supplement 3.


% fitslot = 4;

fitslot = 3;

lambda = 2;
fitchoice = 6;
Lplus = 423;
excludeOutl = 0;
t_add_val = 0.1;


Ca_inds_delay = [11];%[];%11:13;
Check_rates_IO = 0;

for k = 3%1:4
    for param_fact =  [1/5 1/3] %[1/5 1/3 1/2 1 2 3 5]

    if fitchoice == 17
        filename = ['./Outputs/Figure_results/Generic_functions/varyparams/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_lambda' num2str(lambda) '_varyparams' num2str(k) '_paramfact' num2str(param_fact) '.mat'];
        resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_leavelow0_lambda' num2str(lambda) '_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno1.mat'];
    elseif fitchoice == 6
        filename = ['./Outputs/Figure_results/Generic_functions/varyparams/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_varyparams' num2str(k) '_paramfact' num2str(param_fact) '.mat'];
        resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_leavelow0_lambda' num2str(lambda) '_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno16_KDcato2ions2.mat'];
        if fitslot == 1
            resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_leavelow0_lambda' num2str(lambda) '_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno51_KDcato2ions2.mat'];
        end
    end



% Calciums = Calciums;

load(filename)
Calciums = Calciums;

% Calciums = [0.01 0.1 0.5 1 1.5 2 5 10 20 30 40 50 60 70 80];
% Calciums = [0.01 0.1 0.2 0.3 0.4 0.5 1 1.5 2 3 4 5 6 7 8 9 10 20 30 40 50 60 70 80];
% 
% nsyts = 1:30;
% nslots = 1:6;



Ca_0_init = 0.05;


% load('exact_model_combifit15_nsyt15_leaveout1_lambda5_nves4000_CaCoop2_maxCross3_nvessd2000.mat', 'par')

% 
% if fitslot == 1
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross1_parinitno28.mat','par')
% elseif fitslot == 2
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross2_parinitno37.mat','par')
% elseif fitslot == 3
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross3_parinitno35.mat','par')
% elseif fitslot == 4
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross4_parinitno35.mat','par')
% end

par_loop = par;


nslot = fitslot;
nsyt = 15;
        

%         if ~isempty(test)
%             disp(['nsyt = ' num2str(nsyt) ', nslot = ' num2str(nslot)])
%             disp('Already done or invalid')
%         else
        disp(['Param no.: ' num2str(k)]) 
        disp(['Param factor: ' num2str(param_fact)])
        param_ind = param_inds(k);
            parfor m = Ca_inds_delay

                if nslot <= nsyt
                    par_here = par_loop;

                    Calcium = Calciums(m);
                    
                    if Calcium<Ca_0_init
                        Ca_0 = Calcium
                    else
                        Ca_0 = Ca_0_init
                    end
                    
                    disp(['Delays. Calcium = ' num2str(Calcium) ', nsyt = ' num2str(nsyt) ', nslot = ' num2str(nslot)])

                    par_here(param_ind) = par_loop(param_ind)*param_fact;
                    par_here(8) = nsyt;
                    par_here(14) = nslot;

                    t_vec_fus_old = tvec_fus_cells{m,nsyt,nslot};

                    t_max_old = t_vec_fus_old(end);
                    t_add = (t_max_old+0.00001):0.00001:(t_max_old+t_add_val);
        
                    fused_over_time = P_cells{m,nsyt,nslot};
%                     dfused_over_time = dP_cells{m,l,k};

                    [QMatrix] = MakeQMatrix(par_here, Calcium);
                    [SS_eq] = steady_state_newmethod(par_here, 1, Ca_0);
                    SS_eq(end+1) = 0;
                    [fused_over_time_add, below1_t] = P_function_limit(QMatrix, SS_eq, t_add);
%                     [dfused_over_time_add, ~] = dP_function_limit(QMatrix, SS_eq, t_add, below1_t);

%                     dP_cells{m,l,k} = [dfused_over_time; dfused_over_time_add];
                    P_cells{m,nsyt,nslot} = [fused_over_time; fused_over_time_add];
%                     SS_eq_cells{m,l,k} = SS_eq;
%                     QMatrix_cells{m,l,k} = QMatrix;
                    tvec_fus_cells{m,nsyt,nslot} = [t_vec_fus_old t_add];
    %                 save('./Outputs/Figure_results//generic_functions_bestfit.mat', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_cells', 'Calciums', 'nsyts', 'nslots', '-v7.3')
                end
            end
            
%         end
%         save(filename, 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells',  'Calciums', 'nsyts', 'nslots', '-v7.3')
        save(filename, 'fitslot', 'param_inds', 'param_factors', 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells', 'Calciums', '-v7.3')

        if Check_rates_IO
           for m = 1:length(Calciums)

                if nslot <= nsyt
                    par_here = par_loop;

                    Calcium = Calciums(m);
                    
                    if Calcium<Ca_0_init
                        Ca_0 = Calcium
                    else
                        Ca_0 = Ca_0_init
                    end
                    
                    disp(['Rates. Calcium = ' num2str(Calcium) ', nsyt = ' num2str(nsyt) ', nslot = ' num2str(nslot)])

                    par_here(param_ind) = par_loop(param_ind)*param_fact;
                    par_here(8) = nsyt;
                    par_here(14) = nslot;

                    t_vec_rate_old = tvec_rate_cells{m,nsyt,nslot};
                    
                    
                    
                    t_max_old_rate = t_vec_rate_old(end);
                    t_add = (t_max_old_rate+0.00001):0.00001:(t_max_old_rate+t_add_val);
        
                    dfused_over_time = dP_cells{m,nsyt,nslot};
                    
                    [~, max_ind] = max(dfused_over_time);
                    
                    if max_ind == length(dfused_over_time)
                        disp(['Calculating at ' num2str(Calcium)])
                        [QMatrix] = MakeQMatrix(par_here, Calcium);
                        [SS_eq] = steady_state_newmethod(par_here, 1, Ca_0);
                        SS_eq(end+1) = 0;
                        below1_t = NaN;
                        [dfused_over_time_add, ~] = dP_function_limit(QMatrix, SS_eq, t_add, below1_t);
    %                     [dfused_over_time_add, ~] = dP_function_limit(QMatrix, SS_eq, t_add, below1_t);

    %                     dP_cells{m,l,k} = [dfused_over_time; dfused_over_time_add];
                        dP_cells{m,nsyt,nslot} = [dfused_over_time; dfused_over_time_add];
    %                     SS_eq_cells{m,l,k} = SS_eq;
    %                     QMatrix_cells{m,l,k} = QMatrix;
                        tvec_rate_cells{m,nsyt,nslot} = [t_vec_rate_old t_add];
                    end
                end    
            end
            
%         end
%         save(filename, 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells',  'Calciums', 'nsyts', 'nslots', '-v7.3')
        save(filename, 'fitslot', 'param_inds', 'param_factors', 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells', 'Calciums', '-v7.3')
        end
        

% save(filename, 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells',  'Calciums', 'nsyts', 'nslots', '-v7.3')
    end
end

