%%plot parameter sensitivity
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the parameter sensitivity analysis
%%%%(Figure 2 - figure supplement 3)
% 
% load('exact_model_combifit15_nsyt15_leaveout1_lambda5_nves4000_CaCoop2_maxCross3_nvessd2000.mat', 'par')
% 
% t_max = 0.1;
% save_data = 1;
% nsyts = par(8);
% nVes = par(11);
load('ExpData_PIP2.mat')
Calcium = ExpRateCa;


% par_init = [14412.5206 0.88018 3.4117 47.5006];

% par = [par_init(1), 221, par_init(2:3),0.015, 2.36e-4, par_init(4) nsyts];
    color_vec = {'b', 'r', 'y', 'm', 'g', 'k', 'c', [0.5 0.5 0.5], [0.6350, 0.0780, 0.1840]};

    factors = [1/5 1/3 1/2 1 2 3 5];
    fac_names = {'div5', 'div3', 'div2', '1', 'mult2', 'mult3', 'mult5'};
    fac_leg = {'Factor 1/5', 'Factor 1/3', 'Factor 1/2', 'Factor 1', 'Factor 2', 'Factor 3', 'Factor 5'};

    inds = 1;

for ind = inds%[1 3 4 7]
    
    loglog(ExpRateCa, ExpRate, 'ks', 'DisplayName', 'Experiment')
    hold on

    rates_est_means = zeros(length(factors), length(Calcium));
    
    for k = 1:length(factors)
        
        factor = factors(k);
        
        
        fac_name = fac_names{k};
        par_num = ind;
        
        if factor ~= 1
            savename = ['./Outputs/Figure_results/Figure3/Fig3_figsup3_Param_expl/exact_model_combifit15_nsyt15_leaveout1_lambda5_nves4000_CaCoop2_maxcross3_parnum' num2str(par_num) '_parfac' fac_name '.mat'];
        else
            savename = 'exact_model_combifit15_nsyt15_leaveout1_lambda5_nves4000_CaCoop2_maxcross3.mat';
        end
        
        load(savename);
        
        rates_est_mean = mean(rates_est_crude,2);

        loglog(Calcium, rates_est_mean*1e-3, '-', 'LineWidth', 2, 'Color', color_vec{k}, 'DisplayName', fac_leg{k}) %['Cost type: ' num2str(cost_type)])

        rates_est_means(k,:) = rates_est_mean*1e-3;
    end
    legend show
    legend('Location', 'NorthWest')
    ylabel('Max fusion rate [ves/ms]')
    xlabel('Calcium conc. (uncage) [\mu M]')
        set(gca, 'TickDir', 'out')
    hold off
end
        



delay_ind = [36:37 39:85];

for ind = inds%[1 3 4 7]
    
loglog(ExpDelayCa, ExpDelay*1e3, 'ks')
    hold on

    
     release_latencies_medians = zeros(length(factors), length(delay_ind));

    for k = 1:length(factors)
        
        factor = factors(k);
        
        
        fac_name = fac_names{k};
        par_num = ind;
        
        if factor ~= 1
            savename = ['./Outputs/Figure_results/Figure3/Fig3_figsup3_Param_expl/exact_model_combifit15_nsyt15_leaveout1_lambda5_nves4000_CaCoop2_maxcross3_parnum' num2str(par_num) '_parfac' fac_name '.mat'];
        else
            savename = 'exact_model_combifit15_nsyt15_leaveout1_lambda5_nves4000_CaCoop2_maxcross3.mat';
        end
        load(savename);

        loglog(Calcium(delay_ind), (delay_medians_stoch+par(12))*1e3, '-', 'LineWidth', 2, 'Color', color_vec{k}, 'DisplayName', fac_leg{k}) %['Cost type: ' num2str(cost_type)])

        release_latencies_medians(k,:) = (delay_medians_stoch+par(12))*1e3;
    end
    legend show
    ylabel('Delay [ms]')
    xlabel('Calcium conc. (uncage) [\mu M]')
    set(gca, 'TickDir', 'out')
    ylim([0.3 200])
end