function Fig4_sim_individual_traces(Allost_IO)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script simulates the individual SV traces in figure 4D,E.

%INPUTS:
%Allost_IO - whether or not to use the best fit with or without 
% allostericity (0 or 1) 

fignum = 4;
% Allost_IO = 1;


Calcium = 50;
fitslots = 3;



fitslot = fitslots
% fitslot = 3;


if (fignum == 4) && (fitslot~=3)
warning('Simulating path to fusion with nslots~= 3')
return
end


if fignum == 4
n_runs = 4;
t_lim = 0.004;
elseif fignum == 3
n_runs = 1000;
t_lim = 1e4;
end





if fitslot == 1
    parinitno = 51;
else
    parinitno = 16;
end

resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno' num2str(parinitno) '_KDcato2ions2.mat'];

load(resultsfilename, 'par');


if ~Allost_IO
    par(5) = 1;
end


nsyts = par(8);
nslots = par(14);

[SS_eq] = steady_state_newmethod(par, 1, 0.05);

cum_SS = cumsum(SS_eq);

QMatrix = MakeQMatrix(par, Calcium);
fus_state = length(QMatrix(1,:));


states_all = NaN(n_runs,1e4);
tvec_all = NaN(n_runs,1e4);

for k = 1:n_runs

    disp(['Fitslot = ' num2str(fitslot) ', Allost_IO = ' num2str(Allost_IO) ', SV number: ' num2str(k)])
    states = NaN(1,1e4);
    tvec = NaN(1,1e4);

    SS_p = rand(1,1);

    init_state = find(SS_p<=cum_SS, 1, 'first');
    states(1) = init_state;
    tvec(1) = 0;
    nofus = 1;
    cur_ind = 1;
    while nofus && tvec(cur_ind)<t_lim
        state_cur = states(cur_ind); 
        ps = rand(1,2);
        a_vec = QMatrix(state_cur, :);
        a_vec(state_cur) = 0;
        a_0 = sum(a_vec);

        tau = (1/a_0)*log(1/ps(1));
        a_cum = cumsum(a_vec)/a_0;
        react = find(ps(2)<=a_cum, 1, 'first');

        tvec(cur_ind+1) = tvec(cur_ind)+tau;
        states(cur_ind+1) = react;
        cur_ind = cur_ind + 1;

        if react == fus_state
            nofus = 0;
        end

    end 

    tvec_all(k,1:length(tvec)) = tvec;
    states_all(k,1:length(tvec)) = states;
end


zeroCross_inds = indCal(nsyts, nslots, 0, 0, 0):indCal(nsyts, nslots, 0, nsyts, 0);
oneCross_inds = indCal(nsyts, nslots, 1, 0, 0):indCal(nsyts, nslots, 1, nsyts-1, 0);
twoCross_inds = indCal(nsyts, nslots, 2, 0, 0):indCal(nsyts, nslots, 2, nsyts-2, 0);
threeCross_inds = indCal(nsyts, nslots, 3, 0, 0):indCal(nsyts, nslots, 3, nsyts-3, 0);

noCross_over_time = repmat(NaN(size(states_all)),1,2);
tvec_plot = NaN(size(noCross_over_time));


for k = 1:n_runs
    for l = 1:length(states_all(k,~isnan(states_all(k,:))))
        disp(['k=' num2str(k) ', l=' num2str(l)])
        noCross_over_time(k,(2*l-1)) = sum(zeroCross_inds==states_all(k,l))*0 + sum(oneCross_inds==states_all(k,l))*1 + sum(twoCross_inds==states_all(k,l))*2 + sum(threeCross_inds==states_all(k,l))*3 + (fus_state==states_all(k,l))*1000;
        noCross_over_time(k,(2*l)) = sum(zeroCross_inds==states_all(k,l))*0 + sum(oneCross_inds==states_all(k,l))*1 + sum(twoCross_inds==states_all(k,l))*2 + sum(threeCross_inds==states_all(k,l))*3 + (fus_state==states_all(k,l))*1000;
        tvec_plot(k,(2*l-1):2*l) = tvec_all(k,l);
    end



end


% save(['./Outputs/Figure_results/Figure4/individualruns_Allost' num2str(Allost_IO) '.mat'])



