function Plot_Fig4_EPSc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the average number of crosslinks and fusion rates
%%%%with or without allostericity (set by Allost_IO).

Allost_IO = 0;

Calcium = 50;

resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross3_parinitno16_KDcato2ions2.mat'];

load(resultsfilename, 'par')


if ~Allost_IO
    par(5) = 1
end

nves = par(11);
nsyts = par(8);
nslots = par(14);

[SS_eq] = steady_state_newmethod(par, 1, 0.05);
SS_eq(end+1) = 0;

cum_SS = cumsum(SS_eq);

QMatrix = MakeQMatrix(par, Calcium);

t_step = 1e-6;
t_max = 0.004;





zero_cross_inds = (indCal(nsyts, nslots, 0, 0, 0)):(indCal(nsyts, nslots, 0, nsyts-0, 0));
one_cross_inds = (indCal(nsyts, nslots, 1, 0, 0)):(indCal(nsyts, nslots, 1, nsyts-1, 0));
two_cross_inds = (indCal(nsyts, nslots, 2, 0, 0)):(indCal(nsyts, nslots, 2, nsyts-2, 0));
three_cross_inds = (indCal(nsyts, nslots, 3, 0, 0)):(indCal(nsyts, nslots, 3, nsyts-3, 0));


t_vec = 0:t_step:t_max;
dfused_over_time = dP_function(QMatrix, SS_eq, t_vec)*nves;



[zeroCross_state, oneCross_state, twoCross_state, threeCross_state, totalCross_state] = deal(zeros(1,length(t_vec)));

for k = 1:length(t_vec)
    t = t_vec(k);
    states = statefunc(SS_eq, QMatrix, t);
    zeroCross_state(k) = sum(states(zero_cross_inds));
    oneCross_state(k) = sum(states(one_cross_inds));
    twoCross_state(k) = sum(states(two_cross_inds));
    threeCross_state(k) = sum(states(three_cross_inds));
    totalCross_state(k) = sum(states(one_cross_inds)) + 2*sum(states(two_cross_inds)) + 3*sum(states(three_cross_inds));

end


figure
plot(t_vec*1e3, oneCross_state*nves, 'LineWidth', 2, 'DisplayName', 'Ves. with 1 crosslink')
hold on
plot(t_vec*1e3, twoCross_state*nves, 'LineWidth', 2, 'DisplayName', 'Ves. with 2 crosslinks formed')
plot(t_vec*1e3, threeCross_state*nves, 'LineWidth', 2, 'DisplayName', 'Ves. with 3 crosslinks formed')
% plot(t_vec*1e3, totalCross_state*nves, 'LineWidth', 2, 'DisplayName', 'Total crosslinks')
ylabel('Number of vesicles')
set(gca, 'FontSize', 16, 'YTick', [0 500 1000 1500 2000])
ylim([0 500])
yyaxis right
plot(t_vec*1e3, dfused_over_time*1e-3, 'LineWidth', 4, 'DisplayName', 'Fusion rate')
ylabel('Release rate [SVs/ms]')
xlabel('Time [ms]')
title(['Number of crosslinks and fusion rate. [Ca^{2+}] = ' num2str(Calcium) '\mu M'])
ylim([0 2500])
xlim([0 4])
legend show
lgd = legend;
lgd.FontSize = 16;
set(gca, 'FontSize', 16)

