%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%% This script computes AP-evoked responses for different levels of WT and
%%% mutant proteins
%%% Used for generating AP-evoked data in figure 4 and 5

% Load parameter settings
load('ParametersettingsApevoked.mat')

% standard settings
nVes = 4000;
n_rep = 200;

%% Run wt references

%create cell arrays for all WT syts 
NT_single_cell_nsyt = cell(1,15); 
EPSC_single_cell_nsyt = cell(1,15); 
Fusion_times_cell_nsyt = cell(1,15); 
%EPSC_res_nsyt = NaN(15, 5300);

NT_single_cell_nsyt_over = cell(1,5); 
EPSC_single_cell_nsyt_over = cell(1,5); 
Fusion_times_cell_nsyt_over = cell(1,5); 
%EPSC_res_nsyt_over = NaN(5, 5300);

%run model with 1-15 WT syts
for i = [1:15]
par_int(8) = i;
par_int(11) = i;
[NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, RRP, 0, 0, 0, n_rep);
NT_single_cell_nsyt{i} = NT_single; 
EPSC_single_cell_nsyt{i} = EPSC_single; 
Fusion_times_cell_nsyt{i} = fusion_times; 
EPSC_res_nsyt(i, :) =  EPSC;
disp(['Finished over expression of WT ', num2str(i), ' time: ' datestr(now,'HH:MM:SS.FFF')])
save('20210512_AP_evokedEPSCs_differentlevelsnsyt')
end

%run model with 15 + 8 WT syts
j = 0;
for i = [1:4, 8]
par_int(8) = 15+i;
par_int(11) = 15+i;
j = j+1;
[NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, RRP, 0, 0, 0, n_rep);
NT_single_cell_nsyt_over{j} = NT_single; 
EPSC_single_cell_nsyt_over{j} = EPSC_single; 
Fusion_times_cell_nsyt_over{j} = fusion_times; 
EPSC_res_nsyt_over(j, :) =  EPSC;
disp(['Finished over expression of WT ', num2str(15+i), ' time: ' datestr(now,'HH:MM:SS.FFF')])
save('20210512_AP_evokedEPSCs_differentlevelsnsyt')
end

%Run with upregulated PIP2
for i = [1:15]
    par_int(4) = PIP(i);
par_int(8) = i;
par_int(11) = i;
[NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, RRP, 0, 0, 0, n_rep);
NT_single_cell_nsyt_pipup{i} = NT_single; 
EPSC_single_cell_nsyt_pipup{i} = EPSC_single; 
Fusion_times_cell_nsyt_pipup{i} = fusion_times; 
EPSC_res_nsyt_pipup(i, :) =  EPSC;
disp(['Finished over expression of WT ', num2str(i), ' time: ' datestr(now,'HH:MM:SS.FFF')])
save('20210610_AP_evokedEPSCs_differentlevelsnsyt')
end
par_int(4) = PIP(15);


%% Run Ca-bindingmutant mutant

% Mutant settings
DN_IO = [1, 10, 1, 0.00022]; %fold change kdpip, fold change kdca, fold change konca, A

%homozygous expression
NT_single_cell_coffhomo = cell(1,15); 
EPSC_single_cell_coffhomo = cell(1,15); 
Fusion_times_cell_coffhomo = cell(1,15); 
%EPSC_res_coffhomo = NaN(15, 5300);
for i=[1:15]
    par_int(8) = i;
    par_int(11) = 0;
    [NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, RRP, 0, 0, DN_IO, n_rep);
    NT_single_cell_coffhomo{i} = NT_single; 
    EPSC_single_cell_coffhomo{i} = EPSC_single; 
    Fusion_times_cell_coffhomo{i} = fusion_times; 
    EPSC_res_coffhomo(i, :) =  EPSC;
    disp(['Finished homozygous expression of c-off mutants ', num2str(i), ' time: ' datestr(now,'HH:MM:SS.FFF')])
    save('20210628_AP_evokedEPSCs_differentlevelsofMutant_KDCa')
end

%heterozygous expression
NT_single_cell_coffhet = cell(1,15); 
EPSC_single_cell_coffhet = cell(1,15); 
Fusion_times_cell_coffhet = cell(1,15); 
%EPSC_res_coffhet = NaN(15, 5300);
for i=[1:14]
    par_int(8) = 15;
    par_int(11) = 15-i;
    [NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, RRP, 0, 0, DN_IO, n_rep);
    NT_single_cell_coffhet{i} = NT_single; 
    EPSC_single_cell_coffhet{i} = EPSC_single; 
    Fusion_times_cell_coffhet{i} = fusion_times; 
    EPSC_res_coffhet(i, :) =  EPSC;
    disp(['Finished heterozygous expression of c-off mutants ', num2str(i), ' time: ' datestr(now,'HH:MM:SS.FFF')])
     save('20210608_AP_evokedEPSCs_differentlevelsofMutant_KDCa')
end

%overexpression
NT_single_cell_coffover = cell(1,5); 
EPSC_single_cell_coffover = cell(1,5); 
Fusion_times_cell_coffover = cell(1,5); 
%EPSC_res_coffover = NaN(5, 5300);
i = 0;
for n=[1:4, 8]
    i = i +1;
    par_int(8) = 15+n;
    par_int(11) = 15;
    [NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, RRP, 0, 0, DN_IO, n_rep);
    NT_single_cell_coffover{i} = NT_single; 
    EPSC_single_cell_coffover{i} = EPSC_single; 
    Fusion_times_cell_coffover{i} = fusion_times; 
    EPSC_res_coffover(i, :) =  EPSC;
    disp(['Finished overexpression expression of c-off mutants ', num2str(n), ' time: ' datestr(now,'HH:MM:SS.FFF')])
    save('20210608_AP_evokedEPSCs_differentlevelsofMutant_KDCa')
end
% 
%% Run No Ca a-on mutant
DN_IO = [2.2e-4, 1, 0, 1]; %fold change kdpip, fold change kdca, foldchange konca, A

%homozygous expression
NT_single_cell_conhomo = cell(1,15); 
EPSC_single_cell_conhomo = cell(1,15); 
Fusion_times_cell_conhomo = cell(1,15); 
EPSC_res_conhomo = NaN(15, 5300);
for i=[1:15]
    par_int(8) = i;
    par_int(11) = 0;
    [NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, RRP, 0, 0, DN_IO, n_rep);
    NT_single_cell_conhomo{i} = NT_single; 
    EPSC_single_cell_conhomo{i} = EPSC_single; 
    Fusion_times_cell_conhomo{i} = fusion_times; 
    EPSC_res_conhomo(i, :) =  EPSC;
    disp(['Finished homozygous expression of c-on mutants ', num2str(i), ' time: ' datestr(now,'HH:MM:SS.FFF')])
    save('20210628_AP_evokedEPSCs_differentlevelsofMutant_aon')
end

%heterozygous expression
NT_single_cell_conhet = cell(1,15); 
EPSC_single_cell_conhet = cell(1,15); 
Fusion_times_cell_conhet = cell(1,15); 
EPSC_res_conhet = NaN(15, 5300);
for i=[1:14]
    par_int(8) = 15;
    par_int(11) = 15-i;
    [NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, RRP, 0, 0, DN_IO, n_rep);
    NT_single_cell_conhet{i} = NT_single; 
    EPSC_single_cell_conhet{i} = EPSC_single; 
    Fusion_times_cell_conhet{i} = fusion_times; 
    EPSC_res_conhet(i, :) =  EPSC;
    disp(['Finished heterozygous expression of c-on mutants ', num2str(i), ' time: ' datestr(now,'HH:MM:SS.FFF')])
    save('20210608_AP_evokedEPSCs_differentlevelsofMutant_aon')
end

%overexpression
NT_single_cell_conover = cell(1,5); 
EPSC_single_cell_conover = cell(1,5); 
Fusion_times_cell_conover = cell(1,5); 
EPSC_res_conover = NaN(5, 5300);
i = 0;
for n=[1:4,8]
    i = i+1;
    par_int(8) = 15+n;
    par_int(11) = 15;
    [NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, RRP, 0, 0, DN_IO, n_rep);
    NT_single_cell_conover{i} = NT_single; 
    EPSC_single_cell_conover{i} = EPSC_single; 
    Fusion_times_cell_conover{i} = fusion_times; 
    EPSC_res_conover(i, :) =  EPSC;
    disp(['Finished overexpression expression of c-on mutants ', num2str(n), ' time: ' datestr(now,'HH:MM:SS.FFF')])
    save('20210608_AP_evokedEPSCs_differentlevelsofMutant_aon')
end


%% Run rescue (Figure 5 Figure supplement 2)

%Generate rescue calcium signal
sd = 1.8e-4;
x = ca_signal(:,1);
y = normpdf(x,4.04e-4,sd);
y = y./max(y).*55.782+0.05;
ca_signalAP4(:,1) = ca_signal(:,1);
ca_signalAP4(1:101, 2) = ca_signal(1:101,2);
ca_signalAP4(102:1501,2) = y(102:1501);
% 
% Ca-binding mutant mutant
DN_IO = [1, 10, 1, 0.00022];
%heterozygous expression   
NT_single_cell_coffhomo_rescue = cell(1,15); 
EPSC_single_cell_coffhomo_rescue = cell(1,15); 
Fusion_times_cell_coffhomo_rescue = cell(1,15); 
%EPSC_res_coffhet = NaN(15, 5300);
for i=[15]
    par_int(8) = 15;
    par_int(11) = 15-i;
    [NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signalAP4, par_int, nVes, RRP, 0, 0, DN_IO, n_rep);
    NT_single_cell_coffhomo_rescue{i} = NT_single; 
    EPSC_single_cell_coffhomo_rescue{i} = EPSC_single; 
    Fusion_times_cell_coffhomo_rescue{i} = fusion_times; 
    EPSC_res_coffhomo_rescue(i, :) =  EPSC;
    disp(['Finished heterozygous expression of c-off mutants ', num2str(i), ' time: ' datestr(now,'HH:MM:SS.FFF')])
     save('20210626_AP_evokedEPSCs_differentlevelsofMutant_KDCa_rescue')
end

%No Ca A-on mutant
DN_IO = [0.00022, 1, 0, 1];
%heterozygous expression
NT_single_cell_conhomo_rescue = cell(1,15); 
EPSC_single_cell_conhomo_rescue = cell(1,15); 
Fusion_times_cell_conhomp_rescue = cell(1,15); 
%EPSC_res_coffhet = NaN(15, 5300);
for i=[15]
    par_int(8) = 15;
    par_int(11) = 15-i;
    [NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signalAP4, par_int, nVes, RRP, 0, 0, DN_IO, n_rep);
    NT_single_cell_conhomo_rescue{i} = NT_single; 
    EPSC_single_cell_conhomo_rescue{i} = EPSC_single; 
    Fusion_times_cell_conhomo_rescue{i} = fusion_times; 
    EPSC_res_conhomo_rescue(i, :) =  EPSC;
    disp(['Finished heterozygous expression of c-on mutants ', num2str(i), ' time: ' datestr(now,'HH:MM:SS.FFF')])
     save('20210626_AP_evokedEPSCs_differentlevelsofMutant_aon_rescue')
end

 
 %% Run No Ca binding A-off mutant - Figure 5 figure supplement 1
DN_IO = [1, 1, 0, 1]; %fold change kdpip,fold change kdca, fold change konca, A

%homozygous expression
NT_single_cell_coff2homo = cell(1,15); 
EPSC_single_cell_coff2homo = cell(1,15); 
Fusion_times_cell_coff2homo = cell(1,15); 
%EPSC_res_c1homo = NaN(15, 5300);
for i=[15]
    par_int(8) = i;
    par_int(11) = 0;
    [NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, RRP, 0, 0, DN_IO, n_rep);
    NT_single_cell_coff2homo{i} = NT_single; 
    EPSC_single_cell_coff2homo{i} = EPSC_single; 
    Fusion_times_cell_coff2homo{i} = fusion_times; 
    EPSC_res_coff2homo(i, :) =  EPSC;
    disp(['Finished homozygous expression of c-off2 mutants ', num2str(i), ' time: ' datestr(now,'HH:MM:SS.FFF')])
    save('20210524_AP_evokedEPSCs_differentlevelsofMutant_aoff2')
end

%heterozygous expression
NT_single_cell_coff2het = cell(1,15); 
EPSC_single_cell_coff2het = cell(1,15); 
Fusion_times_cell_coff2het = cell(1,15); 
%EPSC_res_c1het = NaN(15, 5300);
for i=[7]
    par_int(8) = 15;
    par_int(11) = 15-i;
    [NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, RRP, 0, 0, DN_IO, n_rep);
    NT_single_cell_coff2het{i} = NT_single; 
    EPSC_single_cell_coff2het{i} = EPSC_single; 
    Fusion_times_cell_coff2het{i} = fusion_times; 
    EPSC_res_coff2het(i, :) =  EPSC;
    disp(['Finished heterozygous expression of c-1 mutants ', num2str(i), ' time: ' datestr(now,'HH:MM:SS.FFF')])
    save('20210524_AP_evokedEPSCs_differentlevelsofMutant_aoff2')
end

%overexpression
NT_single_cell_coff2over = cell(1,5); 
EPSC_single_cell_coff2over = cell(1,5); 
Fusion_times_cell_coff2over = cell(1,5); 
%EPSC_res_c1over = NaN(5, 5300);
i = 4;
for n=[8]
    i = i +1;
    par_int(8) = 15+n;
    par_int(11) = 15;
    [NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal(ca_signal, par_int, nVes, RRP, 0, 0, DN_IO, n_rep);
    NT_single_cell_coff2over{i} = NT_single; 
    EPSC_single_cell_coff2over{i} = EPSC_single; 
    Fusion_times_cell_coff2over{i} = fusion_times; 
    EPSC_res_coff2over(i, :) =  EPSC;
    disp(['Finished overexpression expression of c-1 mutants ', num2str(n), ' time: ' datestr(now,'HH:MM:SS.FFF')])
    save('20210524_AP_evokedEPSCs_differentlevelsofMutant_aoff2')
end



