%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the QQ-plots in Figure 1 - figure supplement 2


load('./Outputs/Figure_results/Figure2figsup1/20210603_GillespieFirstFiveFusionevents.mat', 'fusion_times_cell', 'Calcium', 'par_int')
load('./Outputs/Figure_results/Fig5_variance/Results_fitslot3_excludeoutl0_Lplus423_lambda2_varRRP0_varSyt0_varSlot0_smallRRP0.mat', 'Calciums_rates', 'par', 'delays', 'firstfus', 'secondfus', 'thirdfus', 'fourthfus')


Ca = 50;

gil_ind = find(Calcium == Ca);
ana_ind = find(Calciums_rates == Ca);


fusion_times_gil = fusion_times_cell{gil_ind};
delays_gil = fusion_times_gil(5,:);
firstfus_gil = fusion_times_gil(1,:);
secondfus_gil = fusion_times_gil(2,:);
thirdfus_gil = fusion_times_gil(3,:);
fourthfus_gil = fusion_times_gil(4,:);

delays_ana = delays(ana_ind,:);
firstfus_ana = firstfus(ana_ind,:);
secondfus_ana = secondfus(ana_ind,:);
thirdfus_ana = thirdfus(ana_ind,:);
fourthfus_ana = fourthfus(ana_ind,:);

lowlim_del = min(min(delays_ana), min(delays_gil));
uplim_del = max(max(delays_ana), max(delays_gil));

lowlim_first = min(min(firstfus_ana), min(firstfus_gil));
uplim_first = max(max(firstfus_ana), max(firstfus_gil));

lowlim_second = min(min(secondfus_ana), min(secondfus_gil));
uplim_second = max(max(secondfus_ana), max(secondfus_gil));

lowlim_third = min(min(thirdfus_ana), min(thirdfus_gil));
uplim_third = max(max(thirdfus_ana), max(thirdfus_gil));

lowlim_fourth = min(min(fourthfus_ana), min(fourthfus_gil));
uplim_fourth = max(max(fourthfus_ana), max(fourthfus_gil));

figure
plot(sort(delays_gil)*1e3, sort(delays_ana)*1e3, 'rs', 'MarkerFaceColor', 'r')
hold on
plot([lowlim_del uplim_del]*1e3, [lowlim_del uplim_del]*1e3, 'k-', 'LineWidth', 2)

title(['Release latencies, [Ca2+] = ' num2str(Ca)])
saveas(gcf, ['./Figures/Fig2sup1_QQ_fifth_Ca' num2str(Ca) '.eps'], 'epsc')

hold off


figure
plot(sort(firstfus_gil)*1e3, sort(firstfus_ana)*1e3, 'rs', 'MarkerFaceColor', 'r')
hold on
plot([lowlim_first uplim_first]*1e3, [lowlim_first uplim_first]*1e3, 'k-', 'LineWidth', 2)

title(['First fusion times, [Ca2+] = ' num2str(Ca)])
saveas(gcf, ['./Figures/Fig2sup1_QQ_first_Ca' num2str(Ca) '.eps'], 'epsc')

hold off

figure
plot(sort(secondfus_gil)*1e3, sort(secondfus_ana)*1e3, 'rs', 'MarkerFaceColor', 'r')
hold on
plot([lowlim_second uplim_second]*1e3, [lowlim_second uplim_second]*1e3, 'k-', 'LineWidth', 2)

title(['Second fusion times, [Ca2+] = ' num2str(Ca)])
saveas(gcf, ['./Figures/Fig2sup1_QQ_second_Ca' num2str(Ca) '.eps'], 'epsc')

hold off

figure
plot(sort(thirdfus_gil)*1e3, sort(thirdfus_ana)*1e3, 'rs', 'MarkerFaceColor', 'r')
hold on
plot([lowlim_third uplim_third]*1e3, [lowlim_third uplim_third]*1e3, 'k-', 'LineWidth', 2)

title(['Third fusion times, [Ca2+] = ' num2str(Ca)])
saveas(gcf, ['./Figures/Fig2sup1_QQ_third_Ca' num2str(Ca) '.eps'], 'epsc')

hold off

figure
plot(sort(fourthfus_gil)*1e3, sort(fourthfus_ana)*1e3, 'rs', 'MarkerFaceColor', 'r')
hold on
plot([lowlim_fourth uplim_fourth]*1e3, [lowlim_fourth uplim_fourth]*1e3, 'k-', 'LineWidth', 2)

title(['Fourth fusion times, [Ca2+] = ' num2str(Ca)])
saveas(gcf, ['./Figures/Fig2sup1_QQ_fourth_Ca' num2str(Ca) '.eps'], 'epsc')

hold off