function [dfused_over_time, above0_t] = dP_function_limit(QMatrix, SS_eq, t_vec, t_lim)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%This script computes the derivative of the release probability function
%%%at time t given the intensity matrix and the steady state.

%INPUTS:
%QMatrix - the intensity matrix
%t - contains time points and may be a vector.
%SS_eq - the steady state, column vector normalized to 1
%t_lim - the time point at which the release probability is 1 and the
% release rate is therefore set to 0. If NAN, there is no limit and the
% function is calculated for the whole t vector or until 0 is reached.

%OUTPUTS
%dfused_over_time - Derivative of fusion rate over time t (t is input var.)
%above0_t - The time point (if reached - else NAN) where release rate is 0.


% nSyts = par(8);


% SS_eq = determine_steady_state(par);
% SS_eq(end+1) = 0; %Fused state

% QMatrix = MakeQMatrix(par, Ca);
% if Ca >= 10
%     matfac = 1;
%     QMatrix_mod = QMatrix/matfac;
% else
%     QMatrix_mod = QMatrix;
%     matfac = 1;
% end

% delayfunc = @(t)(expm(QMatrix*t)*SS_eq)-5/nves;

dfused_over_time = zeros(length(t_vec),1);

% states = zers(length(t),length(SS_eq));

above0 = 1;
above0_t = NaN;

for k = 1:length(t_vec)
    tp = t_vec(k);
    if above0 && ((tp<=t_lim) || isnan(t_lim))

    %     [~,D,W] = eig(QMatrix*tp);
    %     states = (SS_eq*QMatrix*(inv(W')*expm(D)*W'));
        states = (SS_eq*QMatrix*(expm(QMatrix*tp)));
        dfused_over_time(k) = states(end);
        
        if dfused_over_time(k) <=0
            above0 = 0;
            above0_t = tp;
        end
    else
        dfused_over_time(k) = 0;
    end
end
%     dfused_over_time_test(count) = states_test(end);

% optim_func = likfunc-(5/1820);

% delay = fminsearch(optim_func, 0.1)


