function [loglikeli_delay] = delay_likeli(par, exclude_two, write_log)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%This script obtains the likelihood value of observing the experimental
%%data (loaded below) and if specified it writes a file to keep track of
%%the likelihood value during an optimization. 

%Input:
%par - all model parameters - generated using model_parameters
%Exclude_two - Whether or not to exclude the second data point in the data
%set (1 or 0)
%write_log - whether or not to write a file to keep track of the likelihood
%value during an optimization process. 

%output:
%loglikeli_delay - minus log of summed likelihood of datapoints

% par = model_parameters(par_init, fit_choice, nsyts, nves_mean, CaCoop, maxCross, nves_sd); %Get parameters for the model

nsyts = par(8);
fit_choice = par(15);


%%%%Write parameter choices to log-file of optimisation steps
if write_log
    filecont = sprintf(     ['k_on_Ca: ' num2str(par(1)) '\n' ...
                          'k_on_PIP: ' num2str(par(3)) '\n' ...
                          'PIP_conc: ' num2str(par(4)) '\n' ...
                          'l_val: ' num2str(par(6)) '\n' ...
                          'f_val: ' num2str(par(7)) '\n' ...
                          'Added delay: ' num2str(par(12)) '\n' ...
                           ]);
    fullfile = ['./Outputs/Fitting/Likelihood_optim_delay' num2str(nsyts) '_test_c_' num2str(par(5))];

    fullfile = [fullfile '_fit' num2str(fit_choice)];

    if fit_constraint
        fullfile = [fullfile '_constraint' num2str(fit_constraint)];
    end

    if exclude_two
        fullfile = [fullfile '_exclude' num2str(exclude_two)];
    end

    fullfile = [fullfile '.txt'];

    newParameterfile = fopen(fullfile,'a');
    fprintf(newParameterfile,'%s\n',filecont);
    fclose(newParameterfile);

    fclose('all');
end
%%%%%%%%%%%%%%%%%%%%%


load('ExpData_PIP2.mat') %Load experimental data

[likeli_delay] = Likelihood(par, ExpDelayCa, ExpDelay, exclude_two);
    %Find likelihood for each observation

loglikeli_delay = -sum(log(likeli_delay)); %-log-like is minimized in the optimisation
 
%%%Write the likelihood value to the log-file og optimisation steps.
if write_log
    filecont = sprintf(     ['----------------------------'  '\n' ...
                          'Likelihood: ' num2str(loglikeli_delay)  '\n'  '\n' ...
                           ]);


    newParameterfile = fopen(fullfile,'a');
    fprintf(newParameterfile,'%s\n',filecont);
    fclose(newParameterfile);

    fclose('all');
end
%%%%%%%%%%%%%%%%%%%%%
