function [par] = model_parameters(par_init, fit_choice, nsyts, nves_mean, CaCoop, maxCross, nves_sd, F, KD)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%This script generates the parameter vector in the PIP2-synaptotagmin
%%%model based on the choice of fitting and initial parameters.

%inputs
%par_init - set of fitted parameters
%fit_choice - fit choice to obtain set of parameters (generally used 6)
%nsyts - number of syts per sv
%Nves_mean - average number of vesicles
%CaCoop - 1 indicates single calcium binding to PIP, 2 - Calcium binding
%affinities below are based on model with two calcium ions binding
%MaxCross - number of slots 
%nves-sd - standard deviation of the pool estimates
% F - F-value (increase in fusion probability upon crosslink formation)
% only need to give this specific value when wanting to fit with different
% Fixed F-values (Fit_choice - 16) otherwise this can be a random number
% KD- to evaluate the effect of different affinities. 2-value array with
% first value corresponding to whether KDca (1), KDpip (2) or c (allostericity -3)
% is affected and the second value the degree of effect.

%Output
%par - array of all model paramters


k_onCa = 140;
c =  0.00022;%0.015;
l = 4.23e-4;
kD_Ca = 221^2;
Ca_bas = 0.05; %M
kD_PIP2 = 20;
k_onPIP2 = 105;
PIP2 = 27;
f = 25;
% nves = 1820;
del = 4e-4; %s
p_test1 = 0.75;
p_test2 = 0.9;

%%%mEPSC parameters:
ampl = 0.03*0.5; %Amplitude in nA
alph = 1-0.487; %slow decay time portion
tau0 = 0.04e-3; %rise time constant
tau1 = 2.38*1e-3; %fast decay time constant
tau2 = 11.43*1e-3; %slow decay time constant

if length(KD) ==2
    if KD(1) == 1 
        kD_Ca = kD_Ca *KD(2);
    elseif KD(1) ==2
        kD_PIP2 = kD_PIP2 *KD(2);
    elseif KD(1) ==3
        c = c* KD(2);
    end
end

        



%fit_choice == 1
%par_init = [k_onCa, k_onPIP2, PIP2, f]
if (fit_choice == 1) || (fit_choice == 5)
    k_onCa = par_init(1);
    k_onPIP2 = par_init(2);
    PIP2 = par_init(3);
    f = par_init(4);
%fit_choice == 2
%par_init = [k_onPIP2, PIP2, f]
elseif fit_choice == 2
    k_onPIP2 = par_init(1);
    PIP2 = par_init(2);
    f = par_init(3);
%fit_choice == 3
%par_init = [k_onCa, k_onPIP2, PIP2, l, f]
elseif fit_choice == 3
    k_onCa = par_init(1);
    k_onPIP2 = par_init(2);
    PIP2 = par_init(3);
    l = par_init(4);
    f = par_init(5);
elseif fit_choice == 4
    k_onCa = par_init(1);
    k_onPIP2 = par_init(2);
    PIP2 = par_init(3);
    f = par_init(4);
    del = par_init(5)*1e-3;
elseif fit_choice == 6
    k_onCa = par_init(1);
    k_onPIP2 = par_init(2);
    PIP2 = par_init(3);
    f = par_init(4);
    del = par_init(5)*1e-3;
elseif fit_choice == 7
    k_onCa = par_init(1);
    k_onPIP2 = par_init(2);
    PIP2 = par_init(3);
    c = par_init(4);
    f = par_init(5);
    del = par_init(6)*1e-3;
elseif fit_choice == 8
    k_onCa = par_init(1);
    k_onPIP2 = par_init(2);
    PIP2 = par_init(3);
    f = par_init(4);
    del = par_init(5)*1e-3;
    nves = par_init(6);
elseif fit_choice == 10
    k_onCa = par_init(1);
    PIP2 = par_init(2);
    f = par_init(3);
elseif fit_choice == 11
    k_onCa = par_init(1);
    PIP2 = par_init(2);
    f = par_init(3);
    del = par_init(4)*1e-3;
elseif fit_choice == 12
    PIP2 = par_init(1);
elseif fit_choice == 13
    kD_PIP2 = par_init(1);
elseif fit_choice ==14
    PIP2 = par_init(1);
    kD_PIP2 = par_init(2);
elseif fit_choice == 15
     k_onCa = par_init(1);
    k_onPIP2 = par_init(2);
    PIP2 = par_init(3);
    f = par_init(4);
    del = par_init(5)*1e-3;
    l =par_init(6);
elseif fit_choice == 16
    k_onCa = par_init(1);
    k_onPIP2 = par_init(2);
    PIP2 = par_init(3);
    f = F;
    del = par_init(4)*1e-3; 
elseif fit_choice ==17
    k_onCa = par_init(1);
    k_onPIP2 = par_init(2);
    PIP2 = par_init(3);
    f = par_init(4);
    del = par_init(5)*1e-3; 
    l= par_init(6)*1e-4;
elseif fit_choice == 100
    k_onCa = par_init(1); %k_on calcium
    kD_Ca = par_init(2)/par_init(1); %k_off calcium
    k_onPIP2 = 0;
    PIP2 = 0;
    c = 0.49;
    l = 3.5e-4;
    f = par_init(3);
    CaCoop = 1;
    maxCross = 100;
end




par(1) = k_onCa;
par(2) = kD_Ca;
par(3) = k_onPIP2;
par(4) = PIP2;
par(5) = c;
par(6) = l;
par(7) = f;
par(8) = nsyts;
par(9) = kD_PIP2;
par(10) = Ca_bas;
par(11) = nves_mean;
par(12) = del;
par(13) = CaCoop;
par(14) = maxCross;
par(15) = fit_choice;
% par(16) = n_slots;
par(16) = p_test1;
par(17) = p_test2;
par(18) = ampl; % mEPSC amplitude
par(19) = alph; %mEPSC slow decay time portion
par(20) = tau0; %mEPSC rise time constant
par(21) = tau1; %mEPSC fast decay time constant
par(22) = tau2; %mEPSC slow decay time constant
par(23) = nves_sd;

if fit_choice == 12
par(1) = 24.6996578949478;%best fit konCA
par(3) = 124.738449685217;%best fit KonPIP
par(7) = 128.210441901460;%best fit f
par(12) = 0.380277415681611e-3;%added delay
par(4) = PIP2;
end
%par(6) = l*7;
%par(9) = kD_PIP2;









