function [cost_combi,least_squares_rates,loglikeli_delay,loglikeli_rates] = cost_function_combi(par_fit, nsyts, fit_choice, exclude_two, leaveout_low, lambda, nves_mean, CaCoop, maxCross, nves_sd, rates_likeli, F, KD)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% This script determines the costs assocated with the model parameters and
% includes both the liklihood of delays computation as the squared
% difference between experimentally obtained release rates and those
% simulated by the model
%The script automatically generates a log-file to keep track of the
%optimization process. 

%INPUTS
%par_fit - set of parameter values that are used in fitting
%nsyts - number of syts evaluated in the model
%fit_choice - choice of fit option, par_fit needs to correspond to this
%choice (see modelparameters to get the different fit_choice options)
%exlude_two - whether or not to exclude the second data point in the
%release latency measurements. 
%leave-out low - whether or not to include all peak release rate points or
%leave the onces out that do not have a corresponding release latency
%measurement. 
%lambda - factor on costs of peak release rates when combinding with the log
%likelohood of delays 
%nves_mean - average number of vesicles
%CaCoop - Value of 1 indicates binding of a single ca to syt, 2 indicates
%cooperative binding of two calcium ions
%maxCross - number of slots
%nves_sd - standard deviation of RRP size distribution
%rates_likeli - 1 to compute costs based on likelihood of rates
% F - F-value (increase in fusion probability upon crosslink formation)
% only need to give this specific value when wanting to fit with different
% Fixed F-values (Fit_choice - 16) otherwise this can be a random number
% KD- to evaluate the effect of different affinities. 2-value array with
% first value corresponding to whether KDca (1), KDpip (2) or c (allostericity -3)
% is affected and the second value the degree of effect.

%OUTPUT
%cost_combi - combined costs value
%least_squares_rates 
%loglikeli_delay
%loglikeli_rates

%%%Generate filename for optimisation result file. 
%%%Written continuously for each step in the looped optimisation.

%disp(['konca ', num2str(par_fit(1)), ', konpip ',  num2str(par_fit(2)),' ,pip ',  num2str(par_fit(3)), ', F ',  num2str(par_fit(4)) ', addedd ',  num2str(par_fit(5)),  'Timepoint: ' datestr(now,'HH:MM:SS')]) 

fullfile = ['./Outputs/Fitting/Combi_optim_logfile_nsyt' num2str(nsyts) '_fitchoice' num2str(fit_choice)];
% if fit_constraint
%     fullfile = [fullfile '_constraint' num2str(fit_constraint)];
% end
if exclude_two
    fullfile = [fullfile '_exclude' num2str(exclude_two)];
end
fullfile = [fullfile '_combi_leavelow' num2str(leaveout_low) '_lambda' num2str(lambda) '_nvesmean' num2str(nves_mean) '_nvesSD' num2str(nves_sd)  '_likelirates' num2str(rates_likeli) '_maxcross' num2str(maxCross) 'F.txt'];
%%%%%%%%%%%%%%%%%%
%par_fit(1)
%par_fit(2)
%par_fit(3)
%par_fit(4)
par = model_parameters(par_fit, fit_choice, nsyts, nves_mean, CaCoop, maxCross, nves_sd, F, KD); %Get parameters for the model


write_log = 0;

[loglikeli_delay] = delay_likeli(par, exclude_two, write_log);

%disp(['finished delays' ' time: ' datestr(now,'HH:MM:SS.FFF')])
if lambda~= 0
    [least_squares_rates, loglikeli_rates] = cost_rates_PIPon(par, exclude_two, leaveout_low, write_log);
else
    least_squares_rates = 0;
end
%disp(['finished rates' ' time: ' datestr(now,'HH:MM:SS.FFF')])


if rates_likeli
    cost_combi = loglikeli_delay + lambda*loglikeli_rates;
else
    cost_combi = loglikeli_delay + lambda*least_squares_rates;
end
    
    
    filecont1 = sprintf('Fitting PIP2-Syt model with likelihood and delays\n');

    filecont2 = sprintf(     ['***Optimized parameters***' '\n' ...
                              'Fitted parameters: ' num2str(par_fit) '\n' ...
                              'Lambda: ' num2str(lambda) '\n' ...
                              '***RESULTS***' '\n' ... 
                              'MINUS log-likeli: ' num2str(loglikeli_delay) '\n' ...
                              'Least squares: ' num2str(least_squares_rates) '\n' ...
                              'MINUS log-likeli (rates): ' num2str(loglikeli_rates) '\n' ...  
                              'cost_combi:' num2str(cost_combi) '\n' ...
                              '\n' '------------------- \n' '\n' ...
                              'Timepoint: ' datestr(now,'HH:MM:SS') '\n' ...
                              '\n' '------------------- \n' '\n' ...
                              ]);

    %%%Write log-file
    newParameterfile = fopen(fullfile,'a');
    fprintf(newParameterfile,'%s\n',filecont1);
    fprintf(newParameterfile,'%s\n',filecont2);
    fclose(newParameterfile);

    fclose('all');
    %%%%%%%%%%%%%%%
