function [cost, loglikeli_rates] = cost_rates_PIPon(par, exclude_two, leaveout_low, write_log)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% This script determines the costs assocated with the model parameters and
% includes both the liklihood of delays computation as the squared
% difference between experimentally obtained release rates and those
% simulated by the model
%The script automatically generates a log-file to keep track of the
%optimization process. 

%INPUTS
%par - all paramaters of the model
%exlude_two - whether or not to exclude the second data point in the
%release latency measurements. 
%leave-out low - whether or not to include all peak release rate points or
%leave the onces out that do not have a corresponding release latency
%measurement. 
%write_log - whether or not to write a log file keeping track of all
%computed least_squares during fitting routine

%OUTPUT
%costs - least_squares_rates 
%loglikeli_rates

% par = model_parameters(par_fitted, fit_choice, nsyts, nves_mean, CaCoop, maxCross, nves_sd); %Get model parameters


nsyts = par(8);
nves_mean = par(11);
nves_sd = par(23);
fit_choice = par(15);


% if ~exist('./Scripts', 'dir')
%     error('Wrong folder')
% end

%%%Write log-file of 
if write_log
    filecont = sprintf(     ['k_on_Ca: ' num2str(par(1)) '\n' ...
                          'k_on_PIP: ' num2str(par(3)) '\n' ...
                          'PIP_conc: ' num2str(par(4)) '\n' ...
                          'l_val: ' num2str(par(6)) '\n' ...
                          'f_val: ' num2str(par(7)) '\n' ...
                          'Added delay: ' num2str(par(12)) '\n' ...
                           ]);
    fullfile = ['./Outputs/Fitting/Optim_konPIP' num2str(nsyts)];

    fullfile = [fullfile '_fit' num2str(fit_choice)];

    fullfile = [fullfile '.txt'];

    newParameterfile = fopen(fullfile,'a');
    fprintf(newParameterfile,'%s\n',filecont);
    fclose(newParameterfile);

    fclose('all');
end
%%%%%%%%%%%%%%%%%%%%%

load('ExpData_PIP2.mat')
%load('ExpData_PIP2_3Kmutant.mat')


if sum(par <= 0) > 0 || par(12)  > min(ExpDelay) || par(12) < 0.3e-3 %|| sum(par([1,3,4])>1e5)>0 % || par(7)^par(14) > 1e18
    loglikeli_rates = inf;
    cost = inf;
        %If conditions on parameters are not met, likelihood is -infty
        %Conditions: Parameters must be positive. If fit_constraint>0, we require par(7)=f<fit_constrant 
else


par(23) = 0; %Use fixed RRP size for rate estimations.

[rates_est_crude] = est_rates_crude_new(par, exclude_two, leaveout_low);
 
% if ~leaveout_low
%     Ca = ExpRateCa(1);
%     [rate_est] = est_rate(par, nves, Ca);
%     rates_est_crude(1) = rate_est;
% end



if exclude_two
    delay_ind = [36 39:85];
else
    delay_ind = [36:37 39:85];
end
    
if leaveout_low
    cost = sum((log(rates_est_crude*1e-3) - log(ExpRate(delay_ind))).^2);
else
    if exclude_two == 0
        cost = sum((log(rates_est_crude*1e-3) - log(ExpRate)).^2);
    else
        end_ind = length(ExpRate);
        cost = sum((log(rates_est_crude*1e-3) - log(ExpRate([1:36 38:end_ind]))).^2);
    end
end

if nves_sd >0
    k_gamma = (nves_mean^2)/(nves_sd^2);
    thet_gamma = (nves_sd^2)/nves_mean;
    
    
    if leaveout_low
        inds = delay_ind;
    else
        if exclude_two == 0
            inds = 1:length(ExpRate);
        else
            end_ind = length(ExpRate);
            inds = [1:36 38:end_ind];
        end
    end
    likeli_rates = zeros(1,length(inds));
    
    for k = 1:length(inds)
        ind = inds(k);
        M = (rates_est_crude(k)*1e-3)/nves_mean;
        likeli_rates(k) = gampdf(ExpRate(ind), k_gamma, thet_gamma*M);
    end
    
    
    loglikeli_rates = -sum(log(likeli_rates));
    if loglikeli_rates == inf
        loglikeli_rates = 1e10;
    end
else
    loglikeli_rates = nan;
end





if write_log
    filecont = sprintf(     ['----------------------------'  '\n' ...
                          'Least squares: ' num2str(cost)  '\n'  '\n' ...
                              'Timepoint: ' datestr(now,'HH:MM:SS') '\n' ...
                              '\n' '------------------- \n' '\n' ...
                           ]);

    
    newParameterfile = fopen(fullfile,'a');
    fprintf(newParameterfile,'%s\n',filecont);
    fclose(newParameterfile);

    fclose('all');
end
end