function [rates_est_crude, nves_draws] = est_rates_crude_new(par, exclude_two, leaveout_low)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% This script determines the peak release rates at calcium concentrations
% observed in the experimental data. Peak release rates are determined via
% a costum build search algorithm. These estimations are used in the
% fitting routine. For peak release rate estimation for the figures see the
% function "simulate_peak_release_rate.m". 

%INPUTS
%par - all paramaters of the model
%exlude_two - whether or not to exclude the second data point in the
%release latency measurements. 
%leave-out low - whether or not to include all peak release rate points or
%leave the onces out that do not have a corresponding release latency
%measurement. 

%outputs
%rates_est_crude - estimated peak release rates for all evaluated calcium
%concentration and each repetition
%nves_draws - drawed RRP sizes for each repetition

load('ExpData_PIP2.mat')

fit_choice = par(15);

step_chng = 5;

% precision_step = 0.0001;
% t_max = 0.1;
% lb = 0;
% ub = t_max;
% step_sz = 0.01;

% t_vec = 0:0.0001:0.1;


if exclude_two
    delay_ind = [36 39:85];
else
    delay_ind = [36:37 39:85];
end

Ca_0 = par(10);
nves_mean = par(11);
nves_sd = par(23);
p_test1 = par(16);
p_test2 = par(17);

if par(15) >= 100
    SS_eq_proto =  steady_state_LOU(par, 1, Ca_0);
    SS_eq_proto(end+1) = 0;    
else
    SS_eq_proto =  steady_state_newmethod(par, 1, Ca_0);
    SS_eq_proto(end+1) = 0;
end

    
if leaveout_low
    ExpRateCa_used = ExpRateCa(delay_ind);
elseif ~leaveout_low
    ExpRateCa_used = ExpRateCa;
    if exclude_two
        ExpRateCa_used(37) = [];
    end
end


rates_est_crude_init = zeros(length(ExpRateCa_used),1);
parfor ind = 1:length(ExpRateCa_used)
    tic
    Calcium = ExpRateCa_used(ind);
    
    if Calcium >= 0.05
        SS_eq = SS_eq_proto; %Use the basal calcium concentration for initial distr.
    elseif Calcium < 0.05
        
        if par(15) >= 100
        SS_eq = steady_state_LOU(par, 1, Calcium); %Use exp. calcium concentration for initial distr.
        SS_eq(end+1) = 0; %Add fused state to new initial distribution.
        else
        SS_eq = steady_state_newmethod(par, 1, Calcium); %Use exp. calcium concentration for initial distr.
        SS_eq(end+1) = 0; %Add fused state to new initial distribution.
        end
    end
    
    QMatrix = call_QMatrix(par, Calcium);
    
    precision_step = 0.00001;
    t_max = 1;
    lb = 0;
    ub = t_max;
    p_lb = 0;
    p_ub =  P_function(QMatrix, SS_eq, ub);
    
    step_sz = ub/step_chng;
    
    goon = 1;

    while goon == 1
        t_vec = lb:step_sz:ub;
%         if Calcium == 1.710200000000000
%         disp(['t_vec: ', num2str(t_vec)])
%         end
        test_fuse = P_function(QMatrix, SS_eq, t_vec(2:(end-1)));
        test_fuse = [p_lb; test_fuse; p_ub];
        test_ind = find(test_fuse>p_test1, 1, 'first');
%             test_ind2 = find(test_fuse >= 0.98*nves, 1, 'first');


%             if isempty(test_ind)
%                 lb = ub;
%                 ub = 2*ub;
%                 step_sz = (ub-lb)/10;
%             else
%             ub = t_vec(test_ind);
%             lb = t_vec(test_ind - 1);
%             step_sz = step_sz/10;
%             end

%             goon = (isempty(test_ind) || ~isempty(test_ind2));
        if ~isempty(test_ind) 
            if test_fuse(test_ind)>=p_test2 && test_fuse(test_ind)<=1
                ub = t_vec(test_ind);
                lb = t_vec(test_ind - 1);
                step_sz = (ub-lb)/step_chng;
                p_lb = test_fuse(test_ind-1);
                p_ub = test_fuse(test_ind);
                goon = 1;
            elseif test_fuse(test_ind)>1
                ub = t_vec(test_ind);
                if test_ind>3
                    lb= t_vec(test_ind-2);
                    p_lb = test_fuse(test_ind-2);
                else 
                    lb = 0;
                    p_lb = 0;
                end
                step_sz = (ub-lb)/step_chng;
                p_ub = test_fuse(test_ind);
                goon = 1;
            else

                goon = 0;
            end
        else
            lb = t_vec(end);
            ub = lb * 10;
            p_lb = test_fuse(end);
            p_ub = P_function(QMatrix, SS_eq, ub);
            
            step_sz = (ub-lb)/step_chng;
%             warning(['Fewer than ' num2str(p_test) ' of the vesicles reacted when determining the max. fusion rate.'])
%             warning('Try increasing t_max or increasing the lower bound of fused vesicles.')
            goon = 1;
        end
            

    end
   
    goon = 1;
    lb = 0;
    ub = t_vec(test_ind)
    step_sz = ub/step_chng;
    
    
    while ((step_sz >= precision_step) || (goon == 1))
        t_vec = lb:step_sz:ub;
       % if Calcium <0.011
        %[fused_over_time] = P_function(QMatrix, SS_eq, t_vec)
        %end
        [dfused_over_time] = dP_function(QMatrix, SS_eq, t_vec);
        [max_rate, max_ind] = max(abs(dfused_over_time));

        lb = t_vec(max([1,max_ind-1])); %account for max_ind == 1
        ub = t_vec(min([length(t_vec), max_ind+1])); %account for max_ind == end

        step_sz = step_sz/step_chng;
        goon = 0;
    end
        
    rates_est_crude_init(ind) = max_rate;
   % disp(['finished exp ca ', num2str(Calcium)])
end

if nves_sd == 0
    n_draw = 1;
else
    n_draw = 1000;
end

% nves_draws = round(normrnd(nves_mean, nves_sd, length(ExpRateCa_used), n_draw));
% 
% nves_draws(nves_draws<0) = 0;
if nves_sd 
    k_gamma = (nves_mean^2)/(nves_sd^2);
    thet_gamma = (nves_sd^2)/nves_mean;

    nves_draws = round(gamrnd(k_gamma, thet_gamma, length(ExpRateCa_used), n_draw));

    goon = sum(nves_draws(:)<5);
    while goon
        bad_inds = find(nves_draws(:)<5);
        nves_draws(bad_inds) = round(gamrnd(k_gamma, thet_gamma, length(bad_inds), 1));

        goon = sum(nves_draws(:)<5);
    end
else
    nves_draws = nves_mean*ones(length(ExpRateCa_used), n_draw);
end


rates_est_crude = zeros(length(ExpRateCa_used),n_draw);

for k = 1:length(ExpRateCa_used)
    rates_est_crude(k,:) = rates_est_crude_init(k)*nves_draws(k,:);
end

