function [delays, delay_medians, delay_2_5q, delay_97_5q, Calciums_delay, par, firstfus, firstfus_medians, firstfus_2_5q, firstfus_97_5q, secondfus, thirdfus, fourthfus, timepoints_sort, t_highest] = simulate_delays(n_rep, varRRP, varSyt, varSlot, smallRRP_IO, fitslot, excludeOutl, Lplus, lambda, allost_IO, param_no, param_fac, nsyts_mean, nslots_mean, simEPSCs)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script uses the pre-calculated functions (see scripts in folder
%%%%"generic_functions") to stochastically simulate release latencies.

%INPUTS
%n_rep - number of repetitions of release latency simulation
%varRRP - whether the RRP size is variable (0 or 1) 
%varSyt - whether the number of syts per SV is variable (0 or 1) 
%varSlot - whether the number of slots per SV is variable (0 or 1) 
%smallRRP_IO - whether the RRP size is [if 0]: mean 4000 (SD 2000 if variable) 
% or [if 1]: mean 10 (SD 5 if variable)
%fitslot - the number of slots used in the fitting routine.
%excludeOutl - Whether or not the second release latency observation was
% fitted to
%Lplus - The Calcium independent fusion rate
%lambda - The lambda used in cost value calculation
%allost_IO - Whether the fitting routine was with or without allostericity
% (0 or 1)
%param_no - [if 0]: Parameters are best fit values. [if ~= 0]: Indicates
% the parameter to be varied (Figure 2 - figure supplement 3)
%param_fac - The factor on the parameter, if a parameter is varied (Figure
% 2 - figure supplement 3)
%nsyts_mean - mean number of syts per SV
%nslots_mean - mean number of slots per SV
%simEPSCs - set to 0

%OUTPUTS
%delays - all release latencies (fifth fusion time points) simulated (all 
% calcium concentrations and all repetitions)
%delay_medians - median release latencies (5th fusion time points) 
% simulated (all calcium concentrations)
%delay_2_5q - 2.5 % quantiles of determined release latencies
%delay_97_5q - 97.5 % quantiles of determined release latencies
%Calciums_delay - Calcium concentrations used for release latency
% simulations
%par - parameters used (loaded from best fit parameters file)
%firstfus - all first fusion time points simulated (all calcium 
% concentrations and all repetitions)
%firstfus_medians - median first fusion time points simulated (all calcium 
% concentrations)
%firstfus_2_5q - 2.5 % quantiles of determined first fusion times
%firstfus_97_5q - 97.5 % quantiles of determined first fusion times
%secondfus - all second fusion time points simulated (all calcium 
% concentrations and all repetitions)
%thirdfus - all third fusion time points simulated (all calcium 
% concentrations and all repetitions)
%fourthfus - all fourth fusion time points simulated (all calcium 
% concentrations and all repetitions)
%timepoints_sort - all determined fusion time points sorted
%t_highest

PIPup = 0;
if PIPup
    warning('PIPup simulation')
    par(8) = 3;
end

if (~allost_IO && param_no)
    warning('Trying to simulate varying parameters without allostericity')
    return
end

if allost_IO && ~param_no
    if ~Lplus
        filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice17_exclude' num2str(excludeOutl) '_lambda' num2str(lambda) '.mat'];
    else
        filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice6_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '.mat'];
    end
end
    
if ~allost_IO
    filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice6_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_A1.mat'];
end   


if allost_IO && param_no
    filename = ['./Outputs/Figure_results/Generic_functions/varyparams/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice6_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_varyparams' num2str(param_no) '_paramfact' num2str(param_fac) '.mat'];
end

if PIPup
    filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice6_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_3sytsPIPup.mat'];
    warning('Refitted PIP2 concentration. Make sure parameters are right')
end

load(filename)

if PIPup
    warning('PIPup simulation')
    par(8) = 3;
end

if allost_IO && param_no
    param_ind = param_inds(param_no);
    par_temp = par;
    par(param_ind) = par_temp(param_ind)*param_fac;
end



 %Calciums = [0.01 0.1 0.5 1 1.5 2 5 10 20 30 40 50 60 70 80];

if smallRRP_IO || simEPSCs
    
    delay_inds = 24;
%     Calciums = 10;
else
    delay_inds = 11:length(Calciums);
end

Calciums_delay = Calciums(delay_inds);


% if smallRRP_IO
%     Calciums_delay = [10 50];
% end


if smallRRP_IO
    par(11) = 10;
    par(23) = 5;
end

nves_mean = par(11);
nves_sd = par(23);


[firstfus, secondfus, thirdfus, fourthfus, delays, noSlots_inds_all] = deal(NaN(length(Calciums), n_rep));

num_warn = 0;

t_highest = inf;
times_highest = NaN(length(Calciums), 1);


for kCa = delay_inds
    Calcium = Calciums(kCa);
    
    
    [QMatrix_test] = MakeQMatrix(par, Calcium);
    testsyt = par(8);
    testslot = par(14);
    QMatrix_load = QMatrix_cells{kCa, testsyt, testslot};
    Q_test = sum(QMatrix_test~=QMatrix_load);
    if sum(Q_test)
        warning('WARNING: Calcium choice does not match loaded file')
        return
    end
    

    if nves_sd && varRRP
        k_gamma = (nves_mean^2)/(nves_sd^2);
        thet_gamma = (nves_sd^2)/nves_mean;

        nves_draws = round(gamrnd(k_gamma, thet_gamma, length(Calcium), n_rep));

        if ~smallRRP_IO
            low_limit = 5;
        else
            low_limit = 1;
        end
        
        goon = sum(nves_draws(:)<low_limit);
        while goon
            bad_inds = find(nves_draws(:)<low_limit);
            nves_draws(bad_inds) = round(gamrnd(k_gamma, thet_gamma, length(bad_inds), 1));

            goon = sum(nves_draws(:)<low_limit);
        end
%         end
    else
        nves_draws = nves_mean*ones(length(Calciums), n_rep);
    end

    nves_max = max(nves_draws(:));

    [syt_set, slot_set] = variability_choice(n_rep, nves_max, varSyt, varSlot, nsyts_mean, nslots_mean);

    
    p_draw = rand(size(syt_set));
    
    
    for k = 1:n_rep
        nves_here = nves_draws(k);
        if nves_here<nves_max
            syt_set(k,(nves_here+1):end) = NaN;
            slot_set(k,(nves_here+1):end) = NaN;
            p_draw(k,(nves_here+1):end) = NaN;
        end
    end
    
    timepoints = nan(size(syt_set));
    
    syts_uniq = unique(syt_set);
    syts_uniq(isnan(syts_uniq)) = [];
    slots_uniq = unique(slot_set);
    slots_uniq(isnan(slots_uniq)) = [];
    
    for nsyt_loop = max(min(syts_uniq),1):max(syts_uniq)
        for nslot_loop = max(min(slots_uniq),1):max(slots_uniq)
            t_vec_fus = tvec_fus_cells{kCa, nsyt_loop, nslot_loop};
            P_func = P_cells{kCa, nsyt_loop, nslot_loop};
            
            if ~isempty(P_func)
                interp_inds = find((syt_set==nsyt_loop).*(slot_set==nslot_loop));
                
                [P_uniq, uniq_inds] = unique(P_func);
                t_uniq = t_vec_fus(uniq_inds);
                
                if sum(interp_inds(:))>0
                    t_high = t_highest; 
                    t_highest = min(t_vec_fus(end), t_high);
                end

                for pind = interp_inds
                    p_val = p_draw(pind);
                    if p_val>max(P_func)
                        timepoints(pind) = NaN;
                    else
                        timepoints(pind) = interp1(P_uniq, t_uniq, p_val);
                    end
                end
            else
                interp_inds_test = find((syt_set==nsyt_loop).*(slot_set==nslot_loop));
%                 disp(['Empty: nsyt=' num2str(nsyt_loop) ', nslot=' num2str(nslot_loop)])
                if isempty(interp_inds_test)
%                     disp('Alright')
                else
                    disp(['Empty: nsyt=' num2str(nsyt_loop) ', nslot=' num2str(nslot_loop)])
                    warning('NOT OK!!!')
                    num_warn = num_warn +1;
                    return
                end
            end
            
        end
        
    end
    
    times_highest(kCa) = t_highest;
    
    noSlots_inds = find(slot_set==0);
%     noSlots_inds_all(kCa,:) = (slot_set~=0)
    noSlots_p = p_draw(noSlots_inds);
    timepoints(noSlots_inds) = -log(1-noSlots_p) /par(6);
    
    timepoints_sort = sort(timepoints,2);
    
    firstfus(kCa,:) = timepoints_sort(:,1);
    secondfus(kCa,:) = timepoints_sort(:,2);
    thirdfus(kCa,:) = timepoints_sort(:,3);
    fourthfus(kCa,:) = timepoints_sort(:,4);
    delays(kCa, :) = timepoints_sort(:,5);
%     disp(['Number of warnings: ' num2str(num_warn)])
end



delay_max = max(delays, [], 2, 'includenan');
first_fus_max = max(firstfus, [], 2, 'includenan');

if ~smallRRP_IO
    test_fus = delay_max;
elseif smallRRP_IO
    test_fus = first_fus_max;
end
    
nan_test = sum(isnan(test_fus),2);


if (sum((test_fus(delay_inds)>times_highest(delay_inds))) || (sum(nan_test(delay_inds)))) && ((~param_no) && (nsyts_mean==15))
    warning(['Delay or first fusion higher than maximal time point occured. varSyt ' num2str(varSyt) ' varSlot ' num2str(varSlot)])
    disp('Problematic Ca2+ inds:')
    nans_occured = find(nan_test>0);
    find(nans_occured>=delay_inds(1))
    disp(['Vary param no ' num2str(param_no)])
    disp(['Param fact ' num2str(param_fac)])
%     return
end


firstfus_medians = median(firstfus, 2);
firstfus_2_5q = quantile(firstfus, 0.025, 2);
firstfus_97_5q = quantile(firstfus, 0.975, 2);

delay_medians = median(delays,2);
delay_2_5q = quantile(delays, 0.025, 2);
delay_97_5q = quantile(delays, 0.975, 2);

if param_no || (nsyts_mean<15)
    delays_sorted = sort(delays,2);
    
    firstNaNs = NaN(length(Calciums),1);
    for k = 1:length(Calciums)
        firstNaN = find(isnan(delays_sorted(k,:)), 1, 'first');
        if (firstNaN > 0)*(k>=delay_inds(1)) 
            firstNaNs(k) = firstNaN;
        end
    end
    if sum(firstNaNs(delay_inds)<=(0.5*n_rep+1))
        disp(['Vary param no ' num2str(param_no)])
        disp(['Param fact ' num2str(param_fac)])
        disp('We are not using the prediction interval. ')
        disp('Problematic delay Ca2+ inds: ')
        find((firstNaNs(delay_inds)<=(0.5*n_rep+1)))+delay_inds(1)-1
    else
        delays(isnan(delays)) = 1e6;
        delay_medians = median(delays,2);
%         disp(['Vary param no ' num2str(param_no)])
%         disp(['Param fact ' num2str(param_fac)])
        disp('We are not using the prediction interval')
        disp(['nSyts = ' num2str(nsyts_mean)])
        disp('All delay inds were okay')
    end
    
end


if t_highest<0.1
    warning('Highest t for interpolation was below 100 ms')
end





