function [] = calculate_generic_functions_multiple_varyparameter()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script calculates the release rates and fusion probabilities over
%%%%time and stores it in the pre-generated cell variables for Figure 2 -
%%%%figure supplement 3

lambda = 2;
LplusFit = 0;
excludeOutl = 0;
Lplus = 423; %4.23e-4
Allost_IO = 1;

fitslot = 3;

fitchoice = min(abs(LplusFit), LplusFit+1)*11 + 6;

for k = 1:4
    for param_fact = [1/5 1/3 1/2 1 2 3 5]

    if fitchoice == 17
        filename = ['./Outputs/Figure_results/Generic_functions/varyparams/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_lambda' num2str(lambda) '_varyparams' num2str(k) '_paramfact' num2str(param_fact) '.mat'];
        resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_leavelow0_lambda' num2str(lambda) '_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno1.mat'];
    elseif fitchoice == 6
        filename = ['./Outputs/Figure_results/Generic_functions/varyparams/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_varyparams' num2str(k) '_paramfact' num2str(param_fact) '.mat'];
        resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_leavelow0_lambda' num2str(lambda) '_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno16_KDcato2ions2.mat'];
        if fitslot == 1
            resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_leavelow0_lambda' num2str(lambda) '_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno51_KDcato2ions2.mat'];
        end
    end



        load(filename)

        Calciums_used = Calciums;


        t_vec_all = 0:0.00001:0.1;


        Ca_0_init = 0.05;


        load(resultsfilename, 'par')

        par_loop = par;



        
        disp(['Param no.: ' num2str(k)]) 
        disp(['Param factor: ' num2str(param_fact)])
        
        nsyt = 15;
        nslot = 3;
        param_ind = param_inds(k);
%         param_factor = param_factors(k);


        disp(['fitSlots = ' num2str(fitslot) ', Lplusfit = ' num2str(LplusFit) ', excludeOutli = ' num2str(excludeOutl)])

        parfor m = 1:length(Calciums_used)
            Calcium = Calciums_used(m);

            disp(['Calcium = ' num2str(Calcium) ', Param no.: ' num2str(k) ', Param factor: ' num2str(param_fact)])
            test = dP_cells{m,nsyt,nslot};
            if ~isempty(test)
                disp([', Param ind: ' num2str(k) ', Param factor: ' num2str(param_fact)])
                disp('Already done or invalid')
            else

                if nslot <= nsyt
                    par_here = par_loop;



                    par_here(param_ind) = par_loop(param_ind)*param_fact;
                    par_here(8) = nsyt;
                    par_here(14) = nslot;


                    [QMatrix] = MakeQMatrix(par_here, Calcium);

                    if Calcium>=Ca_0_init
                        Ca_0 = Ca_0_init
                    else
                        Ca_0 = Calcium;
                    end

                    [SS_eq] = steady_state_newmethod(par_here, 1, Ca_0);
                    SS_eq(end+1) = 0;

                    if Calcium>=1
                        if (Calcium >1) || Allost_IO%%
                            t_vec_fus = t_vec_all;
                        elseif (Calcium == 1) && ~Allost_IO
                            t_vec_fus = 0:0.00001:0.5;
                        end
                        [fused_over_time, below1_t] = P_function_limit(QMatrix, SS_eq, t_vec_fus);
                    else
                        t_vec_fus = NaN;
                        fused_over_time = NaN;
                        below1_t = NaN;
                    end

                    [dfused_over_time, ~] = dP_function_limit(QMatrix, SS_eq, t_vec_all, below1_t);

                    dP_cells{m,nsyt,nslot} = dfused_over_time;
                    P_cells{m,nsyt,nslot} = fused_over_time;
                    SS_eq_cells{m,nsyt,nslot} = SS_eq;
                    QMatrix_cells{m,nsyt,nslot} = QMatrix;
                    tvec_fus_cells{m,nsyt,nslot} = t_vec_fus;
                    tvec_rate_cells{m,nsyt,nslot} = t_vec_all;
    %                 save('./Outputs/Figure_results//generic_functions_bestfit.mat', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_cells', 'Calciums', 'nsyts', 'nslots', '-v7.3')
                end
            end
        end

        save(filename, 'fitslot', 'param_inds', 'param_factors', 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells', 'Calciums', '-v7.3')

    end
end


% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% clear
% lambda = 2;
% LplusFit = 0;
% excludeOutl = 0;
% Lplus = 423; %4.23e-4
% 
% 
% 
% for fitslot = 3
% 
% 
%     fitchoice = min(abs(LplusFit), LplusFit+1)*11 + 6;
%     if fitchoice == 17
%         filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_lambda' num2str(lambda) '.mat'];
%         resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_leavelow0_lambda' num2str(lambda) '_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno1.mat'];
%     elseif fitchoice == 6
%         filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '.mat'];
%         resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_leavelow0_lambda' num2str(lambda) '_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno16KDcato2ions2.mat'];
%         if fitslot == 1
%                     resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_leavelow0_lambda' num2str(lambda) '_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno51KDcato2ions2.mat'];
%         end
%     end
% 
% 
%     load(filename)
% 
%     Calciums_used = Calciums;
% 
%     t_vec_all = 0:0.00001:0.1;
%     
%     Ca_0_init = 0.05;
% 
% 
%     load(resultsfilename, 'par')
% 
%     par_loop = par;
% 
% 
%     for k = fitslot
%         for l = 24:30
%             nsyt = nsyts(l);
%             nslot = nslots(k);
% 
% 
%             disp(['fitSlots = ' num2str(fitslot) ', Lplusfit = ' num2str(LplusFit) ', excludeOutli = ' num2str(excludeOutl)])
% 
%             parfor m = 1:length(Calciums_used)
%                 Calcium = Calciums_used(m);
% 
%                 disp(['Calcium = ' num2str(Calcium) ', nsyt = ' num2str(nsyt) ', nslot = ' num2str(nslot)])
%                 test = dP_cells{m,l,k};
%                 if ~isempty(test)
%                     disp(['nsyt = ' num2str(nsyt) ', nslot = ' num2str(nslot)])
%                     disp('Already done or invalid')
%                 else
% 
%                     if k <= l
%                         par_here = par_loop;
% 
% 
% 
%                         par_here(8) = nsyt;
%                         par_here(14) = nslot;
% 
% 
%                         [QMatrix] = MakeQMatrix(par_here, Calcium);
% 
%                         if Calcium>=Ca_0_init
%                             Ca_0 = Ca_0_init
%                         else
%                             Ca_0 = Calcium;
%                         end
% 
%                         [SS_eq] = steady_state_newmethod(par_here, 1, Ca_0);
%                         SS_eq(end+1) = 0;
% 
%                         if Calcium>=1
%                             if Calcium >1
%                                 t_vec_fus2 = t_vec_all;
%                             elseif Calcium == 1
%                                 t_vec_fus2 = 0:0.00001:0.5;
%                             end
%                             [fused_over_time, below1_t] = P_function_limit(QMatrix, SS_eq, t_vec_fus2);
%                         else
%                             t_vec_fus2 = NaN;
%                             fused_over_time = NaN;
%                             below1_t = NaN;
%                         end
% 
%                         [dfused_over_time, ~] = dP_function_limit(QMatrix, SS_eq, t_vec_all, below1_t);
% 
%                         dP_cells{m,l,k} = dfused_over_time;
%                         P_cells{m,l,k} = fused_over_time;
%                         SS_eq_cells{m,l,k} = SS_eq;
%                         QMatrix_cells{m,l,k} = QMatrix;
%                         tvec_fus_cells{m,l,k} = t_vec_fus2;
%                         tvec_rate_cells{m,l,k} = t_vec_all;
%         %                 save('./Outputs/Figure_results//generic_functions_bestfit.mat', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_cells', 'Calciums', 'nsyts', 'nslots', '-v7.3')
%                     end
%                 end
%             end
% 
%             save(filename, 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells', 'Calciums', 'nsyts', 'nslots', '-v7.3')
% 
%         end
%     end
% end
% 
% %%%%%%%%%%%%%%%
% 
% clear
% lambda = 2;
% LplusFit = 0;
% excludeOutl = 0;
% Lplus = 423; %4.23e-4
% 
% 
% 
% for fitslot = 3
% 
% 
%     fitchoice = min(abs(LplusFit), LplusFit+1)*11 + 6;
%     if fitchoice == 17
%         filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_lambda' num2str(lambda) '.mat'];
%         resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_leavelow0_lambda' num2str(lambda) '_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno1.mat'];
%     elseif fitchoice == 6
%         filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '.mat'];
%         resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_leavelow0_lambda' num2str(lambda) '_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno16KDcato2ions2.mat'];
%         if fitslot == 1
%                     resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_leavelow0_lambda' num2str(lambda) '_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno51KDcato2ions2.mat'];
%         end
%     end
% 
% 
%     load(filename)
% 
%     Calciums_used = Calciums;
% 
%     t_vec_all = 0:0.00001:0.1;
%     
%     Ca_0_init = 0.05;
% 
% 
%     load(resultsfilename, 'par')
% 
%     par_loop = par;
% 
% 
%     for k = [1 2 4 5 6]
%         for l = 15
%             nsyt = nsyts(l);
%             nslot = nslots(k);
% 
% 
%             disp(['fitSlots = ' num2str(fitslot) ', Lplusfit = ' num2str(LplusFit) ', excludeOutli = ' num2str(excludeOutl)])
% 
%             parfor m = 1:length(Calciums_used)
%                 Calcium = Calciums_used(m);
% 
%                 disp(['Calcium = ' num2str(Calcium) ', nsyt = ' num2str(nsyt) ', nslot = ' num2str(nslot)])
%                 test = dP_cells{m,l,k};
%                 if ~isempty(test)
%                     disp(['nsyt = ' num2str(nsyt) ', nslot = ' num2str(nslot)])
%                     disp('Already done or invalid')
%                 else
% 
%                     if k <= l
%                         par_here = par_loop;
% 
% 
% 
%                         par_here(8) = nsyt;
%                         par_here(14) = nslot;
% 
% 
%                         [QMatrix] = MakeQMatrix(par_here, Calcium);
% 
%                         if Calcium>=Ca_0_init
%                             Ca_0 = Ca_0_init
%                         else
%                             Ca_0 = Calcium;
%                         end
% 
%                         [SS_eq] = steady_state_newmethod(par_here, 1, Ca_0);
%                         SS_eq(end+1) = 0;
% 
%                         if Calcium>=1
%                             if Calcium >1
%                                 t_vec_fus3 = t_vec_all;
%                             elseif Calcium == 1
%                                 t_vec_fus3 = 0:0.00001:0.5;
%                             end
%                             [fused_over_time, below1_t] = P_function_limit(QMatrix, SS_eq, t_vec_fus3);
%                         else
%                             t_vec_fus3 = NaN;
%                             fused_over_time = NaN;
%                             below1_t = NaN;
%                         end
% 
%                         [dfused_over_time, ~] = dP_function_limit(QMatrix, SS_eq, t_vec_all, below1_t);
% 
%                         dP_cells{m,l,k} = dfused_over_time;
%                         P_cells{m,l,k} = fused_over_time;
%                         SS_eq_cells{m,l,k} = SS_eq;
%                         QMatrix_cells{m,l,k} = QMatrix;
%                         tvec_fus_cells{m,l,k} = t_vec_fus3;
%                         tvec_rate_cells{m,l,k} = t_vec_all;
%         %                 save('./Outputs/Figure_results//generic_functions_bestfit.mat', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_cells', 'Calciums', 'nsyts', 'nslots', '-v7.3')
%                     end
%                 end
%             end
% 
%             save(filename, 'par', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells', 'Calciums', 'nsyts', 'nslots', '-v7.3')
% 
%         end
%     end
% end

