function generate_cells_generic_functions()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script generates cells of the correct size for pre-calculated function results 
%%%%used in stochastic simulations with the analytical solution. 



PIPup = 0;

Calciums = [0.01 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1 1.25 1.5 1.75 2 2.5 3 4 5 6 7 8 9 10 20 30 40 50 60 70 80];
nsyts = 1:30;
nslots = 1:6;

lambda = 2;

Allost_IO = 0;
Allost_fit = 0;

for fitslot = 3
    for LplusFit = 0
        for excludeOutl = 0
            
            fitchoice = LplusFit*11 + 6;
            if Allost_IO
                
                if fitchoice == 17
                    filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_lambda' num2str(lambda) '.mat'];
                elseif fitchoice == 6
                    Lplus = 423;
                    filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '.mat'];
                end
                
                if PIPup
                    Lplus = 423;
                    filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_3sytsPIPup.mat'];
                end
                
                
            elseif ~Allost_IO
                if Allost_fit
                    Lplus = 423;
                    filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_A1.mat'];
                else
                   Lplus = 423;
                    filename = ['./Outputs/Figure_results/Generic_functions/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_A1_nofit.mat'];

                end
            end
            
            
                
                
            if ~isfile(filename)
            

                [dP_cells, P_cells, SS_eq_cells, QMatrix_cells, tvec_fus_cells, tvec_rate_cells] = deal(cell(length(Calciums), length(nsyts), length(nslots)));
            
            
                save(filename, 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells', 'Calciums', 'nsyts', 'nslots', '-v7.3')

            else
                warning('File already exists')
                disp('Exists')
            end
        end
    end
end
