function generate_cells_generic_functions_varyparameter()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script generates cells of the correct size for pre-calculated function results 
%%%%used in stochastic simulations with the analytical solution for figure 2 - figure 
%%%%supplement 3. 



Calciums = [0.01 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1 1.25 1.5 1.75 2 2.5 3 4 5 6 7 8 9 10 20 30 40 50 60 70 80];

param_factors = [1/5 1/3 1/2 1 2 3 5];
param_inds = [1 3 4 7];

lambda = 2;

nsyts = 1:30;
nslots = 1:6;


fitslot = 3;
LplusFit = 0;
excludeOutl = 0;

fitchoice = LplusFit*11 + 6;

param_numbering = {'1: konCa', '2: konPIP2', '3: PIP2', '4: f'};


for param_ind = 1:4
    for param_fact = [1/5 1/3 1/2 1 2 3 5]

        if fitchoice == 17
            filename = ['./Outputs/Figure_results/Generic_functions/varyparams/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_lambda' num2str(lambda) '_varyparams' num2str(param_ind) '_paramfact' num2str(param_fact) '.mat'];
        elseif fitchoice == 6
            Lplus = 423;
            filename = ['./Outputs/Figure_results/Generic_functions/varyparams/generic_functions_bestfit_slot' num2str(fitslot) '_fitchoice' num2str(fitchoice) '_exclude' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_varyparams' num2str(param_ind) '_paramfact' num2str(param_fact) '.mat'];
        end




        if ~isfile(filename)


            [dP_cells, P_cells, SS_eq_cells, QMatrix_cells, tvec_fus_cells, tvec_rate_cells] = deal(cell(length(Calciums), length(nsyts), length(nslots)));


            save(filename, 'param_inds', 'param_factors', 'param_numbering', 'dP_cells', 'P_cells', 'SS_eq_cells', 'QMatrix_cells', 'tvec_fus_cells', 'tvec_rate_cells', 'Calciums', '-v7.3')

        else
            warning('File already exists')
            disp('Exists')
        end
    end
end
