%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the 3D plot of costs in parameter exploration
%%%%(Figure 2 panel G)


load('Costs_explore_paramspace20210518.mat')

% f_ind_choice = 20;
colormap_onoff = 1;

semilogx_onoff = 1;

cam_hor = 137;
cam_ver = 24;

costs = Results(:,6)+2*Results(:,7);

k_on_Ca_choice = unique(Results(:,1));
k_on_PIP_choice = unique(Results(:,2));
PIP_conc_choice = unique(Results(:,3));
f_choice  = unique(Results(:,4));

costmin = min(costs);
costmax = max(costs);


cost_min = -141;
cost_middle = 1;
cost_max = 3e4;

num_colors = 5000;

col_ticks_normal_low = [-140 -100 -50];
col_ticks_normal_high = [ 1 10 100 1000 10000 3e4];

lownum = 3750;
highnum = 1250;

col_ticks_low_norm = ceil(lownum * (col_ticks_normal_low-cost_min)/(cost_middle-cost_min));
col_ticks_high_norm = (highnum * ((log10(col_ticks_normal_high)-log10(cost_middle))/(log10(cost_max)-log10(cost_middle)))) + lownum;


col_ticks = [col_ticks_low_norm col_ticks_high_norm];
col_labels = [col_ticks_normal_low col_ticks_normal_high];






bw = 4; %Width of bars for best fit
bc = 'k'; %Color of best fit bars
bc2 = 'm';




%     Q_maxes = fliplr(Q_maxes);
%     k_d_values = [1 1.2 1.4 1.6 1.8 2]*1e-6;


pars1 = k_on_Ca_choice;
pars2 = k_on_PIP_choice;
pars3 = PIP_conc_choice;
pars4 = f_choice;

par1_min = min(pars1);
par2_min = min(pars2);
par3_min = min(pars3);
par1_max = max(pars1);
par2_max = max(pars2);
par3_max = max(pars3);


xlimits = [par1_min par1_max];
ylimits = [par2_min par2_max];
zlimits = [par3_min par3_max];

xlabstring = 'k_{on, Ca2+} [\mu M^{-1}s^{-1}]';
ylabstring = 'k_{on, PIP2} [\mu M^{-1}s^{-1}]';
zlabstring = 'PIP2 conc. [\mu M]';


    load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross3_parinitno16_KDcato2ions2.mat', 'par')
    par1_best = round(par(1)*1e4)*1e-4;
    par2_best = round(par(3)*1e4)*1e-4;
    par3_best = round(par(4)*1e4)*1e-4;
    par4_best = round(par(7)*1e4)*1e-4;

    par1_best = par(1);
    par2_best = par(3);
    par3_best = par(4);
    par4_best = par(7);
    
    
    par1best_ind = find(round(pars1*1e4)*1e-4==round(par1_best*1e4)*1e-4);
    par2best_ind = find(round(pars2*1e4)*1e-4==round(par2_best*1e4)*1e-4);
    par3best_ind = find(round(pars3*1e4)*1e-4==round(par3_best*1e4)*1e-4);
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




sample_size = [length(k_on_Ca_choice) length(k_on_PIP_choice) length(PIP_conc_choice)];

[costs_plots] = deal(zeros(sample_size));




sim_num_total = prod(sample_size);


% figure
% hold on

[~, cmap, cost_min, cost_max] = cost_colorcode(1);








cost_ind = 1;

for k = 1:length(pars1)
    par1 = pars1(k);
    
    for l = 1:length(pars2)
        par2 = pars2(l);
        
        for m = 1:length(pars3)
            par3 = pars3(m);
            
                
                    
                if  ((mod(k,3)+mod(l,3)+mod(m,3))==0)
                    cost_plot = costs(cost_ind);
                    costs_plots(k,l,m) = cost_plot;
        %                     ppr_plots_det(k,l,m) = pprs_extr(1);

                    [rgb_vec, ~, ~, ~] = cost_colorcode(cost_plot);


                    x = par1;
                    y = par2;
                    z = par3;


        %                     [x_plot, y_plot, z_plot] = circle_cost(r1, r2, r3,x,y,z, semilogx_onoff);


        %             x_plot = 10^(log10(x_plot-xlimits(1))/(log10(xlimits(1))-log10(xlimits(2))))+xlimits(1);


                    if cost_plot > 1
                        o_size = 4;
                    else
                        o_size = 8;
                    end

                    h = plot3(x,y,z, 'o', 'MarkerSize', o_size, 'Color', rgb_vec, 'MarkerFaceColor', rgb_vec);%'EdgeAlpha', 0.1);
                    
%                     if (k == par1best_ind) && (l==par2best_ind) && (m==par3best_ind)
%                         h = plot3(x,y,z, 's', 'MarkerSize', 10, 'Color', 'k');%'EdgeAlpha', 0.1);
%                     end
                    
                    hold on

                end
%             clearvars ppr_extr_means ppr_plot pprs_extr num_ves_factor num_ves_factor_peak1 num_ves_factor_bothpeaks par_free num_ves_for_filename
            cost_ind = cost_ind + 1;
        end
    end
end


if semilogx_onoff == 1
set(gca, 'XScale', 'log')
set(gca, 'YScale', 'log')
set(gca, 'ZScale', 'log')
end
    

xlim(xlimits)
ylim(ylimits)
zlim(zlimits)
xlabel(xlabstring)
ylabel(ylabstring)
zlabel(zlabstring)


grid on

if colormap_onoff 
    colormap(gca, cmap);
%     caxis([cost_min cost_max])
    caxis([1 5000])
    cbar = colorbar;
    colorbar('Ticks', col_ticks, 'TickLabels', col_labels)
%     ylabel(cbar, 'cost')
end

view(cam_hor, cam_ver)
set(gca, 'FontName', 'Arial', 'FontSize', 20)%, 'xtick', xticks, 'ytick', yticks)%, 'FontSize', 25, 'ztick', [0 5 10])

set(gcf,'renderer','Painters')

ylim([1 ylimits(2)])
% zlim([10^-2 zlimits(2)])

xticks([0.1 1 10 100 1000 1e4])
yticks([0.1 1 10 100 1000 1e4])
zticks([0.1 1 10 100 1000 1e4])




% % % % 
% % % % 
% % % % %Three bars indicating best fit
% % % % if model == 4
% % % %     plot3([par1_best par1_best], [par2_best par2_best], [zlimits(1) par3_best], 'LineWidth', bw, 'Color', bc)
% % % %     plot3([xlimits(1) par1_best], [par2_best par2_best], [par3_best par3_best], 'LineWidth', bw, 'Color', bc)
% % % %     plot3([par1_best par1_best], [ylimits(1) par2_best], [par3_best par3_best], 'LineWidth', bw, 'Color', bc)
% % % % elseif model == 2
% % % %     plot3([par1_best par1_best], [par2_best par2_best], [zlimits(1) par3_best], 'LineWidth', bw, 'Color', bc)
% % % %     plot3([par1_best xlimits(2)], [par2_best par2_best], [par3_best par3_best], 'LineWidth', bw, 'Color', bc)
% % % %     plot3([par1_best par1_best], [ylimits(1) par2_best], [par3_best par3_best], 'LineWidth', bw, 'Color', bc)
% % % % end
