function [rgb_vec, cmap, cost_min, cost_max] = cost_colorcode(cost)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% cost_alt = 1;

cost_min = -140;
cost_middle = 1;
cost_max = 3e4;




cost_trans = log10(cost);

cost_middle_trans = log10(cost_middle);
cost_max_trans = log10(cost_max);

num_colors = 5000;
cmap = jet(num_colors);
% caxis([0 sqrt(3*4^2)])

lownum = 3750;
highnum = 1250;

if cost <= 1
    cost_norm = lownum * (cost-cost_min)/(cost_middle-cost_min);
else
    cost_norm = (highnum * (cost_trans-cost_middle_trans)/(cost_max_trans-cost_middle_trans)) + lownum;
end


rgb_vec = cmap(ceil(cost_norm),:);

% figure
% hold on
% for k = 1:5000
%     plot(k, k, 's', 'Color', cmap(k,:))
% end

% figure
% hold on
% 
% for k = 1:10
%     
%     ppr = k*0.2;
%     ppr_norm = ppr*num_colors/max_ppr;
% 
%     rgb_vec = cmap(round(ppr_norm),:);
%     
%      circle(k,k,k,k,rgb_vec)
% end
% 
% grid on


